/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dynamicsqlrow;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dynamicsqlrow.DynamicSQLRow;
import org.pentaho.di.trans.steps.dynamicsqlrow.DynamicSQLRowData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DynamicSQLRowMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DynamicSQLRowMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private String sqlfieldname;
    private int rowLimit;
    private boolean outerJoin;
    private boolean replacevars;
    public boolean queryonlyonchange;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isVariableReplace() {
        return this.replacevars;
    }

    public void setVariableReplace(boolean replacevars) {
        this.replacevars = replacevars;
    }

    public boolean isQueryOnlyOnChange() {
        return this.queryonlyonchange;
    }

    public void setQueryOnlyOnChange(boolean queryonlyonchange) {
        this.queryonlyonchange = queryonlyonchange;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSQLFieldName() {
        return this.sqlfieldname;
    }

    public void setSQLFieldName(String sqlfieldname) {
        this.sqlfieldname = sqlfieldname;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        DynamicSQLRowMeta retval = (DynamicSQLRowMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.outerJoin = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outer_join"));
            this.replacevars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"replace_vars"));
            this.queryonlyonchange = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"query_only_on_change"));
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowlimit"), (int)0);
            this.sqlfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"sql_fieldname");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.replacevars = false;
        this.sqlfieldname = null;
        this.queryonlyonchange = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.databaseMeta == null) {
            return;
        }
        Database db = new Database(loggingObject, this.databaseMeta);
        this.databases = new Database[]{db};
        RowMetaInterface add = null;
        String realSQL = this.sql;
        if (this.replacevars) {
            realSQL = space.environmentSubstitute(realSQL);
        }
        try {
            add = db.getQueryFields(realSQL, false);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                ValueMetaInterface v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(realSQL, false);
                for (int i = 0; i < add.size(); ++i) {
                    ValueMetaInterface v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"rowlimit", (int)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XMLHandler.addTagValue((String)"outer_join", (boolean)this.outerJoin));
        retval.append("    " + XMLHandler.addTagValue((String)"replace_vars", (boolean)this.replacevars));
        retval.append("    " + XMLHandler.addTagValue((String)"sql_fieldname", (String)this.sqlfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"query_only_on_change", (boolean)this.queryonlyonchange));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "rowlimit");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.outerJoin = rep.getStepAttributeBoolean(id_step, "outer_join");
            this.replacevars = rep.getStepAttributeBoolean(id_step, "replace_vars");
            this.sqlfieldname = rep.getStepAttributeString(id_step, "sql_fieldname");
            this.queryonlyonchange = rep.getStepAttributeBoolean(id_step, "query_only_on_change");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "rowlimit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "outer_join", this.outerJoin);
            rep.saveStepAttribute(id_transformation, id_step, "replace_vars", this.replacevars);
            rep.saveStepAttribute(id_transformation, id_step, "sql_fieldname", this.sqlfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "query_only_on_change", this.queryonlyonchange);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.sqlfieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            ValueMetaInterface vfield = prev.searchValueMeta(this.sqlfieldname);
            cr = vfield == null ? new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNotFound", (String[])new String[]{this.sqlfieldname}), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldFound", (String[])new String[]{this.sqlfieldname, vfield.getOrigin()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql == null || this.sql.length() == 0) return;
                error_message = "";
                RowMetaInterface r = db.getQueryFields(this.sql, true);
                if (r != null) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.QueryOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    return;
                }
                error_message = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                return;
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                return;
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DynamicSQLRow(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DynamicSQLRowData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaInterface out = prev.clone();
        this.getFields(out, stepMeta.getName(), new RowMetaInterface[]{info}, null, transMeta, repository, metaStore);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                ValueMetaInterface outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

