/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.resource;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceXmlPropertyEmitterInterface;

public class ResourceReference {
    private ResourceHolderInterface resourceReferenceHolder;
    private List<ResourceEntry> entries;

    public ResourceReference(ResourceHolderInterface resourceReferenceHolder, List<ResourceEntry> entries) {
        this.resourceReferenceHolder = resourceReferenceHolder;
        this.entries = entries;
    }

    public ResourceReference(ResourceHolderInterface resourceReferenceHolder) {
        this.resourceReferenceHolder = resourceReferenceHolder;
        this.entries = new ArrayList<ResourceEntry>();
    }

    public ResourceHolderInterface getReferenceHolder() {
        return this.resourceReferenceHolder;
    }

    public void setReferenceHolder(ResourceHolderInterface resourceReferenceHolder) {
        this.resourceReferenceHolder = resourceReferenceHolder;
    }

    public List<ResourceEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ResourceEntry> entries) {
        this.entries = entries;
    }

    public String toXml() {
        return this.toXml(null, 0);
    }

    public String toXml(ResourceXmlPropertyEmitterInterface injector) {
        return this.toXml(injector, 0);
    }

    public String toXml(int indentLevel) {
        return this.toXml(null, indentLevel);
    }

    public String toXml(ResourceXmlPropertyEmitterInterface injector, int indentLevel) {
        StringBuffer buff = new StringBuffer();
        this.addXmlElementWithAttribute(buff, indentLevel, "ActionComponent", "type", this.resourceReferenceHolder.getHolderType());
        this.addXmlElement(buff, ++indentLevel, "ComponentName", this.resourceReferenceHolder.getName());
        this.addXmlElement(buff, indentLevel, "ComponentId", this.resourceReferenceHolder.getTypeId());
        this.addXmlElement(buff, indentLevel, "ComponentResources");
        ++indentLevel;
        for (ResourceEntry entry : this.getEntries()) {
            buff.append(entry.toXml(indentLevel));
        }
        this.addXmlCloseElement(buff, --indentLevel, "ComponentResources");
        if (injector != null) {
            this.addXmlElement(buff, indentLevel, "ComponentProperties");
            buff.append(injector.getExtraResourceProperties(this.resourceReferenceHolder, ++indentLevel));
            this.addXmlCloseElement(buff, --indentLevel, "ComponentProperties");
        }
        this.addXmlCloseElement(buff, --indentLevel, "ActionComponent");
        return buff.toString();
    }

    public void addXmlElementWithAttribute(StringBuffer buff, int indentLevel, String elementName, String attrName, String attrValue) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append(" ").append(attrName).append("='");
        buff.append(attrValue).append("'>").append("\r\n");
    }

    public void addXmlCloseElement(StringBuffer buff, int indentLevel, String elementName) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("</").append(elementName).append(">").append("\r\n");
    }

    public void addXmlElement(StringBuffer buff, int indentLevel, String elementName) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append(">").append("\r\n");
    }

    public void addXmlElement(StringBuffer buff, int indentLevel, String elementName, String elementValue) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append("><![CDATA[").append(elementValue).append("]]></").append(elementName).append(">").append("\r\n");
    }
}

