/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.truncatetables;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryTruncateTables
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryTruncateTables.class;
    public boolean argFromPrevious = false;
    private DatabaseMeta connection = null;
    public String[] arguments = null;
    public String[] schemaname = null;
    private int nrErrors = 0;
    private int nrSuccess = 0;
    boolean continueProcess = true;

    public JobEntryTruncateTables(String n) {
        super(n, "");
    }

    public JobEntryTruncateTables() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryTruncateTables je = (JobEntryTruncateTables)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.schemaname = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.schemaname[i] = XMLHandler.getTagValue((Node)fnode, (String)"schemaname");
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.schemaname = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.schemaname[a] = rep.getJobEntryAttributeString(id_jobentry, a, "schemaname");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "schemaname", this.schemaname[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    private boolean truncateTables(String tablename, String schemaname, Database db) {
        boolean retval = false;
        String realSchemaname = schemaname;
        String realTablename = tablename;
        try {
            if (!Const.isEmpty((String)realSchemaname)) {
                realTablename = db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename);
            }
            if (db.checkTableExists(realTablename)) {
                if (!Const.isEmpty((String)realSchemaname)) {
                    db.truncateTable(realSchemaname, tablename);
                } else {
                    db.truncateTable(tablename);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.Log.TableTruncated", (String[])new String[]{realTablename}));
                }
                retval = true;
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.Error.CanNotFindTable", (String[])new String[]{realTablename}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.Error.CanNotTruncateTables", (String[])new String[]{realTablename, e.toString()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        rows = result.getRows();
        resultRow = null;
        result.setResult(true);
        this.nrErrors = 0;
        this.continueProcess = true;
        this.nrSuccess = 0;
        if (this.argFromPrevious) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (rows.size() == 0) {
                return result;
            }
        }
        if (this.connection != null) {
            db = new Database((LoggingObjectInterface)this, this.connection);
            db.shareVariablesWith((VariableSpace)this);
            try {
                db.connect(this.parentJob.getTransactionId(), null);
                if (this.argFromPrevious && rows != null) {
                    for (iteration = 0; iteration < rows.size() && !this.parentJob.isStopped() && this.continueProcess; ++iteration) {
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        tablename_previous = resultRow.getString(0, null);
                        schemaname_previous = resultRow.getString(1, null);
                        if (!Const.isEmpty((String)tablename_previous)) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.ProcessingRow", (String[])new String[]{tablename_previous, schemaname_previous}));
                            }
                            if (this.truncateTables(tablename_previous, schemaname_previous, db)) {
                                this.updateSuccess();
                                continue;
                            }
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.RowEmpty", (String[])new String[0]));
                    }
                }
                if (this.arguments == null) ** GOTO lbl59
                for (i = 0; i < this.arguments.length && !this.parentJob.isStopped() && this.continueProcess; ++i) {
                    realTablename = this.environmentSubstitute(this.arguments[i]);
                    realSchemaname = this.environmentSubstitute(this.schemaname[i]);
                    if (!Const.isEmpty((String)realTablename)) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.ProcessingArg", (String[])new String[]{this.arguments[i], this.schemaname[i]}));
                        }
                        if (this.truncateTables(realTablename, realSchemaname, db)) {
                            this.updateSuccess();
                            continue;
                        }
                        this.updateErrors();
                        continue;
                    }
                    this.logError(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.ArgEmpty", (String[])new String[]{this.arguments[i], this.schemaname[i]}));
                }
            }
            catch (Exception dbe) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(JobEntryTruncateTables.PKG, (String)"JobEntryTruncateTables.NoDbConnection", (String[])new String[0]));
        }
lbl59:
        // 5 sources

        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesDeleted((long)this.nrSuccess);
        result.setResult(this.nrErrors == 0);
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        this.continueProcess = false;
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }
}

