/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.BaseImportRule;
import org.pentaho.di.job.JobMeta;
import org.w3c.dom.Node;

public class JobHasJobLogConfiguredImportRule
extends BaseImportRule
implements ImportRuleInterface {
    private String schemaName;
    private String tableName;
    private String connectionName;

    @Override
    public List<ImportValidationFeedback> verifyRule(Object subject) {
        ArrayList<ImportValidationFeedback> feedback = new ArrayList<ImportValidationFeedback>();
        if (!this.isEnabled()) {
            return feedback;
        }
        if (!(subject instanceof JobMeta)) {
            return feedback;
        }
        JobMeta jobMeta = (JobMeta)subject;
        JobLogTable jobLogTable = jobMeta.getJobLogTable();
        if (!jobLogTable.isDefined()) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The logging table is not defined"));
        } else {
            if (!Const.isEmpty((String)this.schemaName)) {
                if (this.schemaName.equals(jobLogTable.getSchemaName())) {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "The schema name is set to: " + this.schemaName));
                } else {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The schema name is not set to: " + this.schemaName));
                }
            }
            if (!Const.isEmpty((String)this.tableName)) {
                if (this.tableName.equals(jobLogTable.getTableName())) {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "The table name is set to: " + this.tableName));
                } else {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The table name is not set to: " + this.tableName));
                }
            }
            if (!Const.isEmpty((String)this.connectionName)) {
                if (this.connectionName.equals(jobLogTable.getDatabaseMeta().getName())) {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "The database connection used for logging is: " + this.connectionName));
                } else {
                    feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The database connection used for logging is not: " + this.connectionName));
                }
            }
            if (feedback.isEmpty()) {
                feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "The logging table is correctly defined"));
            }
        }
        return feedback;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(super.getXML());
        xml.append(XMLHandler.addTagValue((String)"schema_name", (String)this.schemaName));
        xml.append(XMLHandler.addTagValue((String)"table_name", (String)this.tableName));
        xml.append(XMLHandler.addTagValue((String)"connection_name", (String)this.connectionName));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    @Override
    public void loadXML(Node ruleNode) throws KettleException {
        super.loadXML(ruleNode);
        this.schemaName = XMLHandler.getTagValue((Node)ruleNode, (String)"schema_name");
        this.tableName = XMLHandler.getTagValue((Node)ruleNode, (String)"table_name");
        this.connectionName = XMLHandler.getTagValue((Node)ruleNode, (String)"connection_name");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }
}

