/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.PluginTypeListener;

public class LifecycleSupport {
    @VisibleForTesting
    protected static PluginRegistry registry = PluginRegistry.getInstance();
    private Set<LifecycleListener> lifeListeners = Collections.synchronizedSet(LifecycleSupport.loadPlugins(LifecyclePluginType.class, LifecycleListener.class));
    private boolean started;
    private LifeEventHandler handler;

    public LifecycleSupport() {
        PluginRegistry registry = PluginRegistry.getInstance();
        registry.addPluginListener(LifecyclePluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                LifecycleListener listener = null;
                try {
                    listener = (LifecycleListener)PluginRegistry.getInstance().loadClass((PluginInterface)serviceObject);
                }
                catch (KettlePluginException e) {
                    e.printStackTrace();
                    return;
                }
                LifecycleSupport.this.lifeListeners.add(listener);
                if (LifecycleSupport.this.started) {
                    try {
                        listener.onStart(LifecycleSupport.this.handler);
                    }
                    catch (LifecycleException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void pluginRemoved(Object serviceObject) {
                LifecycleSupport.this.lifeListeners.remove(serviceObject);
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    static <T> Set<T> loadPlugins(Class<? extends PluginTypeInterface> pluginType, Class<T> mainPluginClass) {
        HashSet<Object> pluginInstances = new HashSet<Object>();
        List plugins = registry.getPlugins(pluginType);
        for (PluginInterface plugin : plugins) {
            try {
                pluginInstances.add(registry.loadClass(plugin, mainPluginClass));
            }
            catch (Throwable e) {
                LogChannel.GENERAL.logError("Unexpected error loading class for plugin " + plugin.getName(), e);
            }
        }
        return pluginInstances;
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        this.handler = handler;
        this.started = true;
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onStart(handler);
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
        for (LifecycleListener listener : this.lifeListeners) {
            listener.onExit(handler);
        }
    }
}

