/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.di.core.compress.CompressionInputStream;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionProvider;

public class NoneCompressionProvider
implements CompressionProvider {
    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new NoneCompressionInputStream(in, this);
    }

    @Override
    public boolean supportsInput() {
        return true;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new NoneCompressionOutputStream(out, this);
    }

    @Override
    public boolean supportsOutput() {
        return true;
    }

    @Override
    public String getDescription() {
        return "No compression";
    }

    @Override
    public String getName() {
        return "None";
    }

    @Override
    public String getDefaultExtension() {
        return null;
    }

    public static class NoneCompressionOutputStream
    extends CompressionOutputStream {
        public NoneCompressionOutputStream(OutputStream out, CompressionProvider provider) {
            super(out, provider);
        }
    }

    public static class NoneCompressionInputStream
    extends CompressionInputStream {
        public NoneCompressionInputStream(InputStream in, CompressionProvider provider) {
            super(in, provider);
        }
    }
}

