/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.auth.kerberos;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang.ClassUtils;

public class LoginContextInvocationHandler<T>
implements InvocationHandler {
    private final T delegate;
    private final LoginContext loginContext;
    private final Set<Class<?>> interfacesToDelegate;

    public LoginContextInvocationHandler(T delegate, LoginContext loginContext) {
        this(delegate, loginContext, new HashSet());
    }

    public LoginContextInvocationHandler(T delegate, LoginContext loginContext, Set<Class<?>> interfacesToDelegate) {
        this.delegate = delegate;
        this.loginContext = loginContext;
        this.interfacesToDelegate = interfacesToDelegate;
    }

    public static <T> T forObject(T delegate, LoginContext loginContext, Set<Class<?>> interfacesToDelegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ClassUtils.getAllInterfaces(delegate.getClass()).toArray(new Class[0]), new LoginContextInvocationHandler<T>(delegate, loginContext, interfacesToDelegate));
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            return Subject.doAs(this.loginContext.getSubject(), new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Object result = method.invoke(LoginContextInvocationHandler.this.delegate, args);
                    if (result != null) {
                        for (Class<?> iface : result.getClass().getInterfaces()) {
                            if (!LoginContextInvocationHandler.this.interfacesToDelegate.contains(iface)) continue;
                            result = LoginContextInvocationHandler.forObject(result, LoginContextInvocationHandler.this.loginContext, LoginContextInvocationHandler.this.interfacesToDelegate);
                            break;
                        }
                    }
                    return result;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                throw ((InvocationTargetException)e.getCause()).getCause();
            }
            throw e;
        }
    }
}

