/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.metrics;

import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.StringUtil;

public class MetricsDuration {
    private Date date;
    private Date endDate;
    private String description;
    private String subject;
    private String logChannelId;
    private Long duration;
    private Long count;

    public MetricsDuration(Date date, String description, String subject, String logChannelId, Long duration) {
        this(date, description, subject, logChannelId, duration, 1L);
    }

    public MetricsDuration(Date date, String description, String subject, String logChannelId, Long duration, Long count) {
        this.date = date;
        this.description = description;
        this.subject = subject;
        this.logChannelId = logChannelId;
        this.duration = duration;
        this.count = count;
        this.endDate = new Date(date.getTime() + duration);
    }

    public String toString() {
        if (Const.isEmpty(this.subject)) {
            return this.description + " @ " + StringUtil.getFormattedDateTime(this.date, true) + " : " + (this.duration == null ? "-" : this.duration.toString()) + (this.count == null ? "" : " (x" + this.count + ")");
        }
        return this.description + " / " + this.subject + " @ " + StringUtil.getFormattedDateTime(this.date, true) + " : " + (this.duration == null ? "-" : this.duration.toString()) + (this.count == null ? "" : " (x" + this.count + ")");
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void incrementCount() {
        this.count = this.count == null ? Long.valueOf(1L) : Long.valueOf(this.count + 1L);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

