/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.web.util.WebResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class FontWebResourceHandler
implements WebResourceHandler {
    public static final String REQUEST_PARAMETER_FONT_NAME = "font";

    @Override
    public boolean handleResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, HttpServletResponse response) {
        HtmlFontFamily htmlFontFamily;
        String fontName = request.getParameter(REQUEST_PARAMETER_FONT_NAME);
        if (fontName != null && (htmlFontFamily = HtmlFontFamily.getInstance(jasperReportsContext, fontName)) != null) {
            response.setContentType("text/css");
            try {
                String basePath = this.getResourceBasePath(jasperReportsContext, request);
                byte[] resourceData = this.processFont(jasperReportsContext, basePath, htmlFontFamily);
                response.getOutputStream().write(resourceData);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            return true;
        }
        return false;
    }

    protected byte[] processFont(JasperReportsContext jasperReportsContext, String basePath, HtmlFontFamily htmlFontFamily) {
        FontFamilyHtmlResourceHandler resourceHandler = new FontFamilyHtmlResourceHandler(basePath, htmlFontFamily);
        String fontCss = HtmlFontUtil.getInstance(jasperReportsContext).getHtmlFont((HtmlResourceHandler)resourceHandler, null, htmlFontFamily, true, true);
        try {
            return fontCss.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getResourceBasePath(JasperReportsContext jasperReportsContext, HttpServletRequest request) {
        return request.getContextPath() + WebUtil.getInstance(jasperReportsContext).getResourcesPath() + "/";
    }

    public static class FontFamilyHtmlResourceHandler
    implements HtmlResourceHandler {
        private String basePath;
        private Map<String, String> fontFaceIds;

        public FontFamilyHtmlResourceHandler(String basePath, HtmlFontFamily htmlFontFamily) {
            HtmlFont htmlFont;
            this.basePath = basePath;
            this.fontFaceIds = new HashMap<String, String>();
            FontFamily fontFamily = htmlFontFamily.getFontFamily();
            FontFace fontFace = fontFamily.getNormalFace();
            if (fontFace != null) {
                htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, false);
                this.addHtmlFont(htmlFont);
            }
            if ((fontFace = fontFamily.getBoldFace()) != null) {
                htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, false);
                this.addHtmlFont(htmlFont);
            }
            if ((fontFace = fontFamily.getItalicFace()) != null) {
                htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, false, true);
                this.addHtmlFont(htmlFont);
            }
            if ((fontFace = fontFamily.getBoldItalicFace()) != null) {
                htmlFont = HtmlFont.getInstance(htmlFontFamily, htmlFontFamily.getLocale(), fontFace, true, true);
                this.addHtmlFont(htmlFont);
            }
        }

        protected void addHtmlFont(HtmlFont htmlFont) {
            this.fontFaceIds.put(htmlFont.getId() + ".ttf", htmlFont.getTtf());
            this.fontFaceIds.put(htmlFont.getId() + ".eot", htmlFont.getEot());
            this.fontFaceIds.put(htmlFont.getId() + ".woff", htmlFont.getWoff());
            this.fontFaceIds.put(htmlFont.getId() + ".svg", htmlFont.getSvg());
        }

        @Override
        public String getResourcePath(String id) {
            if (this.fontFaceIds.containsKey(id)) {
                return this.basePath + this.fontFaceIds.get(id);
            }
            return this.basePath + id;
        }

        @Override
        public void handleResource(String id, byte[] data) {
        }
    }
}

