/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;

public class LuceneSimpleAnalyzer
extends Analyzer {
    private boolean isCaseSensitive;
    private boolean removeAccents;

    public LuceneSimpleAnalyzer(boolean isCaseSensitive, boolean removeAccents) {
        this.isCaseSensitive = isCaseSensitive;
        this.removeAccents = true;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        WhitespaceTokenizer source;
        WhitespaceTokenizer result = source = new WhitespaceTokenizer();
        if (!this.isCaseSensitive) {
            result = new LowerCaseFilter((TokenStream)source);
        }
        if (this.removeAccents) {
            result = new ASCIIFoldingFilter((TokenStream)result);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

