/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.charts.JRCategoryAxisFormat;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.util.JRAxisFormat;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.xml.ChartEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public class JRChartFactory
extends JRBaseFactory {
    public Object createObject(Attributes atts) {
        String chartCustomizerClass;
        EvaluationTimeEnum evaluationTime;
        JRXmlLoader xmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        JRDesignChart chart = (JRDesignChart)this.digester.peek();
        String isShowLegend = atts.getValue("isShowLegend");
        if (isShowLegend != null && isShowLegend.length() > 0) {
            chart.setShowLegend(Boolean.valueOf(isShowLegend));
        }
        if ((evaluationTime = EvaluationTimeEnum.getByName(atts.getValue("evaluationTime"))) != null) {
            chart.setEvaluationTime(evaluationTime);
        }
        if (chart.getEvaluationTimeValue() == EvaluationTimeEnum.GROUP) {
            xmlLoader.addGroupReference(new ChartEvaluationGroupReference(chart));
            String groupName = atts.getValue("evaluationGroup");
            if (groupName != null) {
                JRDesignGroup group = new JRDesignGroup();
                group.setName(groupName);
                chart.setEvaluationGroup(group);
            }
        }
        chart.setLinkType(atts.getValue("hyperlinkType"));
        chart.setLinkTarget(atts.getValue("hyperlinkTarget"));
        String bookmarkLevelAttr = atts.getValue("bookmarkLevel");
        if (bookmarkLevelAttr != null) {
            chart.setBookmarkLevel(Integer.parseInt(bookmarkLevelAttr));
        }
        if ((chartCustomizerClass = atts.getValue("customizerClass")) != null && chartCustomizerClass.length() > 0) {
            chart.setCustomizerClass(chartCustomizerClass);
        }
        chart.setRenderType(atts.getValue("renderType"));
        chart.setTheme(atts.getValue("theme"));
        return chart;
    }

    public static class JRCategoryAxisFormatFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) throws JRException {
            JRCategoryAxisFormat categoryAxisFormat = (JRCategoryAxisFormat)this.digester.peek();
            String labelRotation = atts.getValue("labelRotation");
            if (labelRotation != null && labelRotation.length() > 0) {
                categoryAxisFormat.setCategoryAxisTickLabelRotation(Double.valueOf(labelRotation));
            }
            return categoryAxisFormat;
        }
    }

    public static class JRChartAxisFormatFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) throws JRException {
            Color color;
            JRAxisFormat axisLabel = new JRAxisFormat();
            String attrValue = atts.getValue("labelColor");
            if (attrValue != null && attrValue.length() > 0) {
                color = JRColorUtil.getColor(attrValue, null);
                axisLabel.setLabelColor(color);
            }
            if ((attrValue = atts.getValue("tickLabelColor")) != null && attrValue.length() > 0) {
                color = JRColorUtil.getColor(attrValue, null);
                axisLabel.setTickLabelColor(color);
            }
            if ((attrValue = atts.getValue("tickLabelMask")) != null && attrValue.length() > 0) {
                axisLabel.setTickLabelMask(attrValue);
            }
            if ((attrValue = atts.getValue("verticalTickLabels")) != null && attrValue.length() > 0) {
                axisLabel.setVerticalTickLabel(Boolean.valueOf(attrValue));
            }
            if ((attrValue = atts.getValue("axisLineColor")) != null && attrValue.length() > 0) {
                color = JRColorUtil.getColor(attrValue, null);
                axisLabel.setLineColor(color);
            }
            return axisLabel;
        }
    }

    public static class JRChartLegendFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) throws JRException {
            EdgeEnum position;
            Color color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String attrValue = atts.getValue("textColor");
            if (attrValue != null && attrValue.length() > 0) {
                color = JRColorUtil.getColor(attrValue, null);
                chart.setLegendColor(color);
            }
            if ((attrValue = atts.getValue("backgroundColor")) != null && attrValue.length() > 0) {
                color = JRColorUtil.getColor(attrValue, null);
                chart.setLegendBackgroundColor(color);
            }
            if ((position = EdgeEnum.getByName(atts.getValue("position"))) != null) {
                chart.setLegendPosition(position);
            }
            return chart;
        }
    }

    public static class JRChartSubtitleFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) {
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            Color color = JRColorUtil.getColor(atts.getValue("color"), Color.black);
            if (color != null) {
                chart.setSubtitleColor(color);
            }
            return chart;
        }
    }

    public static class JRChartTitleFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) {
            Color color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            EdgeEnum position = EdgeEnum.getByName(atts.getValue("position"));
            if (position != null) {
                chart.setTitlePosition(position);
            }
            if ((color = JRColorUtil.getColor(atts.getValue("color"), Color.black)) != null) {
                chart.setTitleColor(color);
            }
            return chart;
        }
    }
}

