/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;

public class JsonNodeContainer {
    private List<JRJsonNode> nodes = new ArrayList<JRJsonNode>();

    public JsonNodeContainer() {
    }

    public JsonNodeContainer(JRJsonNode node) {
        this();
        this.nodes.add(node);
    }

    public void add(JRJsonNode node) {
        this.nodes.add(node);
    }

    public void addNodes(List<JRJsonNode> nodes) {
        this.nodes.addAll(nodes);
    }

    public List<JRJsonNode> getNodes() {
        return this.nodes;
    }

    public List<JRJsonNode> getContainerNodes() {
        if (this.nodes.size() == 1 && this.nodes.get(0).getDataNode().isArray()) {
            ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
            JRJsonNode parentNode = this.nodes.get(0);
            JsonNode arrayNode = parentNode.getDataNode();
            for (JsonNode deeper : arrayNode) {
                result.add(parentNode.createChild(deeper));
            }
            return result;
        }
        return this.nodes;
    }

    public JRJsonNode getFirst() {
        return this.nodes.get(0);
    }

    public int getSize() {
        return this.nodes.size();
    }

    public int getContainerSize() {
        if (this.nodes.size() == 1 && this.nodes.get(0).getDataNode().isArray()) {
            return this.nodes.get(0).getDataNode().size();
        }
        return this.nodes.size();
    }
}

