/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.BandReportFillerParent;
import net.sf.jasperreports.engine.fill.ElementRange;
import net.sf.jasperreports.engine.fill.ElementRangeContents;
import net.sf.jasperreports.engine.fill.ElementRangeUtil;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.SimpleElementRange;
import net.sf.jasperreports.engine.fill.SimpleGroupFooterElementRange;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import org.apache.commons.javaflow.api.continuable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVerticalFiller
extends JRBaseFiller {
    private static final Log log = LogFactory.getLog(JRVerticalFiller.class);
    protected boolean hasDetailOnPage;

    protected JRVerticalFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        this(jasperReportsContext, jasperReport, null);
    }

    public JRVerticalFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport, BandReportFillerParent parent) throws JRException {
        this(jasperReportsContext, (JasperReportSource)SimpleJasperReportSource.from(jasperReport), parent);
    }

    public JRVerticalFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, BandReportFillerParent parent) throws JRException {
        super(jasperReportsContext, reportSource, parent);
        this.setPageHeight(this.pageHeight);
    }

    public boolean hasDetailOnPage() {
        return this.hasDetailOnPage;
    }

    @Override
    protected void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.columnFooterOffsetY = pageHeight - this.bottomMargin - this.pageFooter.getHeight() - this.columnFooter.getHeight();
        this.lastPageColumnFooterOffsetY = pageHeight - this.bottomMargin - this.lastPageFooter.getHeight() - this.columnFooter.getHeight();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filler " + this.fillerId + " - pageHeight: " + pageHeight + ", columnFooterOffsetY: " + this.columnFooterOffsetY + ", lastPageColumnFooterOffsetY: " + this.lastPageColumnFooterOffsetY));
        }
    }

    @Override
    @continuable
    protected synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": no data"));
            }
            switch (this.getWhenNoDataType()) {
                case ALL_SECTIONS_NO_DETAIL: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": all sections"));
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables(ResetTypeEnum.REPORT, IncrementTypeEnum.REPORT);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.printPageContentsWidth = 0;
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.isFirstPageBand = true;
                    this.isFirstColumnBand = true;
                    this.isCrtRecordOnPage = false;
                    this.isCrtRecordOnColumn = false;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeader((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case BLANK_PAGE: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": blank page"));
                    }
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    break;
                }
                case NO_DATA_SECTION: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": all sections"));
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables(ResetTypeEnum.REPORT, IncrementTypeEnum.REPORT);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.isFirstPageBand = true;
                    this.isFirstColumnBand = true;
                    this.isCrtRecordOnPage = false;
                    this.isCrtRecordOnColumn = false;
                    this.fillBackground();
                    this.fillNoData();
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Fill " + this.fillerId + ": no pages"));
                }
            }
        }
        this.recordUsedPageHeight(this.offsetY + this.bottomMargin);
        if (this.ignorePagination) {
            this.jasperPrint.setPageHeight(this.usedPageHeight);
        }
        if (this.isSubreport()) {
            this.addPageToParent(true);
        } else {
            this.addLastPageBookmarks();
            this.detectPart();
        }
        if (this.bookmarkHelper != null) {
            this.jasperPrint.setBookmarks(this.bookmarkHelper.getRootBookmarks());
        }
    }

    @continuable
    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables(ResetTypeEnum.REPORT, IncrementTypeEnum.REPORT);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.printPageContentsWidth = 0;
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.isFirstPageBand = true;
        this.isFirstColumnBand = true;
        this.isCrtRecordOnPage = false;
        this.isCrtRecordOnColumn = false;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeader((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    @continuable
    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables(ResetTypeEnum.GROUP, IncrementTypeEnum.GROUP);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    @continuable
    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    @continuable
    private void fillTitle() throws JRException {
        if (log.isDebugEnabled() && !this.title.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": title at " + this.offsetY));
        }
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getBreakHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY);
            if (this.title.willOverflow() && this.title.isSplitPrevented() && !this.title.isSplitTypePreventInhibited()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.isCrtRecordOnPage = true;
            this.isCrtRecordOnColumn = true;
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    @continuable
    private void fillPageHeader(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.pageHeader.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": page header at " + this.offsetY));
        }
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            int reattempts = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --reattempts;
            }
            boolean filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            for (int i = 0; !filled && i < reattempts; ++i) {
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.resolvePageBoundElements(evaluation);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            }
            if (!filled) {
                throw new JRRuntimeException("fill.common.filler.page.header.overflow.infinite.loop", (Object[])null);
            }
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.hasDetailOnPage = false;
        this.isNewPage = true;
    }

    private boolean fillBandNoOverflow(JRFillBand band, byte evaluation) throws JRException {
        boolean overflow;
        int availableHeight = this.columnFooterOffsetY - this.offsetY;
        boolean bl = overflow = availableHeight < band.getHeight();
        if (!overflow) {
            band.evaluate(evaluation);
            JRPrintBand printBand = band.fill(availableHeight);
            overflow = band.willOverflow();
            if (overflow) {
                band.rewind();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnColumn = this.isCrtRecordOnPage = evaluation == 3;
                this.resolveBandBoundElements(band, evaluation);
            }
        }
        return !overflow;
    }

    @continuable
    private void fillColumnHeader(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnHeader.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": column header at " + this.offsetY));
        }
        this.setNewPageColumnInBands();
        this.isFirstColumnBand = true;
        this.columnHeader.evaluatePrintWhenExpression(evaluation);
        if (this.columnHeader.isToPrint()) {
            int reattempts = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --reattempts;
            }
            this.setOffsetX();
            boolean filled = this.fillBandNoOverflow(this.columnHeader, evaluation);
            for (int i = 0; !filled && i < reattempts; ++i) {
                while (this.columnIndex < this.columnCount - 1) {
                    this.resolveGroupBoundElements(evaluation, false);
                    this.resolveColumnBoundElements(evaluation);
                    this.scriptlet.callBeforeColumnInit();
                    this.calculator.initializeVariables(ResetTypeEnum.COLUMN, IncrementTypeEnum.COLUMN);
                    this.scriptlet.callAfterColumnInit();
                    ++this.columnIndex;
                    this.setOffsetX();
                    this.offsetY = this.columnHeaderOffsetY;
                    this.isCrtRecordOnColumn = false;
                    this.setColumnNumberVar();
                }
                this.fillPageFooter(evaluation);
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.resolvePageBoundElements(evaluation);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader(evaluation);
                filled = this.fillBandNoOverflow(this.columnHeader, evaluation);
            }
            if (!filled) {
                throw new JRRuntimeException("fill.common.filler.column.header.overflow.infinite.loop", (Object[])null);
            }
        }
        this.isNewColumn = true;
    }

    @continuable
    private void fillGroupHeaders(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if (!isFillAll && !group.hasChanged()) continue;
                this.fillGroupHeader(group);
            }
        }
    }

    @continuable
    private void fillGroupHeader(JRFillGroup group) throws JRException {
        JRFillSection groupHeaderSection = (JRFillSection)group.getGroupHeaderSection();
        if (log.isDebugEnabled() && !groupHeaderSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + group.getName() + " header at " + this.offsetY));
        }
        if ((group.isStartNewPage() || group.isResetPageNumber()) && !this.isNewPage) {
            this.fillPageBreak(group.isResetPageNumber(), this.isCrtRecordOnPage ? (byte)3 : 1, (byte)3, true);
        } else if (group.isStartNewColumn() && !this.isNewColumn) {
            this.fillColumnBreak(this.isCrtRecordOnColumn ? (byte)3 : 1, (byte)3);
        }
        boolean isFirstHeaderBandToPrint = true;
        boolean isGroupReset = false;
        JRFillBand[] groupHeaderBands = groupHeaderSection.getFillBands();
        for (int i = 0; i < groupHeaderBands.length; ++i) {
            JRFillBand groupHeaderBand = groupHeaderBands[i];
            groupHeaderBand.evaluatePrintWhenExpression((byte)3);
            if (groupHeaderBand.isToPrint()) {
                while (groupHeaderBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY || isFirstHeaderBandToPrint && group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillColumnBreak(this.isCrtRecordOnColumn ? (byte)3 : 1, (byte)3);
                }
            }
            if (!isGroupReset && (isFirstHeaderBandToPrint || i == groupHeaderBands.length - 1)) {
                this.setNewGroupInBands(group);
                group.setFooterPrinted(false);
                group.resetDetailsCount();
                isGroupReset = true;
            }
            ElementRange elementRange = null;
            if ((group.isKeepTogether() && !this.isNewColumn || group.getMinDetailsToStartFromTop() > 0) && (elementRange = group.getKeepTogetherElementRange()) == null) {
                elementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
                group.setKeepTogetherElementRange(elementRange);
            }
            if (!groupHeaderBand.isToPrint()) continue;
            this.fillColumnBand(groupHeaderBand, (byte)3, false);
            SimpleElementRange newElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
            ElementRangeUtil.expandOrIgnore(elementRange, newElementRange);
            this.isFirstPageBand = false;
            this.isFirstColumnBand = false;
            isFirstHeaderBandToPrint = false;
        }
        group.setHeaderPrinted(true);
    }

    @continuable
    private void fillGroupHeadersReprint(byte evaluation, boolean isPageBreak) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group;
            for (int i = 0; i < this.groups.length && ((group = this.groups[i]).getKeepTogetherElementRange() == null || !group.isKeepTogether() && group.hasMinDetails()); ++i) {
                if (!group.isReprintHeaderOnEachColumn() && (!group.isReprintHeaderOnEachPage() || !isPageBreak) || group.hasChanged() && (!group.hasChanged() || !group.isHeaderPrinted())) continue;
                this.fillGroupHeaderReprint(this.groups[i], evaluation);
            }
        }
    }

    @continuable
    private void fillGroupHeaderReprint(JRFillGroup group, byte evaluation) throws JRException {
        JRFillSection groupHeaderSection = (JRFillSection)group.getGroupHeaderSection();
        JRFillBand[] groupHeaderBands = groupHeaderSection.getFillBands();
        for (int i = 0; i < groupHeaderBands.length; ++i) {
            JRFillBand groupHeaderBand = groupHeaderBands[i];
            groupHeaderBand.evaluatePrintWhenExpression(evaluation);
            if (!groupHeaderBand.isToPrint()) continue;
            while (groupHeaderBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(evaluation, evaluation);
            }
            this.fillColumnBand(groupHeaderBand, evaluation, false);
            if (this.columnCount <= 1) continue;
            this.isFirstColumnBand = false;
        }
    }

    @continuable
    private void fillDetail() throws JRException {
        if (log.isDebugEnabled() && !this.detailSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": detail at " + this.offsetY));
        }
        if (!this.detailSection.areAllPrintWhenExpressionsNull()) {
            this.calculator.estimateVariables();
        }
        JRFillBand[] detailBands = this.detailSection.getFillBands();
        for (int i = 0; i < detailBands.length; ++i) {
            JRFillBand detailBand = detailBands[i];
            detailBand.evaluatePrintWhenExpression((byte)2);
            if (!detailBand.isToPrint()) continue;
            while (detailBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(this.isCrtRecordOnColumn ? (byte)3 : 1, (byte)3);
            }
            break;
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables(true);
        this.scriptlet.callAfterDetailEval();
        this.detailElementRange = null;
        boolean keepDetailElementRangeForOrphanFooter = true;
        boolean atLeastOneDetailBandPrinted = false;
        for (int i = 0; i < detailBands.length; ++i) {
            JRFillBand detailBand = detailBands[i];
            detailBand.evaluatePrintWhenExpression((byte)3);
            if (!detailBand.isToPrint()) continue;
            while (detailBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(this.isCrtRecordOnColumn ? (byte)3 : 1, (byte)3);
            }
            if (keepDetailElementRangeForOrphanFooter && this.detailElementRange == null) {
                this.detailElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
            }
            this.fillColumnBand(detailBand, (byte)3, !atLeastOneDetailBandPrinted);
            if (this.detailElementRange == null) {
                keepDetailElementRangeForOrphanFooter = false;
            } else {
                SimpleElementRange newElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
                ElementRangeUtil.expandOrIgnore(this.detailElementRange, newElementRange);
            }
            atLeastOneDetailBandPrinted = true;
            this.isFirstPageBand = false;
            this.isFirstColumnBand = false;
        }
        if (atLeastOneDetailBandPrinted && this.groups != null) {
            for (JRFillGroup group : this.groups) {
                group.incrementDetailsCount();
            }
        }
        this.hasDetailOnPage = atLeastOneDetailBandPrinted;
        this.isNewPage = false;
        this.isNewColumn = false;
    }

    @continuable
    private void fillGroupFooters(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group;
            int i;
            byte evaluation = isFillAll ? (byte)3 : 1;
            this.preventOrphanFootersMinLevel = null;
            for (i = this.groups.length - 1; i >= 0; --i) {
                group = this.groups[i];
                if (!isFillAll && !group.hasChanged() || !group.isPreventOrphanFooter()) continue;
                this.preventOrphanFootersMinLevel = i;
                break;
            }
            for (i = this.groups.length - 1; i >= 0; --i) {
                group = this.groups[i];
                this.crtGroupFootersLevel = i;
                if (this.preventOrphanFootersMinLevel != null && this.crtGroupFootersLevel < this.preventOrphanFootersMinLevel) {
                    this.orphanGroupFooterDetailElementRange = null;
                    this.orphanGroupFooterElementRange = null;
                    this.detailElementRange = null;
                }
                if (!isFillAll && !group.hasChanged()) continue;
                this.fillGroupFooter(group, evaluation);
                group.setKeepTogetherElementRange(null);
            }
            this.orphanGroupFooterDetailElementRange = null;
            this.orphanGroupFooterElementRange = null;
            this.detailElementRange = null;
            if (!isFillAll && this.groupFooterPositionElementRange != null) {
                ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
                this.groupFooterPositionElementRange = null;
                this.offsetY = this.columnFooterOffsetY;
            }
        }
    }

    @continuable
    private void fillGroupFooter(JRFillGroup group, byte evaluation) throws JRException {
        JRFillSection groupFooterSection = (JRFillSection)group.getGroupFooterSection();
        if (log.isDebugEnabled() && !groupFooterSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + group.getName() + " footer at " + this.offsetY));
        }
        JRFillBand[] groupFooterBands = groupFooterSection.getFillBands();
        for (int i = 0; i < groupFooterBands.length; ++i) {
            SimpleElementRange newElementRange;
            JRFillBand groupFooterBand = groupFooterBands[i];
            groupFooterBand.evaluatePrintWhenExpression(evaluation);
            if (!groupFooterBand.isToPrint()) continue;
            if (this.preventOrphanFootersMinLevel != null && this.crtGroupFootersLevel >= this.preventOrphanFootersMinLevel && this.orphanGroupFooterDetailElementRange == null) {
                this.orphanGroupFooterDetailElementRange = this.detailElementRange;
            }
            if (groupFooterBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(evaluation, evaluation);
            }
            if (this.groupFooterPositionElementRange == null && group.getFooterPositionValue() != FooterPositionEnum.NORMAL) {
                this.groupFooterPositionElementRange = new SimpleGroupFooterElementRange(new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY), group.getFooterPositionValue());
            }
            if (this.groupFooterPositionElementRange != null) {
                this.groupFooterPositionElementRange.setCurrentFooterPosition(group.getFooterPositionValue());
            }
            if (this.orphanGroupFooterDetailElementRange != null) {
                newElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
                if (this.orphanGroupFooterElementRange == null) {
                    this.orphanGroupFooterElementRange = newElementRange;
                } else {
                    ElementRangeUtil.expandOrIgnore(this.orphanGroupFooterElementRange, newElementRange);
                }
            }
            this.fillColumnBand(groupFooterBand, evaluation, false);
            newElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
            if (this.groupFooterPositionElementRange != null) {
                ElementRangeUtil.expandOrIgnore(this.groupFooterPositionElementRange.getElementRange(), newElementRange);
                switch (group.getFooterPositionValue()) {
                    case STACK_AT_BOTTOM: {
                        this.groupFooterPositionElementRange.setMasterFooterPosition(FooterPositionEnum.STACK_AT_BOTTOM);
                        break;
                    }
                    case FORCE_AT_BOTTOM: {
                        this.groupFooterPositionElementRange.setMasterFooterPosition(FooterPositionEnum.FORCE_AT_BOTTOM);
                        break;
                    }
                    case COLLATE_AT_BOTTOM: {
                        break;
                    }
                    default: {
                        if (this.groupFooterPositionElementRange.getMasterFooterPosition() != FooterPositionEnum.COLLATE_AT_BOTTOM) break;
                        this.groupFooterPositionElementRange = null;
                    }
                }
            }
            this.isFirstPageBand = false;
            this.isFirstColumnBand = false;
        }
        if (this.groupFooterPositionElementRange != null && this.groupFooterPositionElementRange.getMasterFooterPosition() == FooterPositionEnum.FORCE_AT_BOTTOM) {
            ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
            this.groupFooterPositionElementRange = null;
            this.offsetY = this.columnFooterOffsetY;
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        group.setHeaderPrinted(false);
        group.setFooterPrinted(true);
    }

    private void fillColumnFooter(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnFooter.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": column footer at " + this.offsetY));
        }
        this.setOffsetX();
        if (this.isSubreport() && !this.isSubreportRunToBottom() && this.columnIndex == 0) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int oldOffsetY = this.offsetY;
        if (!this.isFloatColumnFooter && !this.ignorePagination) {
            this.offsetY = this.columnFooterOffsetY;
        }
        if (this.groupFooterPositionElementRange != null) {
            ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
            this.groupFooterPositionElementRange = null;
        }
        this.columnFooter.evaluatePrintWhenExpression(evaluation);
        if (this.columnFooter.isToPrint()) {
            if (this.isFloatColumnFooter && !this.ignorePagination) {
                this.floatColumnFooterElementRange = new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY);
            }
            this.fillFixedBand(this.columnFooter, evaluation);
            if (this.floatColumnFooterElementRange != null) {
                this.floatColumnFooterElementRange.expand(this.offsetY);
            }
        }
        if (this.isFloatColumnFooter && !this.ignorePagination) {
            this.offsetY += this.columnFooterOffsetY - oldOffsetY;
        }
    }

    private void fillPageFooter(byte evaluation) throws JRException {
        JRFillBand crtPageFooter = this.getCurrentPageFooter();
        if (log.isDebugEnabled() && !crtPageFooter.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + (this.isLastPageFooter ? "last " : "") + "page footer at " + this.offsetY));
        }
        this.offsetX = this.leftMargin;
        if (!(this.isSubreport() && !this.isSubreportRunToBottom() || this.ignorePagination)) {
            this.offsetY = this.pageHeight - crtPageFooter.getHeight() - this.bottomMargin;
        }
        crtPageFooter.evaluatePrintWhenExpression(evaluation);
        if (crtPageFooter.isToPrint()) {
            this.fillFixedBand(crtPageFooter, evaluation);
        }
    }

    @continuable
    private void fillSummary() throws JRException {
        if (log.isDebugEnabled() && !this.summary.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": summary at " + this.offsetY));
        }
        this.offsetX = this.leftMargin;
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummaryNoLastFooterSamePage();
            } else {
                this.fillSummaryNoLastFooterNewPage();
            }
        } else if (this.isSummaryWithPageHeaderAndFooter) {
            this.fillSummaryWithLastFooterAndPageBands();
        } else {
            this.fillSummaryWithLastFooterNoPageBands();
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
        if (this.isMasterReport()) {
            this.resolveMasterBoundElements();
        }
    }

    @continuable
    private void fillSummaryNoLastFooterSamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary.isToPrint()) {
            if (this.groupFooterPositionElementRange != null) {
                ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
                this.offsetY = this.columnFooterOffsetY;
                this.groupFooterPositionElementRange = null;
            }
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
            if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageHeader((byte)3);
                }
                printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
                this.fillSummaryOverflow();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                if (this.summary.willOverflow()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    if (this.isSummaryWithPageHeaderAndFooter) {
                        this.fillPageHeader((byte)3);
                    }
                    printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                    this.fillSummaryOverflow();
                } else {
                    this.resolveBandBoundElements(this.summary, (byte)3);
                }
            }
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    @continuable
    private void fillSummaryNoLastFooterNewPage() throws JRException {
        this.fillColumnFooter((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageHeader((byte)3);
            }
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageFooter((byte)3);
                }
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageHeader((byte)3);
                }
                printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.isCrtRecordOnPage = true;
            this.isCrtRecordOnColumn = true;
            this.fillSummaryOverflow();
        }
    }

    @continuable
    private void fillSummaryWithLastFooterAndPageBands() throws JRException {
        if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                if (this.groupFooterPositionElementRange != null) {
                    ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
                    this.offsetY = this.columnFooterOffsetY;
                    this.groupFooterPositionElementRange = null;
                }
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader((byte)3);
                    printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                    if (!this.summary.willOverflow() && this.offsetY <= this.lastPageColumnFooterOffsetY) {
                        this.setLastPageFooter(true);
                    }
                    this.fillColumnFooter((byte)3);
                }
                this.fillSummaryOverflow();
            } else {
                this.setLastPageFooter(true);
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader((byte)3);
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader((byte)3);
                    printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                }
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
                this.fillSummaryOverflow();
            } else {
                this.setLastPageFooter(true);
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
            this.resolveGroupBoundElements((byte)3, false);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.fillPageHeader((byte)3);
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader((byte)3);
                    printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                }
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
            }
            this.fillSummaryOverflow();
        }
    }

    @continuable
    private void fillSummaryWithLastFooterNoPageBands() throws JRException {
        if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                if (this.groupFooterPositionElementRange != null) {
                    ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
                    this.offsetY = this.columnFooterOffsetY;
                    this.groupFooterPositionElementRange = null;
                }
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                }
                this.fillSummaryOverflow();
            } else {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                if (this.groupFooterPositionElementRange != null) {
                    ElementRangeUtil.moveContent(this.groupFooterPositionElementRange, this.columnFooterOffsetY);
                    this.offsetY = this.columnFooterOffsetY;
                    this.groupFooterPositionElementRange = null;
                }
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                        this.setLastPageFooter(true);
                        this.fillColumnFooter((byte)3);
                        this.fillPageFooter((byte)3);
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.isCrtRecordOnPage = true;
                        this.isCrtRecordOnColumn = true;
                    } else {
                        this.fillPageBreak(false, (byte)3, (byte)3, false);
                        this.setLastPageFooter(true);
                        printBand = this.summary.refill((byte)3, this.lastPageColumnFooterOffsetY - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.isCrtRecordOnPage = true;
                        this.isCrtRecordOnColumn = true;
                        this.fillColumnFooter((byte)3);
                        this.fillPageFooter((byte)3);
                    }
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    if (this.summary.willOverflow()) {
                        printBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.isCrtRecordOnPage = true;
                        this.isCrtRecordOnColumn = true;
                    }
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                }
                this.fillSummaryOverflow();
            } else {
                if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                }
                this.setLastPageFooter(true);
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary.isToPrint()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
                }
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
                this.fillSummaryOverflow();
            }
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
            this.resolveGroupBoundElements((byte)3, false);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.fillPageHeader((byte)3);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillPageFooter((byte)3);
                this.summary.evaluatePrintWhenExpression((byte)3);
                if (this.summary.isToPrint()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.summary.evaluate((byte)3);
                    JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                    if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
                    }
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.isCrtRecordOnPage = true;
                    this.isCrtRecordOnColumn = true;
                    this.fillSummaryOverflow();
                }
            } else {
                this.summary.evaluatePrintWhenExpression((byte)3);
                if (this.summary.isToPrint()) {
                    this.summary.evaluate((byte)3);
                    JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                    if (this.summary.willOverflow() && this.summary.isSplitPrevented() && !this.summary.isSplitTypePreventInhibited()) {
                        this.fillPageFooter((byte)3);
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.isCrtRecordOnPage = true;
                        this.isCrtRecordOnColumn = true;
                    } else {
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.isCrtRecordOnPage = true;
                        this.isCrtRecordOnColumn = true;
                        this.fillPageFooter((byte)3);
                    }
                    this.fillSummaryOverflow();
                } else {
                    this.fillPageFooter((byte)3);
                }
            }
        }
    }

    @continuable
    private void fillSummaryOverflow() throws JRException {
        while (this.summary.willOverflow()) {
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageFooter((byte)3);
            }
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageHeader((byte)3);
            }
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.isCrtRecordOnPage = true;
            this.isCrtRecordOnColumn = true;
        }
        this.resolveBandBoundElements(this.summary, (byte)3);
        if (this.isSummaryWithPageHeaderAndFooter) {
            if (this.offsetY > this.pageHeight - this.bottomMargin - this.lastPageFooter.getHeight()) {
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader((byte)3);
            }
            if (this.lastPageFooter != this.missingFillBand) {
                this.setLastPageFooter(true);
            }
            this.fillPageFooter((byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (log.isDebugEnabled() && !this.background.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": background at " + this.offsetY));
        }
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand printBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
            }
        }
    }

    @continuable
    private void addPage(boolean isResetPageNumber) throws JRException {
        if (this.isSubreport()) {
            this.addPageToParent(false);
        }
        if (this.printPage != null) {
            this.recordUsedPageHeight(this.offsetY + this.bottomMargin);
        }
        this.printPage = this.newPage();
        this.printPageContentsWidth = 0;
        JRFillVariable pageNumberVar = this.calculator.getPageNumber();
        if (isResetPageNumber) {
            pageNumberVar.setValue(1);
        } else {
            pageNumberVar.setValue(((Number)pageNumberVar.getValue()).intValue() + 1);
        }
        pageNumberVar.setOldValue(pageNumberVar.getValue());
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.isFirstPageBand = true;
        this.isFirstColumnBand = true;
        this.isCrtRecordOnPage = false;
        this.isCrtRecordOnColumn = false;
        this.fillBackground();
    }

    private void setFirstColumn() {
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.setColumnNumberVar();
    }

    private void setColumnNumberVar() {
        JRFillVariable columnNumber = this.calculator.getColumnNumber();
        columnNumber.setValue(this.columnIndex + 1);
        columnNumber.setOldValue(columnNumber.getValue());
    }

    @continuable
    private void fillPageBreak(boolean isResetPageNumber, byte evalPrevPage, byte evalNextPage, boolean isReprintGroupHeaders) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("fill.common.filler.infinite.loop.creating.new.page", (Object[])null);
        }
        if (this.groups != null) {
            for (JRFillGroup group : this.groups) {
                if (group.getKeepTogetherElementRange() == null) continue;
                group.getKeepTogetherElementRange().expand(this.offsetY);
            }
        }
        FooterPositionEnum groupFooterPositionForOverflow = null;
        if (this.groupFooterPositionElementRange != null) {
            groupFooterPositionForOverflow = this.groupFooterPositionElementRange.getCurrentFooterPosition();
            this.groupFooterPositionElementRange.getElementRange().expand(this.offsetY);
        }
        if (this.orphanGroupFooterElementRange != null) {
            this.orphanGroupFooterElementRange.expand(this.offsetY);
        } else if (this.orphanGroupFooterDetailElementRange != null) {
            this.orphanGroupFooterDetailElementRange.expand(this.offsetY);
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooter(evalPrevPage);
        this.fillPageFooter(evalPrevPage);
        this.resolveGroupBoundElements(evalPrevPage, false);
        this.resolveColumnBoundElements(evalPrevPage);
        this.resolvePageBoundElements(evalPrevPage);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
        this.scriptlet.callAfterPageInit();
        JRFillGroup keepTogetherGroup = this.getKeepTogetherGroup();
        ElementRange elementRangeToMove = null;
        ElementRange elementRangeToMove2 = null;
        if (keepTogetherGroup != null) {
            elementRangeToMove = keepTogetherGroup.getKeepTogetherElementRange();
        } else if (this.orphanGroupFooterDetailElementRange != null) {
            elementRangeToMove = this.orphanGroupFooterDetailElementRange;
            elementRangeToMove2 = this.orphanGroupFooterElementRange;
        }
        if (this.floatColumnFooterElementRange != null && elementRangeToMove != null) {
            ElementRangeUtil.moveContent(this.floatColumnFooterElementRange, elementRangeToMove.getTopY());
        }
        ElementRangeContents elementsToMove2 = null;
        if (elementRangeToMove2 != null) {
            elementsToMove2 = ElementRangeUtil.removeContent(elementRangeToMove2, this.delayedActions);
        }
        ElementRangeContents elementsToMove = null;
        if (elementRangeToMove != null) {
            elementsToMove = ElementRangeUtil.removeContent(elementRangeToMove, this.delayedActions);
        }
        this.addPage(isResetPageNumber);
        this.fillPageHeader(evalNextPage);
        this.fillColumnHeader(evalNextPage);
        if (isReprintGroupHeaders) {
            ElementRange keepTogetherElementRange;
            this.fillGroupHeadersReprint(evalNextPage, true);
            ElementRange elementRange = keepTogetherElementRange = keepTogetherGroup == null ? null : keepTogetherGroup.getKeepTogetherElementRange();
            if (keepTogetherElementRange != null && this.offsetY > keepTogetherElementRange.getTopY()) {
                throw new JRException("fill.common.filler.keep.together.content.does.not.fit", (Object[])null);
            }
        }
        this.orphanGroupFooterDetailElementRange = null;
        this.orphanGroupFooterElementRange = null;
        this.detailElementRange = null;
        if (keepTogetherGroup != null) {
            keepTogetherGroup.setKeepTogetherElementRange(null);
        }
        if (elementRangeToMove != null) {
            ElementRangeUtil.addContent(this.printPage, this.currentPageIndex(), elementsToMove, (this.columnIndex - elementRangeToMove.getColumnIndex()) * (this.columnSpacing + this.columnWidth), this.offsetY - elementRangeToMove.getTopY(), this.delayedActions);
            this.offsetY = this.offsetY + elementRangeToMove.getBottomY() - elementRangeToMove.getTopY();
            if (elementRangeToMove2 != null) {
                ElementRangeUtil.addContent(this.printPage, this.currentPageIndex(), elementsToMove2, (this.columnIndex - elementRangeToMove2.getColumnIndex()) * (this.columnSpacing + this.columnWidth), this.offsetY - elementRangeToMove2.getTopY(), this.delayedActions);
                this.offsetY = this.offsetY + elementRangeToMove2.getBottomY() - elementRangeToMove2.getTopY();
            }
            this.isFirstPageBand = false;
            this.isFirstColumnBand = false;
        } else if (groupFooterPositionForOverflow != null && groupFooterPositionForOverflow != FooterPositionEnum.NORMAL) {
            this.groupFooterPositionElementRange = new SimpleGroupFooterElementRange(new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY), groupFooterPositionForOverflow);
        }
        this.isCreatingNewPage = false;
    }

    @continuable
    private void fillColumnBreak(byte evalPrevPage, byte evalNextPage) throws JRException {
        if (this.columnIndex == this.columnCount - 1) {
            this.fillPageBreak(false, evalPrevPage, evalNextPage, true);
        } else {
            ElementRange keepTogetherElementRange;
            if (this.groups != null) {
                for (JRFillGroup group : this.groups) {
                    if (group.getKeepTogetherElementRange() == null) continue;
                    group.getKeepTogetherElementRange().expand(this.offsetY);
                }
            }
            FooterPositionEnum groupFooterPositionForOverflow = null;
            if (this.groupFooterPositionElementRange != null) {
                groupFooterPositionForOverflow = this.groupFooterPositionElementRange.getCurrentFooterPosition();
                this.groupFooterPositionElementRange.getElementRange().expand(this.offsetY);
            }
            if (this.orphanGroupFooterElementRange != null) {
                this.orphanGroupFooterElementRange.expand(this.offsetY);
            } else if (this.orphanGroupFooterDetailElementRange != null) {
                this.orphanGroupFooterDetailElementRange.expand(this.offsetY);
            }
            this.fillColumnFooter(evalPrevPage);
            this.resolveGroupBoundElements(evalPrevPage, false);
            this.resolveColumnBoundElements(evalPrevPage);
            this.scriptlet.callBeforeColumnInit();
            this.calculator.initializeVariables(ResetTypeEnum.COLUMN, IncrementTypeEnum.COLUMN);
            this.scriptlet.callAfterColumnInit();
            JRFillGroup keepTogetherGroup = this.getKeepTogetherGroup();
            ElementRange elementRangeToMove = null;
            ElementRange elementRangeToMove2 = null;
            if (keepTogetherGroup != null) {
                elementRangeToMove = keepTogetherGroup.getKeepTogetherElementRange();
            } else if (this.orphanGroupFooterDetailElementRange != null) {
                elementRangeToMove = this.orphanGroupFooterDetailElementRange;
                elementRangeToMove2 = this.orphanGroupFooterElementRange;
            }
            if (this.floatColumnFooterElementRange != null && elementRangeToMove != null) {
                ElementRangeUtil.moveContent(this.floatColumnFooterElementRange, elementRangeToMove.getTopY());
            }
            ElementRangeContents elementsToMove2 = null;
            if (elementRangeToMove2 != null) {
                elementsToMove2 = ElementRangeUtil.removeContent(elementRangeToMove2, this.delayedActions);
            }
            ElementRangeContents elementsToMove = null;
            if (elementRangeToMove != null) {
                elementsToMove = ElementRangeUtil.removeContent(elementRangeToMove, null);
            }
            ++this.columnIndex;
            this.setOffsetX();
            this.offsetY = this.columnHeaderOffsetY;
            this.isCrtRecordOnColumn = false;
            this.setColumnNumberVar();
            this.fillColumnHeader(evalNextPage);
            this.fillGroupHeadersReprint(evalNextPage, false);
            ElementRange elementRange = keepTogetherElementRange = keepTogetherGroup == null ? null : keepTogetherGroup.getKeepTogetherElementRange();
            if (keepTogetherElementRange != null && this.offsetY > keepTogetherElementRange.getTopY()) {
                throw new JRException("fill.common.filler.keep.together.content.does.not.fit", (Object[])null);
            }
            this.orphanGroupFooterDetailElementRange = null;
            this.orphanGroupFooterElementRange = null;
            this.detailElementRange = null;
            if (keepTogetherGroup != null) {
                keepTogetherGroup.setKeepTogetherElementRange(null);
            }
            if (elementRangeToMove != null) {
                ElementRangeUtil.addContent(this.printPage, this.currentPageIndex(), elementsToMove, (this.columnIndex - elementRangeToMove.getColumnIndex()) * (this.columnSpacing + this.columnWidth), this.offsetY - elementRangeToMove.getTopY(), this.delayedActions);
                this.offsetY = this.offsetY + elementRangeToMove.getBottomY() - elementRangeToMove.getTopY();
                if (elementRangeToMove2 != null) {
                    ElementRangeUtil.addContent(this.printPage, this.currentPageIndex(), elementsToMove2, (this.columnIndex - elementRangeToMove2.getColumnIndex()) * (this.columnSpacing + this.columnWidth), this.offsetY - elementRangeToMove2.getTopY(), this.delayedActions);
                    this.offsetY = this.offsetY + elementRangeToMove2.getBottomY() - elementRangeToMove2.getTopY();
                }
                this.isFirstPageBand = false;
                this.isFirstColumnBand = false;
            } else if (groupFooterPositionForOverflow != null && groupFooterPositionForOverflow != FooterPositionEnum.NORMAL) {
                this.groupFooterPositionElementRange = new SimpleGroupFooterElementRange(new SimpleElementRange(this.getCurrentPage(), this.columnIndex, this.offsetY), groupFooterPositionForOverflow);
            }
        }
    }

    @continuable
    protected void fillColumnBand(JRFillBand band, byte evaluation, boolean recalculateVariables) throws JRException {
        band.evaluate((byte)evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
        if (band.willOverflow()) {
            boolean toRefill;
            boolean bl = toRefill = band.isSplitPrevented() && !band.isSplitTypePreventInhibited();
            if (!toRefill && this.groups != null) {
                for (JRFillGroup group : this.groups) {
                    if (group.getKeepTogetherElementRange() == null || !group.isKeepTogether() && group.hasMinDetails()) continue;
                    toRefill = true;
                    break;
                }
            }
            if (!toRefill && this.orphanGroupFooterDetailElementRange != null) {
                toRefill = true;
            }
            if (toRefill) {
                boolean isLegacyBandEvaluationEnabled;
                this.fillColumnBreak((byte)(evaluation == 3 ? (this.isCrtRecordOnColumn ? 3 : 1) : evaluation), (byte)evaluation);
                if (recalculateVariables && !(isLegacyBandEvaluationEnabled = this.getFillContext().isLegacyBandEvaluationEnabled())) {
                    this.mainDataset.revertVariablesToOldValues();
                    this.calculator.recalculateVariables();
                }
                printBand = band.refill((byte)evaluation, this.columnFooterOffsetY - this.offsetY);
            }
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        this.isCrtRecordOnColumn = this.isCrtRecordOnPage = evaluation == 3;
        while (band.willOverflow()) {
            if (band.willOverflowWithElements()) {
                this.fillColumnBreak((byte)(evaluation == 3 ? (this.isCrtRecordOnColumn ? 3 : 1) : evaluation), (byte)evaluation);
            }
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.isCrtRecordOnColumn = this.isCrtRecordOnPage = evaluation == 3;
        }
        this.resolveBandBoundElements(band, (byte)evaluation);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill();
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        this.isCrtRecordOnColumn = this.isCrtRecordOnPage = evaluation == 3;
        this.resolveBandBoundElements(band, evaluation);
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detailSection.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        this.noData.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillSection)this.groups[i].getGroupHeaderSection()).setNewPageColumn(true);
                ((JRFillSection)this.groups[i].getGroupFooterSection()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup group) {
        this.title.setNewGroup(group, true);
        this.pageHeader.setNewGroup(group, true);
        this.columnHeader.setNewGroup(group, true);
        this.detailSection.setNewGroup(group, true);
        this.columnFooter.setNewGroup(group, true);
        this.pageFooter.setNewGroup(group, true);
        this.lastPageFooter.setNewGroup(group, true);
        this.summary.setNewGroup(group, true);
        this.noData.setNewGroup(group, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillSection)this.groups[i].getGroupHeaderSection()).setNewGroup(group, true);
                ((JRFillSection)this.groups[i].getGroupFooterSection()).setNewGroup(group, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean isLastPageFooter) {
        this.isLastPageFooter = isLastPageFooter;
        if (isLastPageFooter) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }

    @continuable
    private void fillNoData() throws JRException {
        if (log.isDebugEnabled() && !this.noData.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": noData at " + this.offsetY));
        }
        this.noData.evaluatePrintWhenExpression((byte)3);
        if (this.noData.isToPrint()) {
            while (this.noData.getBreakHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.noData.evaluate((byte)3);
            JRPrintBand printBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY);
            if (this.noData.willOverflow() && this.noData.isSplitPrevented() && !this.noData.isSplitTypePreventInhibited()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.noData.refill((byte)3, this.pageHeight - this.bottomMargin - this.offsetY);
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.isCrtRecordOnPage = true;
            this.isCrtRecordOnColumn = true;
            while (this.noData.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables(ResetTypeEnum.PAGE, IncrementTypeEnum.PAGE);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.isCrtRecordOnPage = true;
                this.isCrtRecordOnColumn = true;
            }
            this.resolveBandBoundElements(this.noData, (byte)3);
        }
    }

    private void setOffsetX() {
        this.offsetX = this.columnDirection == RunDirectionEnum.RTL ? this.pageWidth - this.rightMargin - this.columnWidth - this.columnIndex * (this.columnSpacing + this.columnWidth) : this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
    }
}

