/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.compilers.DirectExpressionEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluators;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.FillFunctionContext;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.MessageFormatWrapper;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.functions.FunctionSupport;

public abstract class JREvaluator
implements DatasetExpressionEvaluator {
    public static final String EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND = "fill.evaluator.resource.not.found";
    public static final String PROPERTY_IGNORE_NPE = "net.sf.jasperreports.evaluator.ignore.npe";
    private JRFillParameter resourceBundle;
    private WhenResourceMissingTypeEnum whenResourceMissingType;
    private JRFillParameter locale;
    private Map<String, FunctionSupport> functions;
    private FillFunctionContext functionContext;
    protected boolean ignoreNPE = true;
    private DirectExpressionEvaluators directExpressionEvaluators;

    protected JREvaluator() {
    }

    public void setDirectExpressionEvaluators(DirectExpressionEvaluators directExpressionEvaluators) {
        this.directExpressionEvaluators = directExpressionEvaluators;
    }

    private DirectExpressionEvaluator directEvaluator(JRExpression expression) {
        return this.directExpressionEvaluators == null ? null : this.directExpressionEvaluators.getEvaluator(expression);
    }

    @Override
    public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap, WhenResourceMissingTypeEnum resourceMissingType, boolean ignoreNPE) throws JRException {
        this.whenResourceMissingType = resourceMissingType;
        this.ignoreNPE = ignoreNPE;
        this.resourceBundle = parametersMap.get("REPORT_RESOURCE_BUNDLE");
        this.locale = parametersMap.get("REPORT_LOCALE");
        this.functions = new HashMap<String, FunctionSupport>();
        this.functionContext = new FillFunctionContext(parametersMap);
        this.customizedInit(parametersMap, fieldsMap, variablesMap);
        if (this.directExpressionEvaluators != null) {
            this.directExpressionEvaluators.init(this, parametersMap, fieldsMap, variablesMap);
        }
    }

    public <T extends FunctionSupport> T getFunctionSupport(Class<T> clazz) {
        String classId = clazz.getName();
        if (!this.functions.containsKey(classId)) {
            try {
                FunctionSupport functionSupport = (FunctionSupport)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                functionSupport.init(this.functionContext);
                this.functions.put(classId, functionSupport);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
        }
        return (T)this.functions.get(classId);
    }

    public String msg(String pattern, Object arg0) {
        return MessageFormatWrapper.format(pattern, (Locale)this.locale.getValue(), arg0);
    }

    public String msg(String pattern, Object arg0, Object arg1) {
        return MessageFormatWrapper.format(pattern, (Locale)this.locale.getValue(), arg0, arg1);
    }

    public String msg(String pattern, Object arg0, Object arg1, Object arg2) {
        return MessageFormatWrapper.format(pattern, (Locale)this.locale.getValue(), arg0, arg1, arg2);
    }

    public String msg(String pattern, Object ... args) {
        return MessageFormatWrapper.format(pattern, (Locale)this.locale.getValue(), args);
    }

    public String str(String key) {
        String str = null;
        try {
            str = ((ResourceBundle)this.resourceBundle.getValue()).getString(key);
        }
        catch (NullPointerException e) {
            if (this.ignoreNPE) {
                str = this.handleMissingResource(key, e);
            }
            throw e;
        }
        catch (MissingResourceException e) {
            str = this.handleMissingResource(key, e);
        }
        return str;
    }

    protected Object handleEvaluationException(JRExpression expression, Throwable e) throws JRExpressionEvalException {
        throw new JRExpressionEvalException(expression, e);
    }

    @Override
    public Object evaluate(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            DirectExpressionEvaluator directEvaluator = this.directEvaluator(expression);
            try {
                value = directEvaluator != null ? directEvaluator.evaluate() : this.evaluate(expression.getId());
            }
            catch (NullPointerException e) {
                if (!this.ignoreNPE) {
                    throw new JRExpressionEvalException(expression, (Throwable)e);
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                value = this.handleEvaluationException(expression, e);
            }
        }
        return value;
    }

    @Override
    public Object evaluateOld(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            DirectExpressionEvaluator directEvaluator = this.directEvaluator(expression);
            try {
                value = directEvaluator != null ? directEvaluator.evaluateOld() : this.evaluateOld(expression.getId());
            }
            catch (NullPointerException e) {
                if (!this.ignoreNPE) {
                    throw new JRExpressionEvalException(expression, (Throwable)e);
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                value = this.handleEvaluationException(expression, e);
            }
        }
        return value;
    }

    @Override
    public Object evaluateEstimated(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            DirectExpressionEvaluator directEvaluator = this.directEvaluator(expression);
            try {
                value = directEvaluator != null ? directEvaluator.evaluateEstimated() : this.evaluateEstimated(expression.getId());
            }
            catch (NullPointerException e) {
                if (!this.ignoreNPE) {
                    throw new JRExpressionEvalException(expression, (Throwable)e);
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                value = this.handleEvaluationException(expression, e);
            }
        }
        return value;
    }

    protected String handleMissingResource(String key, Exception e) throws JRRuntimeException {
        String str;
        switch (this.whenResourceMissingType) {
            case EMPTY: {
                str = "";
                break;
            }
            case KEY: {
                str = key;
                break;
            }
            case ERROR: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND, new Object[]{key}, e);
            }
            default: {
                str = null;
            }
        }
        return str;
    }

    protected abstract void customizedInit(Map<String, JRFillParameter> var1, Map<String, JRFillField> var2, Map<String, JRFillVariable> var3) throws JRException;

    protected abstract Object evaluate(int var1) throws Throwable;

    protected abstract Object evaluateOld(int var1) throws Throwable;

    protected abstract Object evaluateEstimated(int var1) throws Throwable;
}

