/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.zip.AbstractZip;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class OoxmlEncryptUtil {
    public static void zipEntries(AbstractZip zip, OutputStream os, String password) throws IOException {
        FileBufferedOutputStream fbos = new FileBufferedOutputStream();
        zip.zipEntries(fbos);
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((InputStream)fbos.getDataInputStream());
                 OutputStream eos = enc.getDataStream(fs);){
                opc.save(eos);
            }
            catch (GeneralSecurityException | InvalidFormatException e) {
                throw new JRRuntimeException(e);
            }
            fs.writeFilesystem(os);
        }
    }
}

