/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.analytics.data.MultiAxisDataSource;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisDataService;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class FillMultiAxisDataset
extends JRFillElementDataset {
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_CREATE_BUCKETING_SERVICE = "engine.analytics.dataset.cannot.create.bucketing.service";
    private final JasperReportsContext jasperReportsContext;
    private final MultiAxisData data;
    private final JRFillExpressionEvaluator expressionEvaluator;
    private MultiAxisDataService dataService;

    public FillMultiAxisDataset(MultiAxisData data, JRFillObjectFactory factory) {
        super(data.getDataset(), factory);
        this.jasperReportsContext = factory.getFiller().getJasperReportsContext();
        this.data = data;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        factory.registerElementDataset(this);
    }

    public FillMultiAxisDataset(FillMultiAxisDataset dataset, JRFillCloneFactory factory) {
        super(dataset, factory);
        this.jasperReportsContext = dataset.jasperReportsContext;
        this.data = dataset.data;
        this.expressionEvaluator = dataset.expressionEvaluator;
    }

    @Override
    protected void customInitialize() {
        if (this.dataService == null) {
            try {
                this.dataService = this.createService((byte)3);
            }
            catch (JRException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CANNOT_CREATE_BUCKETING_SERVICE, null, e);
            }
        } else {
            this.dataService.clearData();
        }
    }

    protected MultiAxisDataService createService(byte evaluation) throws JRException {
        return new MultiAxisDataService(this.jasperReportsContext, this.expressionEvaluator, this.data, evaluation);
    }

    @Override
    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        this.dataService.evaluateRecord(calculator);
    }

    @Override
    protected void customIncrement() {
        this.dataService.addRecord();
    }

    public void evaluateData(byte evaluationType) throws JRException {
        this.evaluateDatasetRun(evaluationType);
    }

    public MultiAxisDataSource getDataSource() throws JRException {
        this.increment();
        return this.dataService.createDataSource();
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
    }
}

