/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.SimplePrintPageFormat;

public class SimplePrintPart
implements PrintPart,
Serializable {
    private static final long serialVersionUID = 10200L;
    private String name;
    private PrintPageFormat pageFormat;
    private JRPropertiesMap propertiesMap;

    public static SimplePrintPart fromJasperPrint(JasperPrint partJasperPrint, String partName) {
        return SimplePrintPart.fromJasperPrint(partJasperPrint, partName, null);
    }

    public static SimplePrintPart fromJasperPrint(JasperPrint partJasperPrint, String partName, JRPropertiesHolder properties) {
        SimplePrintPart printPart = new SimplePrintPart();
        if (partName == null) {
            partName = partJasperPrint.getName();
        }
        printPart.setName(partName);
        if (properties != null && properties.hasProperties()) {
            printPart.getPropertiesMap().copyProperties(properties.getPropertiesMap());
        }
        SimplePrintPageFormat pageFormat = new SimplePrintPageFormat();
        pageFormat.setPageWidth(partJasperPrint.getPageWidth());
        pageFormat.setPageHeight(partJasperPrint.getPageHeight());
        pageFormat.setOrientation(partJasperPrint.getOrientationValue());
        pageFormat.setLeftMargin(partJasperPrint.getLeftMargin());
        pageFormat.setTopMargin(partJasperPrint.getTopMargin());
        pageFormat.setRightMargin(partJasperPrint.getRightMargin());
        pageFormat.setBottomMargin(partJasperPrint.getBottomMargin());
        printPart.setPageFormat(pageFormat);
        return printPart;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public PrintPageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PrintPageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public synchronized JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public void update(String partName, JRPropertiesHolder partProperties) {
        if (partName != null) {
            this.name = partName;
        }
        if (partProperties != null && partProperties.hasProperties()) {
            this.getPropertiesMap().copyProperties(partProperties.getPropertiesMap());
        }
    }
}

