/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_DIMENSION_MUST_OVERRIDE = "engine.renderable.svg.dimension.must.override";
    public static final String EXCEPTION_MESSAGE_KEY_DIMENSION_NULL_NOT_ALLOWED = "engine.renderable.svg.dimension.null.not.allowed";

    @Override
    public byte getType() {
        return this.getTypeValue().getValue();
    }

    @Override
    public byte getImageType() {
        return this.getImageTypeValue().getValue();
    }

    @Override
    public RenderableTypeEnum getTypeValue() {
        return RenderableTypeEnum.SVG;
    }

    @Override
    public ImageTypeEnum getImageTypeValue() {
        return ImageTypeEnum.PNG;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        throw new JRException(EXCEPTION_MESSAGE_KEY_DIMENSION_MUST_OVERRIDE, this.getClass().getName());
    }

    @Override
    public Dimension2D getDimension() throws JRException {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    public Color getBackcolor() {
        return null;
    }

    @Override
    public byte[] getImageData() throws JRException {
        return this.getImageData(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext) throws JRException {
        Dimension2D dimension = this.getDimension(jasperReportsContext);
        if (dimension == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DIMENSION_NULL_NOT_ALLOWED, (Object[])null);
        }
        int dpi = this.getImageDataDPI(jasperReportsContext);
        double scale = (double)dpi / 72.0;
        ImageTypeEnum imageType = this.getImageTypeValue();
        BufferedImage bi = new BufferedImage((int)(scale * dimension.getWidth()), (int)(scale * dimension.getHeight()), imageType == ImageTypeEnum.GIF || imageType == ImageTypeEnum.PNG ? 2 : 1);
        Graphics2D g = this.createGraphics(bi);
        try {
            g.scale(scale, scale);
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g.setColor(backcolor);
                g.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(jasperReportsContext, g, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
        }
        finally {
            g.dispose();
        }
        return JRImageLoader.getInstance(jasperReportsContext).loadBytesFromAwtImage(bi, this.getImageTypeValue());
    }

    protected int getImageDataDPI(JasperReportsContext jasperReportsContext) {
        return JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
    }

    protected Graphics2D createGraphics(BufferedImage bi) {
        return bi.createGraphics();
    }
}

