/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.AbstractRenderer;
import net.sf.jasperreports.renderers.Graphics2DRenderable;

public class UnusedSpaceImageRenderer
extends AbstractRenderer
implements Graphics2DRenderable {
    private static final long serialVersionUID = 1L;
    private static final Color FILL = new Color(224, 224, 224, 128);
    public static final UnusedSpaceImageRenderer INSTANCE = new UnusedSpaceImageRenderer();
    private final Shape clip;
    private final int lineGap = 15;
    private final int lineWidth = 10;

    public UnusedSpaceImageRenderer() {
        this(null);
    }

    public UnusedSpaceImageRenderer(Shape clip) {
        this.clip = clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Graphics2D graphics = (Graphics2D)grx.create();
        try {
            graphics.translate(rectangle.getX(), rectangle.getY());
            graphics.setColor(FILL);
            if (this.clip != null) {
                graphics.clip(this.clip);
            }
            int width = (int)rectangle.getWidth();
            int limit = width + (int)rectangle.getHeight();
            int increment = 25;
            int reverseOffset = (width - 13) % increment;
            for (int x = 0; x <= limit; x += increment) {
                graphics.fillPolygon(new int[]{x, x + 10, 0, 0}, new int[]{0, 0, x + 10, x}, 4);
                graphics.fillPolygon(new int[]{width - x - reverseOffset, width - x - 10 - reverseOffset, width, width}, new int[]{0, 0, x + 10, x}, 4);
            }
        }
        finally {
            graphics.dispose();
        }
    }
}

