/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.components.barcode4j.OrientationEnum;
import net.sf.jasperreports.components.barcode4j.QRCodeBean;
import net.sf.jasperreports.components.barcode4j.QRCodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleRenderToImageAwareDataRenderer;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QRCodeSVGImageProducer
implements QRCodeImageProducer {
    public static final int DEFAULT_MARGIN = 4;

    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, QRCodeBean qrCodeBean, String message) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        String encoding = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(componentElement, "net.sf.jasperreports.components.qrcode.character.encoding", "UTF-8");
        if (!encoding.isEmpty()) {
            hints.put(EncodeHintType.CHARACTER_SET, encoding);
        }
        ErrorCorrectionLevel errorCorrectionLevel = qrCodeBean.getErrorCorrectionLevel().getErrorCorrectionLevel();
        hints.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
        Integer qrVersion = qrCodeBean.getQrVersion();
        if (qrVersion != null) {
            hints.put(EncodeHintType.QR_VERSION, qrVersion);
        }
        ByteMatrix matrix = null;
        SVGCanvasProvider provider = null;
        try {
            QRCode qrCode = Encoder.encode((String)message, (ErrorCorrectionLevel)errorCorrectionLevel, hints);
            matrix = qrCode.getMatrix();
            provider = new SVGCanvasProvider(false, OrientationEnum.UP.getValue().intValue());
        }
        catch (WriterException | BarcodeCanvasSetupException e) {
            throw new JRRuntimeException(e);
        }
        Document svgDoc = provider.getDOM();
        Element svg = svgDoc.getDocumentElement();
        int codeWidth = matrix.getWidth();
        int codeHeight = matrix.getHeight();
        JRStyle elementStyle = componentElement.getStyle();
        int elementWidth = componentElement.getWidth() - (elementStyle == null ? 0 : elementStyle.getLineBox().getLeftPadding() + elementStyle.getLineBox().getRightPadding());
        int elementHeight = componentElement.getHeight() - (elementStyle == null ? 0 : elementStyle.getLineBox().getTopPadding() + elementStyle.getLineBox().getBottomPadding());
        int margin = qrCodeBean.getMargin() == null ? 4 : qrCodeBean.getMargin();
        int matrixWidth = codeWidth + 2 * margin;
        int matrixHeight = codeHeight + 2 * margin;
        int resolution = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty(componentElement, "net.sf.jasperreports.components.barcode4j.image.resolution", 300);
        int imageWidth = (int)Math.ceil((double)elementWidth * ((double)resolution / 72.0));
        int imageHeight = (int)Math.ceil((double)elementHeight * ((double)resolution / 72.0));
        double horizontalScale = (double)imageWidth / (double)matrixWidth;
        double verticalScale = (double)imageHeight / (double)matrixHeight;
        int scale = Math.max(1, (int)Math.min(Math.ceil(horizontalScale), Math.ceil(verticalScale)));
        int qrWidth = scale * matrixWidth;
        int qrHeight = scale * matrixHeight;
        double qrScale = Math.max(1.0, Math.max((double)qrWidth / (double)imageWidth, (double)qrHeight / (double)imageHeight));
        int svgWidth = (int)Math.ceil(qrScale * (double)imageWidth);
        int svgHeight = (int)Math.ceil(qrScale * (double)imageHeight);
        svg.setAttribute("width", String.valueOf(svgWidth));
        svg.setAttribute("height", String.valueOf(svgHeight));
        svg.setAttribute("viewBox", "0 0 " + svgWidth + " " + svgHeight);
        int xOffset = Math.max(0, (svgWidth - qrWidth) / 2);
        int yOffset = Math.max(0, (svgHeight - qrHeight) / 2);
        Color color = componentElement.getForecolor();
        String fill = "#" + JRColorUtil.getColorHexa(color);
        String fillOpacity = color.getAlpha() < 255 ? Float.toString((float)color.getAlpha() / 255.0f) : null;
        String rectangleSize = Integer.toString(scale);
        for (int x = 0; x < codeWidth; ++x) {
            for (int y = 0; y < codeHeight; ++y) {
                if (matrix.get(x, y) != 1) continue;
                Element element = svgDoc.createElementNS(svg.getNamespaceURI(), "rect");
                element.setAttribute("x", String.valueOf(xOffset + scale * (x + margin)));
                element.setAttribute("y", String.valueOf(yOffset + scale * (y + margin)));
                element.setAttribute("width", rectangleSize);
                element.setAttribute("height", rectangleSize);
                element.setAttribute("fill", fill);
                if (fillOpacity != null) {
                    element.setAttribute("fill-opacity", fillOpacity);
                }
                svgDoc.getFirstChild().appendChild(element);
            }
        }
        DOMSource source = new DOMSource(svgDoc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult output = new StreamResult(baos);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
        }
        catch (TransformerException e) {
            throw new JRRuntimeException(e);
        }
        return SimpleRenderToImageAwareDataRenderer.getInstance(baos.toByteArray());
    }
}

