/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeImageProducer;
import net.sf.jasperreports.components.barcode4j.OrientationEnum;
import net.sf.jasperreports.components.barcode4j.QRCodeImageProducer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRSingletonCache;

public final class BarcodeUtils {
    protected static JRSingletonCache<BarcodeImageProducer> imageProducerCache = new JRSingletonCache<BarcodeImageProducer>(BarcodeImageProducer.class);
    protected static JRSingletonCache<QRCodeImageProducer> qrCodeProducerCache = new JRSingletonCache<QRCodeImageProducer>(QRCodeImageProducer.class);
    private JasperReportsContext jasperReportsContext;

    private BarcodeUtils(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static BarcodeUtils getInstance(JasperReportsContext jasperReportsContext) {
        return new BarcodeUtils(jasperReportsContext);
    }

    public BarcodeImageProducer getProducer(JRPropertiesHolder propertiesHolder) {
        String producerProperty = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, "net.sf.jasperreports.components.barcode4j.image.producer");
        String producerClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, "net.sf.jasperreports.components.barcode4j.image.producer." + producerProperty);
        if (producerClass == null) {
            producerClass = producerProperty;
        }
        try {
            return imageProducerCache.getCachedInstance(producerClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public QRCodeImageProducer getQRCodeProducer(JRPropertiesHolder propertiesHolder) {
        String producerProperty = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, "net.sf.jasperreports.components.barcode4j.image.producer");
        String producerClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, "net.sf.jasperreports.components.barcode4j.qrcode.producer." + producerProperty);
        if (producerClass == null) {
            producerClass = producerProperty;
        }
        try {
            return qrCodeProducerCache.getCachedInstance(producerClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static boolean isVertical(Barcode4jComponent barcode) {
        OrientationEnum orientation = barcode.getOrientationValue();
        return orientation == OrientationEnum.LEFT || orientation == OrientationEnum.RIGHT;
    }
}

