/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignTimeSeriesDataset
extends JRDesignChartDataset
implements JRTimeSeriesDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIOD = "timePeriod";
    public static final String PROPERTY_TIME_SERIES = "timeSeries";
    private List<JRTimeSeries> timeSeriesList = new ArrayList<JRTimeSeries>();
    private TimePeriodEnum timePeriodValue;
    private int PSEUDO_SERIAL_VERSION_UID = 62100;
    private Class<?> timePeriod;

    public JRDesignTimeSeriesDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRTimeSeries[] getSeries() {
        JRTimeSeries[] timeSeriesArray = new JRTimeSeries[this.timeSeriesList.size()];
        this.timeSeriesList.toArray(timeSeriesArray);
        return timeSeriesArray;
    }

    public List<JRTimeSeries> getSeriesList() {
        return this.timeSeriesList;
    }

    public void addTimeSeries(JRTimeSeries timeSeries) {
        this.timeSeriesList.add(timeSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_SERIES, timeSeries, this.timeSeriesList.size() - 1);
    }

    public void addTimeSeries(int index, JRTimeSeries timeSeries) {
        this.timeSeriesList.add(index, timeSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_SERIES, timeSeries, index);
    }

    public JRTimeSeries removeTimeSeries(JRTimeSeries timeSeries) {
        int idx;
        if (timeSeries != null && (idx = this.timeSeriesList.indexOf(timeSeries)) >= 0) {
            this.timeSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TIME_SERIES, timeSeries, idx);
        }
        return timeSeries;
    }

    @Override
    public Class<?> getTimePeriod() {
        return ChartUtil.getTimePeriod(this.timePeriodValue);
    }

    @Override
    public void setTimePeriod(Class<?> timePeriod) {
        this.setTimePeriod(ChartUtil.getTimePeriod(timePeriod));
    }

    @Override
    public TimePeriodEnum getTimePeriodValue() {
        return this.timePeriodValue;
    }

    @Override
    public void setTimePeriod(TimePeriodEnum timePeriodValue) {
        TimePeriodEnum old = this.timePeriodValue;
        this.timePeriodValue = timePeriodValue;
        this.getEventSupport().firePropertyChange(PROPERTY_TIME_PERIOD, old, this.timePeriodValue);
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRDesignTimeSeriesDataset clone = (JRDesignTimeSeriesDataset)super.clone();
        clone.timeSeriesList = JRCloneUtils.cloneList(this.timeSeriesList);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 62100) {
            this.timePeriodValue = ChartUtil.getTimePeriod(this.timePeriod);
        }
    }
}

