/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.base.JRBaseChartDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBasePieDataset
extends JRBaseChartDataset
implements JRPieDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_PERCENTAGE = "minPercentage";
    public static final String PROPERTY_MAX_COUNT = "maxCount";
    private Float minPercentage;
    private Integer maxCount;
    protected JRPieSeries[] pieSeries;
    protected JRExpression otherKeyExpression;
    protected JRExpression otherLabelExpression;
    private JRHyperlink otherSectionHyperlink;
    private transient JRPropertyChangeSupport eventSupport;
    private JRExpression keyExpression;
    private JRExpression valueExpression;
    private JRExpression labelExpression;
    private JRHyperlink sectionHyperlink;

    public JRBasePieDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBasePieDataset(JRPieDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        this.minPercentage = dataset.getMinPercentage();
        this.maxCount = dataset.getMaxCount();
        JRPieSeries[] srcPieSeries = dataset.getSeries();
        if (srcPieSeries != null && srcPieSeries.length > 0) {
            this.pieSeries = new JRPieSeries[srcPieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i] = factory.getPieSeries(srcPieSeries[i]);
            }
        }
        this.otherKeyExpression = factory.getExpression(dataset.getOtherKeyExpression());
        this.otherLabelExpression = factory.getExpression(dataset.getOtherLabelExpression());
        this.otherSectionHyperlink = factory.getHyperlink(dataset.getOtherSectionHyperlink());
    }

    @Override
    public Float getMinPercentage() {
        return this.minPercentage;
    }

    @Override
    public void setMinPercentage(Float minPercentage) {
        Float old = this.minPercentage;
        this.minPercentage = minPercentage;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_PERCENTAGE, old, this.minPercentage);
    }

    @Override
    public Integer getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void setMaxCount(Integer maxCount) {
        Integer old = this.maxCount;
        this.maxCount = maxCount;
        this.getEventSupport().firePropertyChange(PROPERTY_MAX_COUNT, old, this.maxCount);
    }

    @Override
    public JRPieSeries[] getSeries() {
        return this.pieSeries;
    }

    @Override
    public JRExpression getOtherKeyExpression() {
        return this.otherKeyExpression;
    }

    @Override
    public JRExpression getOtherLabelExpression() {
        return this.otherLabelExpression;
    }

    @Override
    public JRHyperlink getOtherSectionHyperlink() {
        return this.otherSectionHyperlink;
    }

    @Override
    public byte getDatasetType() {
        return 1;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRBasePieDataset clone = (JRBasePieDataset)super.clone();
        clone.pieSeries = (JRPieSeries[])JRCloneUtils.cloneArray((JRCloneable[])this.pieSeries);
        clone.otherKeyExpression = JRCloneUtils.nullSafeClone(this.otherKeyExpression);
        clone.otherLabelExpression = JRCloneUtils.nullSafeClone(this.otherLabelExpression);
        clone.otherSectionHyperlink = JRCloneUtils.nullSafeClone(this.otherSectionHyperlink);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePieDataset jRBasePieDataset = this;
        synchronized (jRBasePieDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.pieSeries == null) {
            this.pieSeries = new JRPieSeries[1];
            JRDesignPieSeries ps = new JRDesignPieSeries();
            ps.setKeyExpression(this.keyExpression);
            ps.setValueExpression(this.valueExpression);
            ps.setLabelExpression(this.labelExpression);
            ps.setSectionHyperlink(this.sectionHyperlink);
            this.pieSeries[0] = ps;
            this.keyExpression = null;
            this.valueExpression = null;
            this.labelExpression = null;
            this.sectionHyperlink = null;
        }
    }
}

