/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.inspector.util.DatmlRawResources;
import de.destatis.core.inspector.util.InspectionHelper;
import de.destatis.core.inspector.util.Location;
import de.destatis.core.inspector.util.SyntaxInspection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SemanticsInspection
extends SyntaxInspection {
    private static final String WRONG_NUMBER_OF_MESSAGES_WARN_NUM = "001";
    private static final String WRONG_NUMBER_OF_MESSAGES_WARN_TEXT = "Die Anzahl der Nachrichten muss mit der Angabe im Element anzahl \u00fcbereinstimmen.";
    private static final String WRONG_OCCURS_OF_SURVEY_ERROR_NUM = "001";
    private static final String WRONG_OCCURS_OF_SURVEY_ERROR_TEXT = "Jeder Meldung muss genau ein Element erhebung zugeordnet sein.";
    private static final String WRONG_OCCURS_OF_PERIOD_ERROR_NUM = "002";
    private static final String WRONG_OCCURS_OF_PERIOD_ERROR_TEXT = "Jeder Meldung muss genau ein Element berichtszeitraum zugeordnet sein.";
    private static final String WRONG_OCCURS_OF_DECLARANT_ERROR_NUM = "003";
    private static final String WRONG_OCCURS_OF_DECLARANT_ERROR_TEXT = "Jeder Meldung darf h\u00f6chstens ein Element berichtspflichtiger zugeordnet sein.";
    private static final String WRONG_OCCURS_OF_COLLECTOR_ERROR_NUM = "004";
    private static final String WRONG_OCCURS_OF_COLLECTOR_ERROR_TEXT = "Jeder Meldung darf h\u00f6chstens ein Element berichtsempfaenger zugeordnet sein.";
    private static final String WRONG_OCCURS_OF_MATERIAL_ERROR_NUM = "005";
    private static final String WRONG_OCCURS_OF_MATERIAL_ERROR_TEXT = "Jeder Meldung darf h\u00f6chstens ein Element material zugeordnet sein.";
    private static final String WRONG_OCCURS_OF_DATA_ATTR_ERROR_NUM = "006";
    private static final String WRONG_OCCURS_OF_DATA_ATTR_ERROR_TEXT = "Jeder Meldung darf h\u00f6chstens ein Element datenattribute zugeordnet sein.";
    private static final String NO_HELP_FEATURE_NAME_ERROR_NUM = "007";
    private static final String NO_HELP_FEATURE_NAME_ERROR_TEXT = "Ein Hilfsmerkmal muss einen Namen (Attribut name) haben.";
    private static final String DUPLICATE_HELP_FEATURE_ERROR_NUM = "008";
    private static final String DUPLICATE_HELP_FEATURE_ERROR_TEXT = "Die Hilfsmerkmale einer Meldung m\u00fcssen verschiedene Namen (Attribut name) haben.";
    private static final String NO_FEATURE_NAME_ERROR_NUM = "009";
    private static final String NO_FEATURE_NAME_ERROR_TEXT = "Ein Merkmal muss einen Namen (Attribut name) haben.";
    private static final String DUPLICATE_FEATURE_ERROR_NUM = "010";
    private static final String DUPLICATE_FEATURE_ERROR_TEXT = "Ein Merkmal (Attribut name) darf nur einmal in einem Datensatz oder einer Merkmalsgruppe vorkommen.";
    private static final String NO_FEATURE_GROUP_NAME_ERROR_NUM = "011";
    private static final String NO_FEATURE_GROUP_NAME_ERROR_TEXT = "Eine Merkmalsgruppe muss einen Namen (Attribut name) haben.";
    private static final String WRONG_FEATURE_GROUP_INDEX_ERROR_NUM = "012";
    private static final String WRONG_FEATURE_GROUP_INDEX_ERROR_TEXT = "Der Index einer Merkmalsgruppe (Attribut index) darf nur numerisch sein oder ein indexbildendes Merkmal in der Form name(<merkmalsname>).";
    private static final String INDEX_FEATURE_NOT_EXIST_ERROR_NUM = "013";
    private static final String INDEX_FEATURE_NOT_EXIST_ERROR_TEXT = "Das indexbildende Merkmal muss in der Merkmalsgruppe vorkommen und darf nicht leer sein.";
    private static final String WRONG_INDEX_IN_FEATURE_ERROR_NUM = "014";
    private static final String WRONG_INDEX_IN_FEATURE_ERROR_TEXT = "Der Wert des indexbildenden Merkmals muss numerisch sein.";
    private static final String DUPLICATE_INDEX_ERROR_NUM = "015";
    private static final String DUPLICATE_INDEX_ERROR_TEXT = "Die Indizes einer Merkmalsgruppe m\u00fcssen alle verschieden sein.";
    private static final String DIFFERENT_INDEX_METHOD_ERROR_NUM = "016";
    private static final String DIFFERENT_INDEX_METHOD_ERROR_TEXT = "Die Indizierungsmethode muss f\u00fcr alle Instanzen einer Merkmalsgruppe gleich sein.";
    protected char decimalChar = (char)44;
    protected char thousendDivChar = (char)46;
    private Integer msgnum = null;
    private ProblemPosition position = null;
    private Stack<SegmentInfo> segments = null;
    private Map<String, String> featureGroupIndexKinds = new HashMap<String, String>();
    private Stack<MmgrIndexInfo> mmgrIndexInfoStack = new Stack();
    private MmgrIndexInfo currentMmgrIndexInfo = null;
    private Map<String, String> featureGroupFeatureIndexMethods = new HashMap<String, String>();

    public SemanticsInspection() {
        this.inspectionLevel = 2;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.msgnum = null;
        this.position = null;
        this.segments = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, raw, attributes);
        if (DatmlRawResources.isMessage(raw)) {
            this.segments.push(new SegmentInfo());
            this.decimalChar = (char)44;
            this.thousendDivChar = (char)46;
        } else if (DatmlRawResources.isSegment(raw)) {
            this.segments.push(new SegmentInfo());
        } else if (DatmlRawResources.isSurvey(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.surveyInPath()) {
                    this.errorProblem(2, "001", WRONG_OCCURS_OF_SURVEY_ERROR_TEXT);
                } else {
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setSurvey(true);
                }
            }
        } else if (DatmlRawResources.isReportingPeriod(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.reportingPeriodInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_PERIOD_ERROR_NUM, WRONG_OCCURS_OF_PERIOD_ERROR_TEXT);
                } else {
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setReportingPeriod(true);
                }
            }
        } else if (DatmlRawResources.isDeclarant(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.declarantInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_DECLARANT_ERROR_NUM, WRONG_OCCURS_OF_DECLARANT_ERROR_TEXT);
                } else {
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setDeclarant(true);
                }
            }
        } else if (DatmlRawResources.isCollector(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.collectorInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_COLLECTOR_ERROR_NUM, WRONG_OCCURS_OF_COLLECTOR_ERROR_TEXT);
                } else {
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setCollector(true);
                }
            }
        } else if (DatmlRawResources.isMaterial(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.materialInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_MATERIAL_ERROR_NUM, WRONG_OCCURS_OF_MATERIAL_ERROR_TEXT);
                } else {
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setMaterial(true);
                }
            }
        } else if (DatmlRawResources.isDataAttributes(raw)) {
            if (!this.segments.isEmpty()) {
                if (this.dataAttributesInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_DATA_ATTR_ERROR_NUM, WRONG_OCCURS_OF_DATA_ATTR_ERROR_TEXT);
                } else {
                    String thousendDivCharAtt;
                    SegmentInfo segInfo = this.segments.peek();
                    segInfo.setDataAttributes(true);
                    String decimalCharAtt = attributes.getValue("dezimalzeichen");
                    if (decimalCharAtt != null && (decimalCharAtt = decimalCharAtt.trim()).length() > 0) {
                        this.decimalChar = decimalCharAtt.charAt(0);
                    }
                    if ((thousendDivCharAtt = attributes.getValue("tausender-trennzeichen")) != null && (thousendDivCharAtt = thousendDivCharAtt.trim()).length() > 0) {
                        this.thousendDivChar = thousendDivCharAtt.charAt(0);
                    }
                }
            }
        } else if (DatmlRawResources.isHelpFeature(raw)) {
            if (!this.segments.isEmpty()) {
                String helpFeatureName = attributes.getValue("name");
                if (helpFeatureName != null && helpFeatureName.trim().length() > 0) {
                    if (this.helpFeatureInPath(helpFeatureName)) {
                        this.errorProblem(2, DUPLICATE_HELP_FEATURE_ERROR_NUM, DUPLICATE_HELP_FEATURE_ERROR_TEXT);
                    } else {
                        SegmentInfo segInfo = this.segments.peek();
                        Location helpFeatureLocation = new Location(this.getCurrentXPath(), this.getCurrentLineNumber(), this.getCurrentColumnNumber());
                        segInfo.addHelpFeature(helpFeatureName, helpFeatureLocation);
                    }
                } else if (attributes.getIndex("name") > -1) {
                    this.errorProblem(2, NO_HELP_FEATURE_NAME_ERROR_NUM, NO_HELP_FEATURE_NAME_ERROR_TEXT);
                }
            }
        } else if (DatmlRawResources.isDeclaration(raw)) {
            String path = this.getCurrentXPath();
            if (path != null && path.length() > 0) {
                if (!this.surveyInPath()) {
                    this.errorProblem(2, "001", WRONG_OCCURS_OF_SURVEY_ERROR_TEXT);
                }
                if (!this.reportingPeriodInPath()) {
                    this.errorProblem(2, WRONG_OCCURS_OF_PERIOD_ERROR_NUM, WRONG_OCCURS_OF_PERIOD_ERROR_TEXT);
                }
            }
        } else if (DatmlRawResources.isRecord(raw)) {
            this.featureGroupIndexKinds.clear();
            this.featureGroupFeatureIndexMethods.clear();
            this.mmgrIndexInfoStack.clear();
            this.mmgrIndexInfoStack.push(new MmgrIndexInfo());
        } else if (DatmlRawResources.isFeatureGroup(raw)) {
            this.currentMmgrIndexInfo = !this.mmgrIndexInfoStack.isEmpty() ? this.mmgrIndexInfoStack.peek() : null;
            this.mmgrIndexInfoStack.push(new MmgrIndexInfo());
            String featureGroupName = attributes.getValue("name");
            if (featureGroupName != null && featureGroupName.trim().length() > 0) {
                String indexKind = this.getFeatureGroupIndexKind(featureGroupName);
                String index = attributes.getValue("index");
                if (index != null && index.length() > 0) {
                    if (InspectionHelper.isNumeric(index)) {
                        if (indexKind == null) {
                            this.featureGroupIndexKinds.put(featureGroupName, "NUMERIC");
                            if (this.currentMmgrIndexInfo != null) {
                                this.currentMmgrIndexInfo.addFeatureGroupIndex(featureGroupName, index);
                            }
                        } else if (!"NUMERIC".equals(indexKind)) {
                            this.errorProblem(2, DIFFERENT_INDEX_METHOD_ERROR_NUM, DIFFERENT_INDEX_METHOD_ERROR_TEXT);
                        } else if (this.currentMmgrIndexInfo != null && this.currentMmgrIndexInfo.containsFeatureGroupIndex(featureGroupName, index)) {
                            this.errorProblem(2, DUPLICATE_INDEX_ERROR_NUM, DUPLICATE_INDEX_ERROR_TEXT);
                        } else if (this.currentMmgrIndexInfo != null) {
                            this.currentMmgrIndexInfo.addFeatureGroupIndex(featureGroupName, index);
                        }
                    } else if (index.startsWith("name(") && index.endsWith(")")) {
                        if (this.currentMmgrIndexInfo != null) {
                            this.currentMmgrIndexInfo.currentFeatureGroupName = featureGroupName;
                            this.currentMmgrIndexInfo.currentIndexFeature = index.substring(5, index.length() - 1);
                            this.currentMmgrIndexInfo.indexFeatureFound = false;
                        }
                        if (indexKind == null) {
                            this.featureGroupIndexKinds.put(featureGroupName, "FEATURE");
                            this.featureGroupFeatureIndexMethods.put(featureGroupName, index);
                        } else if (!"FEATURE".equals(indexKind)) {
                            this.errorProblem(2, DIFFERENT_INDEX_METHOD_ERROR_NUM, DIFFERENT_INDEX_METHOD_ERROR_TEXT);
                        } else {
                            String featureGroupFeatureIndexMethod = this.featureGroupFeatureIndexMethods.get(featureGroupName);
                            if (!featureGroupFeatureIndexMethod.equals(index)) {
                                this.errorProblem(2, DIFFERENT_INDEX_METHOD_ERROR_NUM, DIFFERENT_INDEX_METHOD_ERROR_TEXT);
                            }
                        }
                    } else {
                        this.errorProblem(2, WRONG_FEATURE_GROUP_INDEX_ERROR_NUM, WRONG_FEATURE_GROUP_INDEX_ERROR_TEXT);
                    }
                } else if (attributes.getIndex("index") >= 0) {
                    this.errorProblem(2, WRONG_FEATURE_GROUP_INDEX_ERROR_NUM, WRONG_FEATURE_GROUP_INDEX_ERROR_TEXT);
                } else if (indexKind == null) {
                    this.featureGroupIndexKinds.put(featureGroupName, "NONE");
                } else if (!"NONE".equals(indexKind)) {
                    this.errorProblem(2, DIFFERENT_INDEX_METHOD_ERROR_NUM, DIFFERENT_INDEX_METHOD_ERROR_TEXT);
                }
            } else if (attributes.getIndex("name") > -1) {
                this.errorProblem(2, NO_FEATURE_GROUP_NAME_ERROR_NUM, NO_FEATURE_GROUP_NAME_ERROR_TEXT);
            }
        } else if (DatmlRawResources.isFeature(raw)) {
            String feature;
            if (this.currentMmgrIndexInfo != null) {
                this.currentMmgrIndexInfo.currentFeatureIsIndex = false;
                this.currentMmgrIndexInfo.indexFeatureValueFound = false;
            }
            if ((feature = attributes.getValue("name")) != null && feature.trim().length() > 0) {
                if (this.getCurrentElementOccurences() > 1) {
                    this.errorProblem(2, DUPLICATE_FEATURE_ERROR_NUM, DUPLICATE_FEATURE_ERROR_TEXT);
                }
                if (this.currentMmgrIndexInfo != null && this.currentMmgrIndexInfo.currentIndexFeature != null && feature.equals(this.currentMmgrIndexInfo.currentIndexFeature)) {
                    this.currentMmgrIndexInfo.indexFeatureFound = true;
                    this.currentMmgrIndexInfo.currentFeatureIsIndex = true;
                }
            } else if (attributes.getIndex("name") > -1) {
                this.errorProblem(2, NO_FEATURE_NAME_ERROR_NUM, NO_FEATURE_NAME_ERROR_TEXT);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String raw) throws SAXException {
        String value;
        if (DatmlRawResources.isMessage(raw)) {
            this.segments.pop();
        } else if (DatmlRawResources.isSegment(raw)) {
            this.segments.pop();
        } else if (DatmlRawResources.isFeatureGroup(raw)) {
            if (this.currentMmgrIndexInfo != null) {
                if (this.currentMmgrIndexInfo.currentIndexFeature != null && !this.currentMmgrIndexInfo.indexFeatureFound) {
                    this.errorProblem(2, INDEX_FEATURE_NOT_EXIST_ERROR_NUM, INDEX_FEATURE_NOT_EXIST_ERROR_TEXT);
                }
                this.currentMmgrIndexInfo.currentIndexFeature = null;
                this.currentMmgrIndexInfo.indexFeatureFound = false;
            }
            if (this.mmgrIndexInfoStack.size() > 1) {
                this.mmgrIndexInfoStack.pop();
                this.currentMmgrIndexInfo = this.mmgrIndexInfoStack.peek();
            }
        } else if (DatmlRawResources.isNumOfMessages(raw)) {
            try {
                this.msgnum = new Integer(this.getTextBufferTrimed());
                this.position = this.getCurrentPosition();
            }
            catch (Exception e) {
                this.msgnum = null;
                this.position = null;
            }
        } else if (DatmlRawResources.isFeature(raw)) {
            if (this.currentMmgrIndexInfo != null && this.currentMmgrIndexInfo.currentFeatureIsIndex && !this.currentMmgrIndexInfo.indexFeatureValueFound) {
                this.errorProblem(2, INDEX_FEATURE_NOT_EXIST_ERROR_NUM, INDEX_FEATURE_NOT_EXIST_ERROR_TEXT, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.currentMmgrIndexInfo.currentIndexFeature));
            }
        } else if (DatmlRawResources.isValue(raw) && this.currentMmgrIndexInfo != null && this.currentMmgrIndexInfo.currentFeatureIsIndex && (value = this.getTextBuffer()) != null && value.length() > 0) {
            this.currentMmgrIndexInfo.indexFeatureValueFound = true;
            if (!InspectionHelper.isNumeric(value)) {
                this.errorProblem(2, WRONG_INDEX_IN_FEATURE_ERROR_NUM, WRONG_INDEX_IN_FEATURE_ERROR_TEXT, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.currentMmgrIndexInfo.currentIndexFeature));
            } else if (this.currentMmgrIndexInfo.containsFeatureGroupIndex(this.currentMmgrIndexInfo.currentFeatureGroupName, value)) {
                this.errorProblem(2, DUPLICATE_INDEX_ERROR_NUM, DUPLICATE_INDEX_ERROR_TEXT, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.currentMmgrIndexInfo.currentIndexFeature));
            } else {
                this.currentMmgrIndexInfo.addFeatureGroupIndex(this.currentMmgrIndexInfo.currentFeatureGroupName, value);
            }
        }
        super.endElement(uri, localName, raw);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.msgnum != null && this.getReporter().getNumOfMessages() != this.msgnum.intValue()) {
            this.warningProblem(2, "001", WRONG_NUMBER_OF_MESSAGES_WARN_TEXT, this.position);
        }
        super.endDocument();
    }

    private boolean surveyInPath() {
        boolean surveyInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isSurvey()) continue;
            surveyInPath = true;
            break;
        }
        return surveyInPath;
    }

    private boolean reportingPeriodInPath() {
        boolean reportingPeriodInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isReportingPeriod()) continue;
            reportingPeriodInPath = true;
            break;
        }
        return reportingPeriodInPath;
    }

    private boolean declarantInPath() {
        boolean declarantInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isDeclarant()) continue;
            declarantInPath = true;
            break;
        }
        return declarantInPath;
    }

    protected boolean collectorInPath() {
        boolean collectorInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isCollector()) continue;
            collectorInPath = true;
            break;
        }
        return collectorInPath;
    }

    private boolean materialInPath() {
        boolean materialInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isMaterial()) continue;
            materialInPath = true;
            break;
        }
        return materialInPath;
    }

    private boolean dataAttributesInPath() {
        boolean dataAttributesInPath = false;
        for (SegmentInfo segInfo : this.segments) {
            if (!segInfo.isDataAttributes()) continue;
            dataAttributesInPath = true;
            break;
        }
        return dataAttributesInPath;
    }

    private boolean helpFeatureInPath(String helpFeatureName) {
        boolean helpFeatureInPath = false;
        Iterator it = this.segments.iterator();
        while (!helpFeatureInPath && it.hasNext()) {
            SegmentInfo segInfo = (SegmentInfo)it.next();
            Iterator<String> helpFeatureIt = segInfo.getHelpFeatureNames();
            while (!helpFeatureInPath && helpFeatureIt.hasNext()) {
                String checkHelpFeatureName = helpFeatureIt.next();
                if (!checkHelpFeatureName.equals(helpFeatureName)) continue;
                helpFeatureInPath = true;
            }
        }
        return helpFeatureInPath;
    }

    protected Location getHelpFeatureLocation(String helpFeatureName) {
        Location result = null;
        if (!this.segments.isEmpty()) {
            Iterator it = this.segments.iterator();
            while (result == null && it.hasNext()) {
                SegmentInfo segInfo = (SegmentInfo)it.next();
                result = segInfo.getHelpFeatureLocation(helpFeatureName);
            }
        }
        return result;
    }

    protected String getFeatureGroupIndexKind(String featureGroupName) {
        return this.featureGroupIndexKinds.get(featureGroupName);
    }

    protected String getFeatureGroupIndexFeature(String featureGroupName) {
        String indexFeature = null;
        String indexMethod = this.featureGroupFeatureIndexMethods.get(featureGroupName);
        if (indexMethod != null) {
            indexFeature = indexMethod.substring("name(".length(), indexMethod.length() - 1);
        }
        return indexFeature;
    }

    protected Iterator<String> getCurrentSegmentHelpFeatureNames() {
        SegmentInfo segmentInfo = this.segments.peek();
        Iterator<String> it = segmentInfo.getHelpFeatureNames();
        return it;
    }

    protected boolean helpFeatureInCurrentSegment(String helpFeatureName) {
        SegmentInfo segmentInfo = this.segments.peek();
        boolean result = segmentInfo.containsHelpFeature(helpFeatureName);
        return result;
    }

    protected Iterator<SegmentInfo> getSegmentInfoIterator() {
        return this.segments.iterator();
    }

    protected SegmentInfo getCurrentSegmentInfo() {
        SegmentInfo result = !this.segments.isEmpty() ? this.segments.peek() : null;
        return result;
    }

    protected Stack<SegmentInfo> getSegmentInfoStack() {
        return this.segments;
    }

    protected static class MmgrIndexInfo {
        private Map<String, Set<String>> featureGroupIndices = new HashMap<String, Set<String>>();
        private String currentFeatureGroupName;
        private String currentIndexFeature = null;
        private boolean indexFeatureFound = false;
        private boolean currentFeatureIsIndex = false;
        private boolean indexFeatureValueFound = false;

        protected MmgrIndexInfo() {
        }

        public void addFeatureGroupIndex(String featureGroupName, String index) {
            Set<String> indices = this.featureGroupIndices.get(featureGroupName);
            if (indices == null) {
                indices = new HashSet<String>();
                this.featureGroupIndices.put(featureGroupName, indices);
            }
            indices.add(index);
        }

        public boolean containsFeatureGroupIndex(String featureGroupName, String index) {
            boolean result = false;
            Set<String> indices = this.featureGroupIndices.get(featureGroupName);
            if (indices != null) {
                result = indices.contains(index);
            }
            return result;
        }
    }

    protected static class SegmentInfo {
        private boolean survey = false;
        private boolean reportingPeriod = false;
        private boolean declarant = false;
        private boolean collector = false;
        private boolean material = false;
        private boolean dataAttributes = false;
        private LinkedHashMap<String, Location> helpFeatures = new LinkedHashMap();
        private String collectorValue = null;

        public boolean isSurvey() {
            return this.survey;
        }

        public void setSurvey(boolean survey) {
            this.survey = survey;
        }

        public boolean isReportingPeriod() {
            return this.reportingPeriod;
        }

        public void setReportingPeriod(boolean reportingPeriod) {
            this.reportingPeriod = reportingPeriod;
        }

        public boolean isDeclarant() {
            return this.declarant;
        }

        public void setDeclarant(boolean declarant) {
            this.declarant = declarant;
        }

        public boolean isCollector() {
            return this.collector;
        }

        public void setCollector(boolean collector) {
            this.collector = collector;
        }

        public void setCollectorValue(String collectorValue) {
            this.collectorValue = collectorValue;
        }

        public String getCollectorValue() {
            return this.collectorValue;
        }

        public boolean isMaterial() {
            return this.material;
        }

        public void setMaterial(boolean material) {
            this.material = material;
        }

        public boolean isDataAttributes() {
            return this.dataAttributes;
        }

        public void setDataAttributes(boolean dataAttributes) {
            this.dataAttributes = dataAttributes;
        }

        public Iterator<String> getHelpFeatureNames() {
            Iterator<String> it = this.helpFeatures.keySet().iterator();
            return it;
        }

        public boolean containsHelpFeature(String helpFeatureName) {
            boolean result = this.helpFeatures.containsKey(helpFeatureName);
            return result;
        }

        public void addHelpFeature(String helpFeatureName, Location helpFeatureLocation) {
            this.helpFeatures.put(helpFeatureName, helpFeatureLocation);
        }

        public Location getHelpFeatureLocation(String helpFeatureName) {
            Location result = this.helpFeatures.get(helpFeatureName);
            return result;
        }
    }
}

