/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.inspector.InspectionController;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.inspector.util.AuthorizingInspection;
import de.destatis.core.inspector.util.DatmlRawResources;
import de.destatis.core.inspector.util.ExtResourceDirNotExistsResourceAccessException;
import de.destatis.core.inspector.util.FatalException;
import de.destatis.core.inspector.util.Inspection;
import de.destatis.core.inspector.util.InspectionHelper;
import de.destatis.core.inspector.util.Location;
import de.destatis.core.inspector.util.SemanticsInspection;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SurveyResource;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.sdf.generator.interpreter.SDFFieldDescriptorFactory;
import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.util.FeaturesVisitor;
import de.statspez.sdf.generator.meta.util.HelpFeaturesVisitor;
import de.statspez.sdf.generator.meta.util.SDFStructureHelper;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataInspection
extends AuthorizingInspection {
    private static final String NO_SDF_WARN_NUM = "001";
    private static final String NO_SDF_WARN_TEXT = "Es sind keine Erhebungsbeschreibungen vorhanden.";
    private static final String NO_SDF_FOR_SURVEY_ID_WARN_NUM = "002";
    private static final String NO_SDF_FOR_SURVEY_ID_WARN_TEXT = "Zu der Erhebung %1 sind keine Erhebungsbeschreibungen vorhanden.";
    private static final String NO_SDF_FOR_REPORTING_PERIOD_TYPE_WARN_NUM = "003";
    private static final String NO_SDF_FOR_REPORTING_PERIOD_TYPE_WARN_TEXT = "F\u00fcr die Erhebung %1 und den Berichtszeitraum %2 gibt es keine Erhebungsbeschreibung.";
    private static final String NO_SDF_FOR_REPORTING_PERIOD_WARN_NUM = "004";
    private static final String NO_SDF_FOR_REPORTING_PERIOD_WARN_TEXT = "F\u00fcr die Erhebung %1 und den angegebenen Berichtszeitraum gibt es keine Erhebungsbeschreibung.";
    private static final String NO_SDF_FOR_COLLECTOR_WARN_NUM = "005";
    private static final String NO_SDF_FOR_COLLECTOR_WARN_TEXT = "F\u00fcr die Erhebung %1 und den Berichtsempf\u00e4nger %2 gibt es keine Erhebungsbeschreibung.";
    private static final String INVALID_HELP_FEATURE_WARN_NUM = "006";
    private static final String INVALID_HELP_FEATURE_WARN_TEXT = "Der Wert des Hilfsmerkmals liegt nicht im definierten Wertebereich.";
    private static final String INVALID_FEATURE_WARN_NUM = "007";
    private static final String INVALID_FEATURE_WARN_TEXT = "Der Wert des Merkmals liegt nicht im definierten Wertebereich.";
    private static final String CREATION_INSPECTION_DIFF_SDF_RESSOURCE_WARN_NUM = "008";
    private static final String CREATION_INSPECTION_DIFF_SDF_RESSOURCE_WARN_TEXT = "Die zur Erzeugung des DatML/RAW-Dokumentes verwendete DatML/SDF-Ressource %1 stimmt nicht mit der zur Pr\u00fcfung des DatML/RAW-Dokumentes verwendeten DatML/SDF-Ressource %2 \u00fcberein.";
    private static final String WRONG_SDF_FORMAT_ERR_NUM = "001";
    private static final String WRONG_SDF_FORMAT_ERR_TEXT = "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.";
    private static final String WRONG_SDF_CONTENT_ERR_NUM = "002";
    private static final String WRONG_SDF_CONTENT_ERR_TEXT = "Dateiname und Inhalt der Erhebungsbeschreibung passen nicht zusammen.";
    private static final String WRONG_SDF_CONDITION_FORMAT_ERR_NUM = "003";
    private static final String WRONG_SDF_CONDITION_FORMAT_ERR_TEXT = "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.";
    private static final String INVALID_HELP_FEATURE_ERR_NUM = "004";
    private static final String INVALID_HELP_FEATURE_ERR_TEXT = "Der Wert des Hilfsmerkmals liegt nicht im definierten Wertebereich.";
    private static final String NO_HELP_FEATURE_ERR_NUM = "005";
    private static final String NO_HELP_FEATURE_ERR_TEXT = "Das Hilfsmerkmal muss angegeben werden.";
    private static final String NO_CONDITIONAL_HELP_FEATURE_ERR_NUM = "006";
    private static final String NO_CONDITIONAL_HELP_FEATURE_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe des Hilfsmerkmals ist erf\u00fcllt, so dass das Hilfsmerkmal angegeben werden muss.";
    private static final String CONDITIONAL_HELP_FEATURE_ERR_NUM = "007";
    private static final String CONDITIONAL_HELP_FEATURE_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe des Hilfsmerkmals ist nicht erf\u00fcllt, so dass das Hilfsmerkmal nicht angegeben werden darf.";
    private static final String WRONG_HELP_FEATURE_ERR_NUM = "008";
    private static final String WRONG_HELP_FEATURE_ERR_TEXT = "Das Hilfsmerkmal ist an dieser Stelle unzul\u00e4ssig.";
    private static final String WRONG_RECORD_ERR_NUM = "009";
    private static final String WRONG_RECORD_ERR_TEXT = "Der Satz muss einer der definierten Satzarten entsprechen.";
    private static final String INVALID_FEATURE_ERR_NUM = "010";
    private static final String INVALID_FEATURE_ERR_TEXT = "Der Wert des Merkmals liegt nicht im definierten Wertebereich.";
    private static final String NO_FEATURE_ERR_NUM = "011";
    private static final String NO_FEATURE_ERR_TEXT = "Das Merkmal muss angegeben werden.";
    private static final String NO_CONDITIONAL_FEATURE_ERR_NUM = "012";
    private static final String NO_CONDITIONAL_FEATURE_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe des Merkmals ist erf\u00fcllt, so dass das Merkmal angegeben werden muss.";
    private static final String CONDITIONAL_FEATURE_ERR_NUM = "013";
    private static final String CONDITIONAL_FEATURE_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe des Merkmals ist nicht erf\u00fcllt, so dass das Merkmal nicht angegeben werden darf.";
    private static final String WRONG_FEATURE_ERR_NUM = "014";
    private static final String WRONG_FEATURE_ERR_TEXT = "Das Merkmal ist an dieser Stelle unzul\u00e4ssig.";
    private static final String WRONG_FEATURE_GROUP_INDEX_ERR_NUM = "015";
    private static final String WRONG_FEATURE_GROUP_INDEX_FEATURE_ERR_NUM = "016";
    private static final String WRONG_FEATURE_GROUP_INDEX_FEATURE_ERR_TEXT = "Das angegebene indexbildende Merkmal ist f\u00fcr die Merkmalsgruppe unzul\u00e4ssig.";
    private static final String WRONG_FEATURE_GROUP_OCCURENCES_ERR_NUM = "017";
    private static final String NO_FEATURE_GROUP_ERR_NUM = "018";
    private static final String NO_FEATURE_GROUP_ERR_TEXT = "Die Merkmalsgruppe muss angegeben werden.";
    private static final String NO_CONDITIONAL_FEATURE_GROUP_ERR_NUM = "019";
    private static final String NO_CONDITIONAL_FEATURE_GROUP_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist erf\u00fcllt, so dass die Merkmalsgruppe angegeben werden muss.";
    private static final String CONDITIONAL_FEATURE_GROUP_ERR_NUM = "020";
    private static final String CONDITIONAL_FEATURE_GROUP_ERR_TEXT = "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist nicht erf\u00fcllt, so dass die Merkmalsgruppe nicht angegeben werden darf.";
    private static final String WRONG_FEATURE_GROUP_ERR_NUM = "021";
    private static final String WRONG_FEATURE_GROUP_ERR_TEXT = "Die Merkmalsgruppe ist an dieser Stelle unzul\u00e4ssig.";
    private static final String WRONG_RECORD_OCCURENCES_ERR_NUM = "022";
    private static final String INVALID_SDF_DIR_FATAL_NUM = "001";
    private static final String INVALID_SDF_DIR_FATAL_TEXT = "Das konfigurierte Verzeichnis mit den verf\u00fcgbaren Erhebungsbeschreibungen ist ung\u00fcltig oder nicht vorhanden.";
    private String currentResourceID;
    private MetaErhebungsbeschreibung currentSDF;
    private SDFFieldDescriptorFactory currentFieldDescriptorFactory;
    private InterpreterContext currentContext;
    private ProgramInterpreter interpreter;
    private String currentErrNum;
    private String currentErrText;
    private boolean sdfResolved;
    private String currentSdfCreationRessourceId;
    private String currentRessourceKlasse;
    private Stack hierarchy;
    private String currentFeatureName;
    private Vector currentRecord;
    private HashMap values;
    private HashMap recordOccurences;
    private Map featureLocations;
    private Map featureValueLocations;
    private Map featureGroupLocations;
    private String ignoreGroupInXPath;
    private HelpFeatureInspection helpFeatureInspection;
    private FeaturesInspection featuresInspection;

    public DataInspection(InspectionController inspectionController) {
        super(inspectionController);
        this.inspectionLevel = 4;
        this.currentResourceID = null;
        this.currentSDF = null;
        this.currentFieldDescriptorFactory = null;
        this.currentContext = null;
        this.interpreter = new ProgramInterpreter();
        this.currentErrNum = null;
        this.currentErrText = null;
        this.currentSdfCreationRessourceId = null;
        this.currentRessourceKlasse = null;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.sdfResolved = false;
        this.hierarchy = new Stack();
        this.currentFeatureName = null;
        this.currentRecord = new Vector();
        this.values = new HashMap();
        this.recordOccurences = new HashMap();
        this.ignoreGroupInXPath = null;
        this.helpFeatureInspection = new HelpFeatureInspection();
        this.featuresInspection = new FeaturesInspection();
    }

    @Override
    public void startElement(String uri, String localName, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, raw, attributes);
        if (DatmlRawResources.isMessage(raw)) {
            this.sdfResolved = false;
        } else if (DatmlRawResources.isSegment(raw)) {
            this.sdfResolved = false;
        } else if (DatmlRawResources.isHelpFeature(raw)) {
            String helpFeatureName = attributes.getValue("name");
            if (helpFeatureName != null && helpFeatureName.trim().length() > 0) {
                this.currentFeatureName = helpFeatureName;
            }
        } else if (DatmlRawResources.isDeclaration(raw)) {
            this.checkSurveyDefinition();
            if (this.sdfResolved) {
                this.currentContext.setSatz((SatzInterface)new SimpleDataset((Map)this.values));
                Iterator<SemanticsInspection.SegmentInfo> segmentInfoIter = this.getSegmentInfoIterator();
                while (segmentInfoIter != null && segmentInfoIter.hasNext()) {
                    SemanticsInspection.SegmentInfo segmentInfo = segmentInfoIter.next();
                    Iterator<String> helpFeaturesIter = segmentInfo.getHelpFeatureNames();
                    while (helpFeaturesIter != null && helpFeaturesIter.hasNext()) {
                        String helpFeatureName = helpFeaturesIter.next();
                        MetaCustomSDFFeldReferenz helpFeatureRef = SDFStructureHelper.findHelpFeature((MetaErhebungsbeschreibung)this.currentSDF, (String)helpFeatureName);
                        if (helpFeatureRef == null) {
                            Location helpFeatureLocation = segmentInfo.getHelpFeatureLocation(helpFeatureName);
                            this.errorProblem(4, this.currentSDF.getProzedurCode(), "008", WRONG_HELP_FEATURE_ERR_TEXT, null, new ProblemPosition(helpFeatureLocation.getLineNumber(), helpFeatureLocation.getColumnNumber(), helpFeatureLocation.getXpath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), helpFeatureName));
                            continue;
                        }
                        if (this.values.get(helpFeatureName) == null) continue;
                        MetaCustomSDFMerkmal helpFeature = (MetaCustomSDFMerkmal)helpFeatureRef.getKlasse();
                        this.convertValue(helpFeatureName, helpFeature);
                    }
                }
                this.currentSDF.accept((ElementVisitorInterface)this.helpFeatureInspection);
            }
        } else if (DatmlRawResources.isFeatureGroup(raw)) {
            if (this.sdfResolved && this.ignoreGroupInXPath == null) {
                String featureGroupName = attributes.getValue("name");
                if (featureGroupName != null && featureGroupName.trim().length() > 0) {
                    int groupOccurences = this.getCurrentElementOccurences();
                    this.values.put(this.getHierarchy() + featureGroupName + "#anzahl", new Integer(groupOccurences));
                    this.currentRecord.add(this.getHierarchy() + featureGroupName + "#anzahl");
                    this.hierarchy.push(featureGroupName + '#' + (groupOccurences - 1));
                } else {
                    this.ignoreGroupInXPath = this.getCurrentXPath();
                }
            }
            if (this.sdfResolved && this.featureGroupLocations != null) {
                String xpath = this.getCurrentXPath();
                this.featureGroupLocations.put(xpath, new Location(xpath, this.getCurrentLineNumber(), this.getCurrentColumnNumber()));
            }
        } else if (DatmlRawResources.isFeature(raw)) {
            String featureName;
            if (this.sdfResolved && this.ignoreGroupInXPath == null && (featureName = attributes.getValue("name")) != null && featureName.trim().length() > 0) {
                this.currentFeatureName = this.getHierarchy() + featureName;
            }
            if (this.sdfResolved && this.featureLocations != null) {
                String xpath = this.getCurrentXPath();
                this.featureLocations.put(xpath, new Location(xpath, this.getCurrentLineNumber(), this.getCurrentColumnNumber()));
            }
        } else if (DatmlRawResources.isRecord(raw)) {
            this.featureLocations = new HashMap();
            this.featureValueLocations = new HashMap();
            this.featureGroupLocations = new HashMap();
        } else if (DatmlRawResources.isSurvey(raw)) {
            this.currentSdfCreationRessourceId = null;
            this.currentRessourceKlasse = null;
        } else if (DatmlRawResources.isRessource(raw)) {
            this.currentRessourceKlasse = attributes.getValue("klasse");
        }
    }

    @Override
    public void endElement(String uri, String localName, String raw) throws SAXException {
        if (DatmlRawResources.isMessage(raw)) {
            Iterator<String> iter = this.getCurrentSegmentHelpFeatureNames();
            while (iter != null && iter.hasNext()) {
                this.values.remove(iter.next());
            }
        } else if (DatmlRawResources.isSegment(raw)) {
            Iterator<String> iter = this.getCurrentSegmentHelpFeatureNames();
            while (iter != null && iter.hasNext()) {
                this.values.remove(iter.next());
            }
        } else if (DatmlRawResources.isHelpFeature(raw)) {
            this.currentFeatureName = null;
        } else if (DatmlRawResources.isDeclaration(raw)) {
            MetaSDFAusgabesatz outputDataModel;
            if (this.sdfResolved && (outputDataModel = this.currentSDF.getAusgabesatz()) != null) {
                Iterator iter = outputDataModel.getAusgabegruppen();
                while (iter != null && iter.hasNext()) {
                    MetaSDFAusgabegruppe dataGroup = (MetaSDFAusgabegruppe)iter.next();
                    if (1 != dataGroup.getAttributDaten()) continue;
                    Integer recordsInteger = (Integer)this.recordOccurences.get(dataGroup);
                    int records = recordsInteger != null ? recordsInteger : 0;
                    int minOccurs = SDFUtil.getMinOccurs((String)dataGroup.getMinimaleAnzahl());
                    int maxOccurs = SDFUtil.getMaxOccurs((String)dataGroup.getMaximaleAnzahl());
                    if (minOccurs != -1 && records < minOccurs) {
                        if (maxOccurs != -1 && minOccurs == maxOccurs) {
                            this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_RECORD_OCCURENCES_ERR_NUM, "Es m\u00fcssen genau " + minOccurs + " Datens\u00e4tze geliefert werden.", null, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), 0, dataGroup.getName()));
                        } else {
                            this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_RECORD_OCCURENCES_ERR_NUM, "Es m\u00fcssen mindestens " + minOccurs + " Datens\u00e4tze geliefert werden.", null, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), 0, dataGroup.getName()));
                        }
                    }
                    if (maxOccurs == -1 || records <= maxOccurs) continue;
                    if (minOccurs != -1 && minOccurs == maxOccurs) {
                        this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_RECORD_OCCURENCES_ERR_NUM, "Es m\u00fcssen genau " + maxOccurs + " Datens\u00e4tze geliefert werden.", null, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), 0, dataGroup.getName()));
                        continue;
                    }
                    this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_RECORD_OCCURENCES_ERR_NUM, "Es d\u00fcrfen h\u00f6chstens " + maxOccurs + " Datens\u00e4tze geliefert werden.", null, new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), 0, dataGroup.getName()));
                }
            }
            this.recordOccurences.clear();
        } else if (DatmlRawResources.isRecord(raw)) {
            if (this.sdfResolved) {
                MetaSDFAusgabegruppe dataGroup = SDFStructureHelper.findDataGroup((MetaErhebungsbeschreibung)this.currentSDF, (Map)this.values);
                if (dataGroup != null) {
                    Integer recordsInteger = (Integer)this.recordOccurences.get(dataGroup);
                    int records = recordsInteger != null ? recordsInteger : 0;
                    this.recordOccurences.put(dataGroup, new Integer(records + 1));
                    this.currentFieldDescriptorFactory.setCurrentOutputGroup(dataGroup);
                    Vector<String> wrongFeatureGroups = new Vector<String>();
                    Iterator featuresIter = this.currentRecord.iterator();
                    while (featuresIter != null && featuresIter.hasNext()) {
                        String featureName = (String)featuresIter.next();
                        if (featureName.endsWith("#anzahl")) continue;
                        Iterator iter = wrongFeatureGroups.iterator();
                        while (iter != null && iter.hasNext()) {
                            if (!featureName.startsWith((String)iter.next())) continue;
                        }
                        MetaCustomSDFFeldReferenz featureRef = SDFStructureHelper.findFeature((MetaSDFAusgabegruppe)dataGroup, (String)this.getNameWithoutIndices(featureName));
                        if (featureRef == null) {
                            String featureGroupName;
                            boolean wrongFeatureGroup = false;
                            int lastIndexOf = featureName.lastIndexOf(46);
                            if (lastIndexOf > 0 && SDFStructureHelper.findFeatureGroup((MetaSDFAusgabegruppe)dataGroup, (String)this.getNameWithoutIndices(featureGroupName = featureName.substring(0, lastIndexOf))) == null) {
                                String problemXPath = this.getCurrentXPath() + this.getFeatureGroupXPath(featureGroupName);
                                Location xPathLocation = this.getFeatureGroupLocationForXPath(problemXPath);
                                this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_FEATURE_GROUP_ERR_NUM, WRONG_FEATURE_GROUP_ERR_TEXT, null, new ProblemPosition(xPathLocation == null ? this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.getFeatureGroupName(featureGroupName)));
                                wrongFeatureGroups.add(featureGroupName);
                                wrongFeatureGroup = true;
                            }
                            if (wrongFeatureGroup) continue;
                            String problemXPath = this.getCurrentXPath() + this.getFeatureXPath(featureName);
                            Location xPathLocation = this.getFeatureLocationForXPath(problemXPath);
                            this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_FEATURE_ERR_NUM, WRONG_FEATURE_ERR_TEXT, null, new ProblemPosition(xPathLocation == null ? this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.getFeatureName(featureName)));
                            continue;
                        }
                        String featureNameAbsolute = this.getHierarchy() + featureName;
                        if (this.values.get(featureNameAbsolute) == null) continue;
                        MetaCustomSDFMerkmal currentFeature = (MetaCustomSDFMerkmal)featureRef.getKlasse();
                        this.convertValue(featureNameAbsolute, currentFeature);
                    }
                    dataGroup.accept((ElementVisitorInterface)this.featuresInspection);
                    this.currentFieldDescriptorFactory.setCurrentOutputGroup(null);
                } else {
                    this.errorProblem(4, this.currentSDF.getProzedurCode(), WRONG_RECORD_ERR_NUM, WRONG_RECORD_ERR_TEXT, null);
                }
                Iterator iter = this.currentRecord.iterator();
                while (iter != null && iter.hasNext()) {
                    this.values.remove(iter.next());
                }
                this.currentRecord.clear();
            }
            this.featureLocations = null;
            this.featureValueLocations = null;
            this.featureGroupLocations = null;
        } else if (DatmlRawResources.isFeatureGroup(raw)) {
            if (this.sdfResolved) {
                if (this.ignoreGroupInXPath == null) {
                    this.hierarchy.pop();
                } else if (this.ignoreGroupInXPath.equals(this.getCurrentXPath())) {
                    this.ignoreGroupInXPath = null;
                }
            }
        } else if (DatmlRawResources.isFeature(raw)) {
            if (this.currentFeatureName != null && this.ignoreGroupInXPath == null && this.values.containsKey(this.currentFeatureName)) {
                this.currentRecord.add(this.currentFeatureName);
            }
            this.currentFeatureName = null;
        } else if (DatmlRawResources.isValue(raw)) {
            if (this.currentFeatureName != null && this.ignoreGroupInXPath == null && !this.values.containsKey(this.currentFeatureName)) {
                this.values.put(this.currentFeatureName, this.getTextBuffer());
            }
            if (this.currentFeatureName != null && this.featureValueLocations != null) {
                String xpath = this.getCurrentXPath();
                this.featureValueLocations.put(xpath, new Location(xpath, this.getCurrentLineNumber(), this.getCurrentColumnNumber()));
            }
        } else if (DatmlRawResources.isNoValue(raw)) {
            if (this.currentFeatureName != null && this.ignoreGroupInXPath == null && !this.values.containsKey(this.currentFeatureName)) {
                this.values.put(this.currentFeatureName, null);
            }
        } else if (DatmlRawResources.isRessource(raw)) {
            String ressourceId = this.getTextBufferTrimed();
            if ("SDF-ERZEUGUNG".equals(this.currentRessourceKlasse)) {
                this.currentSdfCreationRessourceId = ressourceId.length() > 0 ? ressourceId : null;
            }
            this.currentRessourceKlasse = null;
        }
        super.endElement(uri, localName, raw);
    }

    private void checkSurveyDefinition() {
        block34: {
            String statisticId = this.getCurrentSurveyId();
            String bzr = this.getCurrentReportingPeriod();
            String collector = this.getCurrentCollector();
            if (statisticId != null && bzr.length() == 6 && collector != null && (this.inspectionController == null || this.inspectionController.dataInspectionIsActive(statisticId, bzr))) {
                int msgId = this.getMessageID();
                int declId = this.getDeclarationID();
                if (this.inspectionController != null && msgId > 0 && declId > 0) {
                    this.getReporter().setTestLevelDataInspection(msgId, declId);
                    boolean dataInspectionWithoutReportRejection = this.inspectionController.dataInspectionWithoutReportRejection(statisticId, bzr);
                    if (dataInspectionWithoutReportRejection) {
                        this.getReporter().setTestLevelDataInspectionWithoutReportRejection(msgId, declId);
                    }
                }
                try {
                    SurveyResource source = this.getConfig().getSurveyResourceProvider().getSurveyResource(statisticId, bzr, collector);
                    if (source == null) {
                        throw new IllegalStateException("SurveyResourceProvider lieferte null fuer [StatistikID: " + statisticId + ", BZR: " + bzr + ", Berichtsempfaenger: " + collector + "].");
                    }
                    String sdfInspectionRessourceId = source.getResourceId();
                    if (msgId > 0 && declId > 0) {
                        this.getReporter().setDataInspectionSDFResourceId(msgId, declId, sdfInspectionRessourceId);
                    }
                    if (this.currentSdfCreationRessourceId != null && !this.currentSdfCreationRessourceId.equals(sdfInspectionRessourceId)) {
                        this.warningProblem(4, "008", CREATION_INSPECTION_DIFF_SDF_RESSOURCE_WARN_TEXT.replaceAll("%1", this.currentSdfCreationRessourceId).replaceAll("%2", sdfInspectionRessourceId));
                    }
                    if (this.currentResourceID == null || !this.currentResourceID.equals(source.getResourceId())) {
                        this.currentSDF = null;
                        this.currentFieldDescriptorFactory = null;
                        this.currentContext = null;
                        this.currentResourceID = source.getResourceId();
                        try {
                            MetaErhebungsbeschreibung sdf = source.getErhebungsbeschreibung();
                            if (source.getResourceId().equals("1" + sdf.getProzedurCode())) {
                                this.currentSDF = sdf;
                                this.currentFieldDescriptorFactory = new SDFFieldDescriptorFactory(sdf);
                                this.currentContext = new InterpreterContext();
                                this.currentContext.setFieldDescriptorFactory((FieldDescriptorFactory)this.currentFieldDescriptorFactory);
                                Iterator iter = this.currentFieldDescriptorFactory.getClassificationGroups();
                                while (iter != null && iter.hasNext()) {
                                    ClassificationGroup classGroup = (ClassificationGroup)iter.next();
                                    this.currentContext.registerClassificationGroup(classGroup.value().asString(), classGroup);
                                }
                                this.sdfResolved = true;
                                this.currentErrNum = null;
                                this.currentErrText = null;
                            } else {
                                this.currentErrNum = "002";
                                this.currentErrText = WRONG_SDF_CONTENT_ERR_TEXT;
                                this.errorProblem(4, this.currentResourceID, "002", WRONG_SDF_CONTENT_ERR_TEXT, null);
                            }
                            break block34;
                        }
                        catch (ResourceException e) {
                            LOG.trace((Object)"Fehler beim Lesen der SDF-Datei", (Throwable)e);
                            this.currentErrNum = "001";
                            this.currentErrText = WRONG_SDF_FORMAT_ERR_TEXT;
                            this.errorProblem(4, this.currentResourceID, "001", WRONG_SDF_FORMAT_ERR_TEXT, null);
                            break block34;
                        }
                        catch (FatalException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.trace((Object)"Fehler im SDF-Format", (Throwable)e);
                            this.currentErrNum = "001";
                            this.currentErrText = WRONG_SDF_FORMAT_ERR_TEXT;
                            this.errorProblem(4, this.currentResourceID, "001", WRONG_SDF_FORMAT_ERR_TEXT, null);
                            break block34;
                        }
                    }
                    if (this.currentSDF != null && this.currentFieldDescriptorFactory != null && this.currentContext != null) {
                        this.currentFieldDescriptorFactory.setCurrentOutputGroup(null);
                        this.currentFieldDescriptorFactory.setCurrentStructure(null, null);
                        this.sdfResolved = true;
                    } else {
                        this.errorProblem(4, this.currentResourceID, this.currentErrNum, this.currentErrText, null);
                    }
                }
                catch (ExtResourceDirNotExistsResourceAccessException e) {
                    this.fatalProblem(4, "001", INVALID_SDF_DIR_FATAL_TEXT);
                }
                catch (NoResourceFoundException e) {
                    switch (e.getReason()) {
                        case 0: {
                            this.warningProblem(4, "001", NO_SDF_WARN_TEXT);
                            break;
                        }
                        case 1: {
                            this.warningProblem(4, "002", NO_SDF_FOR_SURVEY_ID_WARN_TEXT.replaceAll("%1", statisticId));
                            break;
                        }
                        case 2: {
                            String currentReportingPeriodType;
                            switch (bzr.charAt(2)) {
                                case '0': {
                                    currentReportingPeriodType = "Jahr";
                                    break;
                                }
                                case '1': {
                                    currentReportingPeriodType = "Halbjahr";
                                    break;
                                }
                                case '2': {
                                    currentReportingPeriodType = "Semester";
                                    break;
                                }
                                case '3': {
                                    currentReportingPeriodType = "Quartal";
                                    break;
                                }
                                case '4': {
                                    currentReportingPeriodType = "Monat";
                                    break;
                                }
                                case '5': {
                                    currentReportingPeriodType = "Woche";
                                    break;
                                }
                                default: {
                                    currentReportingPeriodType = "Fehlerhaft";
                                }
                            }
                            this.warningProblem(4, "003", NO_SDF_FOR_REPORTING_PERIOD_TYPE_WARN_TEXT.replaceAll("%1", statisticId).replaceAll("%2", currentReportingPeriodType));
                            break;
                        }
                        case 3: {
                            this.warningProblem(4, "004", NO_SDF_FOR_REPORTING_PERIOD_WARN_TEXT.replaceAll("%1", statisticId));
                            break;
                        }
                        case 4: {
                            this.warningProblem(4, "005", NO_SDF_FOR_COLLECTOR_WARN_TEXT.replaceAll("%1", statisticId).replaceAll("%2", collector));
                        }
                    }
                }
            }
        }
    }

    private String getHierarchy() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.hierarchy.size(); ++i) {
            buffer.append(this.hierarchy.get(i));
            buffer.append(".");
        }
        return buffer.toString();
    }

    private String getFeatureGroupXPath(String featureGroupName) {
        StringBuffer buffer = new StringBuffer();
        if (featureGroupName != null && featureGroupName.length() > 0) {
            String[] names = featureGroupName.split("\\.");
            for (int i = 0; i < names.length; ++i) {
                String[] indices;
                String groupName;
                if (names[i].length() <= 0) continue;
                int indexOf = names[i].indexOf(35);
                if (indexOf > 0) {
                    groupName = names[i].substring(0, indexOf);
                    indices = names[i].substring(indexOf + 1).split("#");
                } else {
                    groupName = names[i];
                    indices = new String[]{};
                }
                buffer.append("/mmgr[@name=\"");
                buffer.append(groupName);
                buffer.append("\"]");
                if (indices.length > 0) {
                    for (int j = 0; j < indices.length; ++j) {
                        buffer.append('[');
                        buffer.append(Integer.parseInt(indices[j]) + 1);
                        buffer.append(']');
                    }
                    continue;
                }
                buffer.append("[1]");
            }
        }
        return buffer.toString();
    }

    private String getFeatureXPath(String featureName) {
        StringBuffer buffer = new StringBuffer();
        if (featureName != null && featureName.length() > 0) {
            String[] names = featureName.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String[] indices;
                String groupName;
                if (names[i].length() <= 0) continue;
                int indexOf = names[i].indexOf(35);
                if (indexOf > 0) {
                    groupName = names[i].substring(0, indexOf);
                    indices = names[i].substring(indexOf + 1).split("#");
                } else {
                    groupName = names[i];
                    indices = new String[]{};
                }
                buffer.append("/mmgr[@name=\"");
                buffer.append(groupName);
                buffer.append("\"]");
                if (indices.length > 0) {
                    for (int j = 0; j < indices.length; ++j) {
                        buffer.append('[');
                        buffer.append(Integer.parseInt(indices[j]) + 1);
                        buffer.append(']');
                    }
                    continue;
                }
                buffer.append("[1]");
            }
            buffer.append("/mm[@name=\"");
            buffer.append(names[names.length - 1]);
            buffer.append("\"]");
        }
        return buffer.toString();
    }

    private String getFeatureName(String featureName) {
        if (featureName != null && featureName.indexOf(46) > -1) {
            return featureName.substring(featureName.lastIndexOf(46) + 1);
        }
        return featureName;
    }

    private String getFeatureGroupName(String featureGroupName) {
        if (featureGroupName != null && featureGroupName.indexOf(46) > -1) {
            return featureGroupName.substring(featureGroupName.lastIndexOf(46) + 1, featureGroupName.lastIndexOf(35));
        }
        return featureGroupName.substring(0, featureGroupName.indexOf(35));
    }

    private String getNameWithoutIndices(String name) {
        return name.replaceAll("#[0-9]*", "");
    }

    private void convertValue(String featureNameAbsolute, MetaCustomSDFMerkmal feature) {
        String value = (String)this.values.get(featureNameAbsolute);
        if (value != null) {
            this.values.put(featureNameAbsolute, InspectionHelper.getNormalizedValue(value, feature, this.decimalChar, this.thousendDivChar));
        }
    }

    private Location getFeatureGroupLocationForXPath(String xpath) {
        Location result = null;
        if (this.featureGroupLocations != null) {
            result = (Location)this.featureGroupLocations.get(xpath);
        }
        return result;
    }

    private Location getFeatureLocationForXPath(String xpath) {
        Location result = null;
        if (this.featureLocations != null) {
            result = (Location)this.featureLocations.get(xpath);
        }
        return result;
    }

    private Location getFeatureValueLocationForXPath(String xpath) {
        Location result = null;
        if (this.featureValueLocations != null) {
            result = (Location)this.featureValueLocations.get(xpath);
        }
        return result;
    }

    private class FeaturesInspection
    extends FeaturesVisitor {
        private Stack indices = new Stack();

        private String getHierachyWithIndices() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.getHierachyStack().size(); ++i) {
                buffer.append(((MetaSDFMerkmalsgruppe)this.getHierachyStack().get(i)).getName());
                buffer.append("#");
                buffer.append(this.indices.get(i));
                buffer.append(".");
            }
            return buffer.toString();
        }

        public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
            if (feldReferenz.getKlasse() instanceof MetaSDFMerkmalsgruppe) {
                String problemXPath;
                MetaSDFMerkmalsgruppe group = (MetaSDFMerkmalsgruppe)feldReferenz.getKlasse();
                Integer sizeOfGroup = (Integer)DataInspection.this.values.get(this.getHierachyWithIndices() + group.getName() + "#anzahl");
                boolean finished = false;
                Iterator conditions = this.getDataGroup().getSDFBedingungen();
                while (!finished && conditions != null && conditions.hasNext()) {
                    MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                    if (!SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld()).equals(this.getHierarchy() + group.getName())) continue;
                    if (3 != condition.getBedingungsTyp()) {
                        if (condition.getSpecification() != null) {
                            Location xPathLocation;
                            boolean fulfilled = false;
                            try {
                                fulfilled = DataInspection.this.interpreter.execute(condition.getSpecification(), DataInspection.this.currentContext).asBoolean();
                            }
                            catch (Exception e) {
                                Inspection.LOG.trace((Object)("Fehler in Bedingung " + condition.getName()), (Throwable)e);
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, condition.getBedingung());
                            }
                            if (fulfilled) {
                                if (sizeOfGroup == null || sizeOfGroup == 0) {
                                    problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                                    xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_CONDITIONAL_FEATURE_GROUP_ERR_NUM, DataInspection.NO_CONDITIONAL_FEATURE_GROUP_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                                }
                            } else if (2 == condition.getBedingungsTyp() && sizeOfGroup != null && sizeOfGroup > 0) {
                                problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                                xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath);
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.CONDITIONAL_FEATURE_GROUP_ERR_NUM, DataInspection.CONDITIONAL_FEATURE_GROUP_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                            }
                        } else {
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "003", DataInspection.WRONG_SDF_CONDITION_FORMAT_ERR_TEXT, condition.getBedingung());
                        }
                    }
                    finished = true;
                }
                DataInspection.this.currentFieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                for (int i = 0; !finished && i < this.getHierachyStack().size(); ++i) {
                    DataInspection.this.currentFieldDescriptorFactory.setCurrentStructureLevel(i);
                    MetaSDFMerkmalsgruppe featureGroup = (MetaSDFMerkmalsgruppe)this.getHierachyStack().get(i);
                    conditions = featureGroup.getSDFBedingungen();
                    while (!finished && conditions != null && conditions.hasNext()) {
                        MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                        if (!SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld()).equals(this.getHierarchyFrom(featureGroup) + group.getName())) continue;
                        if (3 != condition.getBedingungsTyp()) {
                            if (condition.getSpecification() != null) {
                                Location xPathLocation;
                                String problemXPath2;
                                boolean fulfilled = false;
                                try {
                                    fulfilled = DataInspection.this.interpreter.execute(condition.getSpecification(), DataInspection.this.currentContext).asBoolean();
                                }
                                catch (Exception e) {
                                    Inspection.LOG.trace((Object)("Fehler in Bedingung " + condition.getName()), (Throwable)e);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, condition.getBedingung());
                                }
                                if (fulfilled) {
                                    if (sizeOfGroup == null || sizeOfGroup == 0) {
                                        problemXPath2 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                                        xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath2);
                                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_CONDITIONAL_FEATURE_GROUP_ERR_NUM, DataInspection.NO_CONDITIONAL_FEATURE_GROUP_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath2, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                                    }
                                } else if (2 == condition.getBedingungsTyp() && sizeOfGroup != null && sizeOfGroup > 0) {
                                    problemXPath2 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                                    xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath2);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.CONDITIONAL_FEATURE_GROUP_ERR_NUM, DataInspection.CONDITIONAL_FEATURE_GROUP_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath2, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                                }
                            } else {
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "003", DataInspection.WRONG_SDF_CONDITION_FORMAT_ERR_TEXT, condition.getBedingung());
                            }
                        }
                        finished = true;
                    }
                }
                if (!(finished || 3 == feldReferenz.getAttributRequired() || sizeOfGroup != null && sizeOfGroup != 0)) {
                    String problemXPath3 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                    Location xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath3);
                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_FEATURE_GROUP_ERR_NUM, DataInspection.NO_FEATURE_GROUP_ERR_TEXT, null, new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath3, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                }
                DataInspection.this.currentFieldDescriptorFactory.setCurrentStructure(null, null);
                if (sizeOfGroup != null && sizeOfGroup > 0) {
                    Location xPathLocation;
                    String indexKind = DataInspection.this.getFeatureGroupIndexKind(group.getName());
                    switch (group.getIndex()) {
                        case 2: {
                            if (indexKind != null && indexKind.equals("NUMERIC")) break;
                            String problemXPath4 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                            Location xPathLocation2 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath4);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_INDEX_ERR_NUM, "Die Merkmalsgruppe muss direkt indiziert werden.", null, new ProblemPosition(xPathLocation2 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation2.getLineNumber(), xPathLocation2 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation2.getColumnNumber(), problemXPath4, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                            break;
                        }
                        case 3: {
                            Location xPathLocation2;
                            if (indexKind == null || !indexKind.equals("FEATURE")) {
                                String problemXPath5 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                                xPathLocation2 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath5);
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_INDEX_ERR_NUM, "Die Merkmalsgruppe muss durch Name indiziert werden.", null, new ProblemPosition(xPathLocation2 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation2.getLineNumber(), xPathLocation2 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation2.getColumnNumber(), problemXPath5, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                                break;
                            }
                            String indexFeature = DataInspection.this.getFeatureGroupIndexFeature(group.getName());
                            if (indexFeature == null || indexFeature.length() <= 0 || indexFeature.equals(group.getIndexVariable())) break;
                            problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                            Location xPathLocation3 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_INDEX_FEATURE_ERR_NUM, DataInspection.WRONG_FEATURE_GROUP_INDEX_FEATURE_ERR_TEXT, null, new ProblemPosition(xPathLocation3 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation3.getLineNumber(), xPathLocation3 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation3.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                            break;
                        }
                        default: {
                            if (indexKind == null || indexKind.equals("NONE")) break;
                            String problemXPath6 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName());
                            Location xPathLocation2 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath6);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_INDEX_ERR_NUM, "Die Merkmalsgruppe muss indirekt indiziert werden.", null, new ProblemPosition(xPathLocation2 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation2.getLineNumber(), xPathLocation2 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation2.getColumnNumber(), problemXPath6, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                        }
                    }
                    int minOccurs = SDFUtil.getMinOccurs((String)feldReferenz.getMinimaleAnzahl());
                    int maxOccurs = SDFUtil.getMaxOccurs((String)feldReferenz.getMaximaleAnzahl());
                    if (minOccurs != -1 && sizeOfGroup < minOccurs) {
                        if (maxOccurs != -1 && minOccurs == maxOccurs) {
                            String problemXPath7 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                            xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath7);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_OCCURENCES_ERR_NUM, "Von der Merkmalsgruppe m\u00fcssen genau " + minOccurs + " Instanzen angegeben werden.", null, new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath7, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                        } else {
                            String problemXPath8 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                            xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath8);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_OCCURENCES_ERR_NUM, "Von der Merkmalsgruppe m\u00fcssen mindestens " + minOccurs + " Instanzen angegeben werden.", null, new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath8, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                        }
                    }
                    if (maxOccurs != -1 && sizeOfGroup > maxOccurs) {
                        if (minOccurs != -1 && minOccurs == maxOccurs) {
                            String problemXPath9 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName() + "#" + maxOccurs);
                            xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath9);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_OCCURENCES_ERR_NUM, "Von der Merkmalsgruppe m\u00fcssen genau " + maxOccurs + " Instanzen angegeben werden.", null, new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath9, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                        } else {
                            String problemXPath10 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices() + group.getName() + "#" + maxOccurs);
                            xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath10);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.WRONG_FEATURE_GROUP_OCCURENCES_ERR_NUM, "Von der Merkmalsgruppe d\u00fcrfen h\u00f6chstens " + maxOccurs + " Instanzen angegeben werden.", null, new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath10, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), group.getName()));
                        }
                    }
                    for (int i = 0; i < sizeOfGroup; ++i) {
                        this.indices.push(new Integer(i));
                        super.visitSDFFeldReferenz(feldReferenz);
                        this.indices.pop();
                    }
                }
            } else {
                Location xPathLocation;
                String problemXPath;
                Location xPathLocation4;
                String problemXPath11;
                MetaCustomSDFMerkmal feature = (MetaCustomSDFMerkmal)feldReferenz.getKlasse();
                boolean conditionFound = false;
                boolean conditionFulfilled = false;
                Iterator conditions = this.getDataGroup().getSDFBedingungen();
                while (!conditionFound && conditions != null && conditions.hasNext()) {
                    MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                    if (!SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld()).equals(this.getHierarchy() + feature.getName())) continue;
                    if (3 != condition.getBedingungsTyp()) {
                        if (condition.getSpecification() != null) {
                            try {
                                conditionFulfilled = DataInspection.this.interpreter.execute(condition.getSpecification(), DataInspection.this.currentContext).asBoolean();
                            }
                            catch (Exception e) {
                                Inspection.LOG.trace((Object)("Fehler in Bedingung " + condition.getName()), (Throwable)e);
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, condition.getBedingung());
                            }
                            if (conditionFulfilled) {
                                if (DataInspection.this.values.get(this.getHierachyWithIndices() + feature.getName()) == null) {
                                    problemXPath11 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                                    xPathLocation4 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath11);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_CONDITIONAL_FEATURE_ERR_NUM, DataInspection.NO_CONDITIONAL_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation4 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation4.getLineNumber(), xPathLocation4 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation4.getColumnNumber(), problemXPath11, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName()));
                                }
                            } else if (2 == condition.getBedingungsTyp() && DataInspection.this.values.get(this.getHierachyWithIndices() + feature.getName()) != null) {
                                problemXPath11 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureXPath(this.getHierachyWithIndices() + feature.getName());
                                xPathLocation4 = DataInspection.this.getFeatureLocationForXPath(problemXPath11);
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.CONDITIONAL_FEATURE_ERR_NUM, DataInspection.CONDITIONAL_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation4 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation4.getLineNumber(), xPathLocation4 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation4.getColumnNumber(), problemXPath11, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName()));
                            }
                        } else {
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "003", DataInspection.WRONG_SDF_CONDITION_FORMAT_ERR_TEXT, condition.getBedingung());
                        }
                    }
                    conditionFound = true;
                }
                DataInspection.this.currentFieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                for (int i = 0; !conditionFound && i < this.getHierachyStack().size(); ++i) {
                    DataInspection.this.currentFieldDescriptorFactory.setCurrentStructureLevel(i);
                    MetaSDFMerkmalsgruppe featureGroup = (MetaSDFMerkmalsgruppe)this.getHierachyStack().get(i);
                    conditions = featureGroup.getSDFBedingungen();
                    while (!conditionFound && conditions != null && conditions.hasNext()) {
                        MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                        if (!SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld()).equals(this.getHierarchyFrom(featureGroup) + feature.getName())) continue;
                        if (3 != condition.getBedingungsTyp()) {
                            if (condition.getSpecification() != null) {
                                try {
                                    conditionFulfilled = DataInspection.this.interpreter.execute(condition.getSpecification(), DataInspection.this.currentContext).asBoolean();
                                }
                                catch (Exception e) {
                                    Inspection.LOG.trace((Object)("Fehler in Bedingung " + condition.getName()), (Throwable)e);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, condition.getBedingung());
                                }
                                if (conditionFulfilled) {
                                    if (DataInspection.this.values.get(this.getHierachyWithIndices() + feature.getName()) == null) {
                                        problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                                        xPathLocation = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath);
                                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_CONDITIONAL_FEATURE_ERR_NUM, DataInspection.NO_CONDITIONAL_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName()));
                                    }
                                } else if (2 == condition.getBedingungsTyp() && DataInspection.this.values.get(this.getHierachyWithIndices() + feature.getName()) != null) {
                                    problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureXPath(this.getHierachyWithIndices() + feature.getName());
                                    xPathLocation = DataInspection.this.getFeatureLocationForXPath(problemXPath);
                                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.CONDITIONAL_FEATURE_ERR_NUM, DataInspection.CONDITIONAL_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName()));
                                }
                            } else {
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "003", DataInspection.WRONG_SDF_CONDITION_FORMAT_ERR_TEXT, condition.getBedingung());
                            }
                        }
                        conditionFound = true;
                    }
                }
                DataInspection.this.currentFieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                String featureNameAbsolute = this.getHierachyWithIndices() + feature.getName();
                if (DataInspection.this.values.get(featureNameAbsolute) == null) {
                    if (!conditionFound && 3 != feldReferenz.getAttributRequired()) {
                        problemXPath11 = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureGroupXPath(this.getHierachyWithIndices());
                        xPathLocation4 = DataInspection.this.getFeatureGroupLocationForXPath(problemXPath11);
                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.NO_FEATURE_ERR_NUM, DataInspection.NO_FEATURE_ERR_TEXT, null, new ProblemPosition(xPathLocation4 == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation4.getLineNumber(), xPathLocation4 == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation4.getColumnNumber(), problemXPath11, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName()));
                    }
                } else {
                    boolean returnValue = true;
                    try {
                        DataInspection.this.currentContext.setCurrentField(DataInspection.this.currentFieldDescriptorFactory.getFieldDescriptor(feature.getName()));
                        returnValue = DataInspection.this.interpreter.execute(feature.getSpecification(), DataInspection.this.currentContext).asBoolean();
                        DataInspection.this.currentContext.setCurrentField(null);
                    }
                    catch (Exception e) {
                        Inspection.LOG.trace((Object)("Fehler in Merkmalspruefung " + feature.getName()), (Throwable)e);
                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, null);
                    }
                    if (!returnValue) {
                        boolean isRequiredFeature = !conditionFound && 3 != feldReferenz.getAttributRequired() || conditionFound && conditionFulfilled;
                        problemXPath = DataInspection.this.getCurrentXPath() + DataInspection.this.getFeatureXPath(featureNameAbsolute) + "/wert";
                        xPathLocation = DataInspection.this.getFeatureValueLocationForXPath(problemXPath);
                        ProblemPosition problemPos = new ProblemPosition(xPathLocation == null ? DataInspection.this.getCurrentLineNumber() : xPathLocation.getLineNumber(), xPathLocation == null ? DataInspection.this.getCurrentColumnNumber() : xPathLocation.getColumnNumber(), problemXPath, DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), feature.getName());
                        if (isRequiredFeature) {
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), DataInspection.INVALID_FEATURE_ERR_NUM, "Der Wert des Merkmals liegt nicht im definierten Wertebereich.", null, problemPos);
                        } else {
                            DataInspection.this.warningProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "007", "Der Wert des Merkmals liegt nicht im definierten Wertebereich.", null, problemPos);
                        }
                    }
                }
                DataInspection.this.currentFieldDescriptorFactory.setCurrentStructure(null, null);
            }
        }
    }

    private class HelpFeatureInspection
    extends HelpFeaturesVisitor {
        private MetaSDFAusgabegruppe dataGroup = null;

        public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
            this.dataGroup = ausgabegruppe;
            super.visitSDFAusgabegruppe(ausgabegruppe);
        }

        public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
            Location helpFeatureLocation;
            MetaCustomSDFMerkmal helpFeature = (MetaCustomSDFMerkmal)feldReferenz.getKlasse();
            boolean conditionFound = false;
            boolean conditionFulfilled = false;
            Iterator iter = this.dataGroup.getSDFBedingungen();
            while (!conditionFound && iter != null && iter.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)iter.next();
                if (!SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld()).equals(helpFeature.getName())) continue;
                if (3 != condition.getBedingungsTyp()) {
                    if (condition.getSpecification() != null) {
                        try {
                            conditionFulfilled = DataInspection.this.interpreter.execute(condition.getSpecification(), DataInspection.this.currentContext).asBoolean();
                        }
                        catch (Exception e) {
                            Inspection.LOG.trace((Object)("Fehler in Bedingung " + condition.getName()), (Throwable)e);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, condition.getBedingung());
                        }
                        if (conditionFulfilled) {
                            if (DataInspection.this.values.get(helpFeature.getName()) == null) {
                                DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "006", DataInspection.NO_CONDITIONAL_HELP_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(DataInspection.this.getCurrentLineNumber(), DataInspection.this.getCurrentColumnNumber(), DataInspection.this.getParentXPath(), DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), helpFeature.getName()));
                            }
                        } else if (2 == condition.getBedingungsTyp() && DataInspection.this.values.get(helpFeature.getName()) != null) {
                            String helpFeatureName = helpFeature.getName();
                            helpFeatureLocation = DataInspection.this.getHelpFeatureLocation(helpFeatureName);
                            DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "007", DataInspection.CONDITIONAL_HELP_FEATURE_ERR_TEXT, condition.getBedingung(), new ProblemPosition(helpFeatureLocation.getLineNumber(), helpFeatureLocation.getColumnNumber(), helpFeatureLocation.getXpath(), DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), helpFeature.getName()));
                        }
                    } else {
                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "003", DataInspection.WRONG_SDF_CONDITION_FORMAT_ERR_TEXT, condition.getBedingung());
                    }
                }
                conditionFound = true;
            }
            if (DataInspection.this.values.get(helpFeature.getName()) == null) {
                if (!conditionFound && 3 != feldReferenz.getAttributRequired()) {
                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "005", DataInspection.NO_HELP_FEATURE_ERR_TEXT, null, new ProblemPosition(DataInspection.this.getCurrentLineNumber(), DataInspection.this.getCurrentColumnNumber(), DataInspection.this.getParentXPath(), DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), helpFeature.getName()));
                }
            } else {
                boolean returnValue = true;
                try {
                    DataInspection.this.currentContext.setCurrentField(DataInspection.this.currentFieldDescriptorFactory.getFieldDescriptor(helpFeature.getName()));
                    returnValue = DataInspection.this.interpreter.execute(helpFeature.getSpecification(), DataInspection.this.currentContext).asBoolean();
                    DataInspection.this.currentContext.setCurrentField(null);
                }
                catch (Exception e) {
                    Inspection.LOG.trace((Object)("Fehler in Hilfsmerkmalspruefung " + helpFeature.getName()), (Throwable)e);
                    DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "001", DataInspection.WRONG_SDF_FORMAT_ERR_TEXT, null);
                }
                if (!returnValue) {
                    boolean isRequiredHelpFeature = !conditionFound && 3 != feldReferenz.getAttributRequired() || conditionFound && conditionFulfilled;
                    helpFeatureLocation = DataInspection.this.getHelpFeatureLocation(helpFeature.getName());
                    ProblemPosition problemPos = new ProblemPosition(helpFeatureLocation.getLineNumber(), helpFeatureLocation.getColumnNumber(), helpFeatureLocation.getXpath() + "/wert", DataInspection.this.getMessageID(), DataInspection.this.getDeclarationID(), DataInspection.this.getRecordNo(), helpFeature.getName());
                    if (isRequiredHelpFeature) {
                        DataInspection.this.errorProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "004", "Der Wert des Hilfsmerkmals liegt nicht im definierten Wertebereich.", null, problemPos);
                    } else {
                        DataInspection.this.warningProblem(4, DataInspection.this.currentSDF.getProzedurCode(), "006", "Der Wert des Hilfsmerkmals liegt nicht im definierten Wertebereich.", null, problemPos);
                    }
                }
            }
        }
    }
}

