/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.IfxJNSException;
import com.informix.jns.LdapSqlhosts;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.util.IfxErrMsg;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSqlhosts {
    final String bGroupOpt = "g";
    final String eGroupOpt = "e";
    final char cmtChar = (char)35;
    String fileName;
    Vector<ServerInfo> srvrVect = new Vector();
    Hashtable<String, ServerInfo> srvrList = new Hashtable();
    Hashtable<String, Vector<ServerInfo>> grpList = new Hashtable();
    private String ClientLocale = null;

    public FileSqlhosts(Properties sqhenv) throws IfxJNSException {
        this.ClientLocale = sqhenv.getProperty("CLIENT_LOCALE");
        String fileName = sqhenv.getProperty("SQLH_FILE");
        InputStreamReader frdr = null;
        try {
            URL url = new URL(fileName);
            frdr = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            try {
                frdr = new FileReader(fileName);
            }
            catch (Exception ex) {
                throw IfxErrMsg.getLocIfxJNSException(-25553, this.ClientLocale);
            }
        }
        catch (Exception e2) {
            throw IfxErrMsg.getLocIfxJNSException(-25553, this.ClientLocale);
        }
        try {
            String sline;
            BufferedReader bfr = new BufferedReader(frdr);
            while ((sline = bfr.readLine()) != null) {
                if (this.isBlank(sline) || this.isComment(sline)) continue;
                ServerInfo srvr = this.parseToSrvrInfo(sline);
                this.srvrVect.addElement(srvr);
                this.srvrList.put(srvr.getSname(), srvr);
            }
            bfr.close();
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxJNSException(-25556, this.ClientLocale);
        }
        this.collectGroups();
    }

    private void collectGroups() {
        int scount = this.srvrVect.size();
        for (int i = 0; i < scount; ++i) {
            ServerInfo srvrC = this.srvrVect.get(i);
            if (!srvrC.isGroupEntry()) continue;
            Vector<ServerInfo> gvect = new Vector<ServerInfo>();
            String gName = srvrC.getSname();
            String eGname = srvrC.getOption("e");
            boolean eGflag = eGname != null;
            for (int j = i + 1; j < scount; ++j) {
                ServerInfo tsrvr = this.srvrVect.get(j);
                String tname = tsrvr.getSname();
                String goptName = tsrvr.getOption("g");
                if (gName.equalsIgnoreCase(goptName)) {
                    gvect.addElement(tsrvr);
                }
                if (eGflag && eGname.equalsIgnoreCase(tname) || !eGflag && !gName.equalsIgnoreCase(goptName)) break;
            }
            this.grpList.put(gName, gvect);
        }
    }

    public ServerInfo getServer(String sname) throws IfxJNSException {
        ServerInfo sinfo = this.srvrList.get(sname);
        if (sinfo != null) {
            return sinfo;
        }
        throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale, sname);
    }

    public ServerGroup getServerGroup(String sname) {
        ArrayList<String> nvect = new ArrayList<String>();
        for (ServerInfo server : this.grpList.get(sname)) {
            nvect.add(server.getSname());
        }
        return new ServerGroup(nvect);
    }

    public ServerGroup listServers() {
        ArrayList<String> tvect = new ArrayList<String>();
        Enumeration<String> tkeys = this.srvrList.keys();
        while (tkeys.hasMoreElements()) {
            tvect.add(tkeys.nextElement());
        }
        return new ServerGroup(tvect);
    }

    void uploadToLdap(LdapSqlhosts sqhctx) throws IfxJNSException {
        try {
            int scount = this.srvrVect.size();
            for (int i = 0; i < scount; ++i) {
                ServerInfo tsrvr = this.srvrVect.get(i);
                sqhctx.addServer(tsrvr);
            }
            Enumeration<String> gkeys = this.grpList.keys();
            while (gkeys.hasMoreElements()) {
                String gname = gkeys.nextElement();
                Vector<ServerInfo> glist = this.grpList.get(gname);
                for (int i = 0; i < glist.size(); ++i) {
                    Properties ldentry = new Properties();
                    ServerInfo tsrvr = glist.get(i);
                    String gMember = tsrvr.getSname();
                    String gEntry = "cn=" + gMember + ",cn=" + gname;
                    ldentry.put("cn", gMember);
                    ldentry.put("desc", "SqlHost Grp entry");
                    sqhctx.addEntry(gEntry, ldentry);
                }
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    private boolean isBlank(String line) {
        String nline = line.trim();
        return nline.length() == 0;
    }

    private boolean isComment(String line) {
        String nline = line.trim();
        return nline.charAt(0) == '#';
    }

    private ServerInfo parseToSrvrInfo(String line) {
        String sname = "";
        String ntype = "";
        String hname = "";
        String pname = "";
        String opts = "";
        StringTokenizer stok = new StringTokenizer(line);
        sname = stok.nextToken();
        ntype = stok.nextToken();
        if (stok.hasMoreElements()) {
            hname = stok.nextToken();
        }
        if (stok.hasMoreElements()) {
            pname = stok.nextToken();
        }
        while (stok.hasMoreElements()) {
            opts = opts + stok.nextToken() + " ";
        }
        ServerInfo sinfo = new ServerInfo(sname, ntype, hname, pname, opts);
        return sinfo;
    }
}

