/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FixedURLWebRequestSource;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import org.w3c.dom.Node;

public class WebImage
extends FixedURLWebRequestSource {
    private Node _node;
    private ParsedHTML _parsedHTML;
    private Scriptable _scriptable;
    private String _src;
    private String _alt;

    WebImage(WebResponse response, ParsedHTML parsedHTML, URL baseURL, Node node, FrameSelector sourceFrame, String defaultTarget, String characterSet) {
        super(response, node, baseURL, NodeUtils.getNodeAttribute(node, "src"), sourceFrame, defaultTarget, characterSet);
        this._node = node;
        this._parsedHTML = parsedHTML;
        this._src = NodeUtils.getNodeAttribute(this._node, "src");
        this._alt = NodeUtils.getNodeAttribute(this._node, "alt");
    }

    public String getName() {
        return NodeUtils.getNodeAttribute(this._node, "name");
    }

    public String getSource() {
        return this._src;
    }

    public String getAltText() {
        return this._alt;
    }

    public WebLink getLink() {
        return this._parsedHTML.getFirstMatchingLink(new HTMLElementPredicate(){

            public boolean matchesCriteria(Object link, Object parentNode) {
                Node parent = (Node)parentNode;
                while (parent != null) {
                    if (parent.equals(((WebLink)link).getNode())) {
                        return true;
                    }
                    parent = parent.getParentNode();
                }
                return false;
            }
        }, this._node.getParentNode());
    }

    public Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
            this._scriptable.setScriptEngine(this.getBaseResponse().getScriptableObject().getDocument().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public ScriptableDelegate getScriptableDelegate() {
        return this.getScriptableObject();
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate {
        public Scriptable() {
            super(WebImage.this);
        }

        public String getName() {
            return WebImage.this.getID().length() != 0 ? WebImage.this.getID() : WebImage.this.getName();
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("src")) {
                return WebImage.this.getSource();
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("src")) {
                if (value != null) {
                    WebImage.this._src = value.toString();
                }
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

