/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BugException;
import freemarker.template.utility.StringUtil;

public final class _CoreStringUtils {
    private _CoreStringUtils() {
    }

    public static String toFTLIdentifierReferenceAfterDot(String name) {
        return _CoreStringUtils.backslashEscapeIdentifier(name);
    }

    public static String toFTLTopLevelIdentifierReference(String name) {
        return _CoreStringUtils.backslashEscapeIdentifier(name);
    }

    public static String toFTLTopLevelTragetIdentifier(String name) {
        int quotationType = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ((i != 0 ? StringUtil.isFTLIdentifierPart(c) : StringUtil.isFTLIdentifierStart(c)) || c == '@') continue;
            if (!(quotationType != 0 && quotationType != 92 || c != '-' && c != '.' && c != ':')) {
                quotationType = 92;
                continue;
            }
            quotationType = 34;
            break;
        }
        switch (quotationType) {
            case 0: {
                return name;
            }
            case 34: {
                return StringUtil.ftlQuote(name);
            }
            case 92: {
                return _CoreStringUtils.backslashEscapeIdentifier(name);
            }
        }
        throw new BugException();
    }

    private static String backslashEscapeIdentifier(String name) {
        return StringUtil.replace(StringUtil.replace(StringUtil.replace(name, "-", "\\-"), ".", "\\."), ":", "\\:");
    }

    public static int getIdentifierNamingConvention(String name) {
        int ln = name.length();
        for (int i = 0; i < ln; ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                return 11;
            }
            if (!_CoreStringUtils.isUpperUSASCII(c)) continue;
            return 12;
        }
        return 10;
    }

    public static String camelCaseToUnderscored(String camelCaseName) {
        int i;
        for (i = 0; i < camelCaseName.length() && Character.isLowerCase(camelCaseName.charAt(i)); ++i) {
        }
        if (i == camelCaseName.length()) {
            return camelCaseName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(camelCaseName.substring(0, i));
        while (i < camelCaseName.length()) {
            char c = camelCaseName.charAt(i);
            if (_CoreStringUtils.isUpperUSASCII(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isUpperUSASCII(char c) {
        return c >= 'A' && c <= 'Z';
    }
}

