/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.util.MessageResources;

public class ErrorsTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private String caption = "Error:";
    private String messagePrefix;
    private String name = "errors";

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setMessagePrefix(String newMessagePrefix) {
        this.messagePrefix = newMessagePrefix;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.messagePrefix = null;
        this.name = "errors";
        this.caption = "Error:";
    }

    public int doStartTag() throws JspException {
        Vector originalErrors = (Vector)this.pageContext.getAttribute(this.getName(), 2);
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (originalErrors != null && originalErrors.size() > 0) {
            Vector errors = this.extractUserDefinedErrors(originalErrors);
            StringBuffer results = new StringBuffer();
            results.append(this.caption);
            results.append("<ul>");
            for (int i = 0; i < errors.size(); ++i) {
                results.append("<li>");
                results.append(MessageResources.getMessage(request, (String)errors.elementAt(i)));
                results.append("</li>");
            }
            results.append("</ul>");
            JspWriter writer = this.pageContext.getOut();
            try {
                writer.print(results.toString());
            }
            catch (IOException e) {
                throw new JspException(e.toString());
            }
        }
        return 1;
    }

    public Vector extractUserDefinedErrors(Vector errors) {
        Vector<String> newErrors = new Vector<String>();
        String message = null;
        int index = 0;
        String delimiter = this.getMessagePrefix();
        if (errors != null) {
            Enumeration e = errors.elements();
            while (e.hasMoreElements()) {
                message = ((Exception)e.nextElement()).getMessage();
                if (delimiter != null && (index = message.indexOf(delimiter)) != -1) {
                    message = message.substring(index + delimiter.length());
                }
                newErrors.add(message);
            }
        }
        return newErrors;
    }
}

