/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.event.NavEventFactory;
import org.dbforms.event.NavEventFactoryImpl;
import org.dbforms.event.NavigationEvent;
import org.dbforms.event.NoopEvent;
import org.dbforms.event.WebEvent;
import org.dbforms.taglib.DbFilterTag;
import org.dbforms.taglib.DbFormContext;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.taglib.TextFormatterUtil;
import org.dbforms.util.MessageResources;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.TimeUtil;
import org.dbforms.util.Util;
import org.dbforms.validation.DbFormsValidatorUtil;

public class DbFormTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$taglib$DbFormTag == null ? (class$org$dbforms$taglib$DbFormTag = DbFormTag.class$("org.dbforms.taglib.DbFormTag")) : class$org$dbforms$taglib$DbFormTag).getName());
    private static NavEventFactory navEventFactory = NavEventFactoryImpl.instance();
    private transient DbFormTag parentForm;
    private transient FieldValues orderFields = null;
    private transient Hashtable childFieldNames = new Hashtable();
    private transient Hashtable fieldNames;
    private transient Hashtable gotoHt = null;
    private transient Hashtable javascriptDistinctFunctions = new Hashtable();
    private transient Hashtable validationFields;
    private Locale locale = null;
    private transient ResultSetVector resultSetVector;
    private String action;
    private String autoUpdate = "false";
    private String autocomplete = null;
    private String captionResource = "false";
    private String childField;
    private String dbConnectionName = null;
    private String filter;
    private String followUp;
    private String followUpOnError;
    private String formValidatorName;
    private String gotoPrefix;
    private String javascriptFieldsArray = "false";
    private String javascriptValidation = "false";
    private String javascriptValidationSrcFile;
    private String localWebEvent;
    private String maxRows;
    private String multipart;
    private String name = null;
    private String onSubmit;
    private String orderBy;
    private String overrideFieldCheck = null;
    private String parentField;
    private String positionPath;
    private String positionPathCore;
    private String readOnly = "false";
    private String redisplayFieldsOnError = "false";
    private String sqlFilter = null;
    private String tableList;
    private String tableName;
    private String target;
    private String whereClause;
    private StringBuffer childElementOutput;
    private transient Table table;
    private Vector overrulingOrderFields;
    private Vector validationForms;
    private transient WebEvent webEvent = null;
    private transient FieldValue[] childFieldValues;
    private boolean footerReached = false;
    private boolean isSubForm = false;
    private int count;
    private int currentCount = 0;
    private int tableId = -1;
    static /* synthetic */ Class class$org$dbforms$taglib$DbFormTag;

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getAction() {
        return this.action;
    }

    public void setAutoUpdate(String autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutocomplete(String string) {
        this.autocomplete = string;
    }

    public String getAutocomplete() {
        return this.autocomplete;
    }

    public void setCaptionResource(String res) {
        this.captionResource = res;
    }

    public void setChildField(String childField) {
        this.childField = childField;
    }

    public String getChildField() {
        return this.childField;
    }

    public int getCount() {
        return this.count;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public void setDbConnectionName(String dbConnectionName) {
        this.dbConnectionName = dbConnectionName;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    public String getFollowUp() {
        return this.followUp;
    }

    public void setFollowUpOnError(String followUpOnError) {
        this.followUpOnError = followUpOnError;
    }

    public String getFollowUpOnError() {
        return this.followUpOnError;
    }

    public void setFooterReached(boolean footerReached) {
        this.footerReached = footerReached;
    }

    public boolean isFooterReached() {
        return this.footerReached;
    }

    public void setFormValidatorName(String fv) {
        this.formValidatorName = fv;
    }

    public String getFormValidatorName() {
        return this.formValidatorName;
    }

    public void setGotoHt(Hashtable gotoHt) {
        this.gotoHt = gotoHt;
    }

    public Hashtable getGotoHt() {
        return this.gotoHt;
    }

    public void setGotoPrefix(String gotoPrefix) {
        this.gotoPrefix = gotoPrefix;
    }

    public String getGotoPrefix() {
        return this.gotoPrefix;
    }

    public void setJavascriptFieldsArray(String jfa) {
        this.javascriptFieldsArray = jfa;
    }

    public void setJavascriptValidation(String jsv) {
        this.javascriptValidation = jsv;
    }

    public void setJavascriptValidationSrcFile(String jsvs) {
        this.javascriptValidationSrcFile = jsvs;
    }

    public String getJavascriptValidationSrcFile() {
        return this.javascriptValidationSrcFile;
    }

    public void setLocalWebEvent(String localWebEvent) {
        this.localWebEvent = localWebEvent;
    }

    public String getLocalWebEvent() {
        return this.localWebEvent;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setMaxRows(String maxRows) {
        this.maxRows = maxRows;
        this.count = maxRows.trim().equals("*") ? 0 : Integer.parseInt(maxRows);
    }

    public String getMaxRows() {
        return this.maxRows;
    }

    public void setMultipart(String value) {
        this.multipart = value;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name != null ? this.name : this.tableName;
    }

    public void setOnSubmit(String newonSubmit) {
        this.onSubmit = newonSubmit;
    }

    public String getOnSubmit() {
        return this.onSubmit;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public FieldValues getOrderFields() {
        return this.orderFields;
    }

    public void setOverrideFieldCheck(String string) {
        this.overrideFieldCheck = string;
    }

    public String getOverrideFieldCheck() {
        return this.overrideFieldCheck;
    }

    public void setParent(Tag p) {
        super.setParent(p);
        this.parentForm = (DbFormTag)DbFormTag.findAncestorWithClass((Tag)this, (Class)(class$org$dbforms$taglib$DbFormTag == null ? (class$org$dbforms$taglib$DbFormTag = DbFormTag.class$("org.dbforms.taglib.DbFormTag")) : class$org$dbforms$taglib$DbFormTag));
    }

    public void setParentField(String parentField) {
        this.parentField = parentField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public String getPositionPath() {
        return this.positionPath;
    }

    public String getPositionPathCore() {
        return this.positionPathCore;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public void setRedisplayFieldsOnError(String newRedisplayFieldsOnError) {
        this.redisplayFieldsOnError = newRedisplayFieldsOnError;
    }

    public ResultSetVector getResultSetVector() {
        return this.resultSetVector;
    }

    public void setSqlFilter(String string) {
        this.sqlFilter = string;
    }

    public String getSqlFilter() {
        return this.sqlFilter;
    }

    public boolean isSubForm() {
        return this.isSubForm;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTableList(String tableList) {
        this.tableList = tableList;
    }

    public String getTableList() {
        return this.tableList;
    }

    public void setTableName(String tableName) throws Exception {
        this.tableName = tableName;
        this.table = this.getConfig().getTableByName(tableName);
        if (this.getTable() == null) {
            throw new Exception("Table " + tableName + " not found in configuration");
        }
        this.tableId = this.getTable().getId();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public WebEvent getWebEvent() {
        return this.webEvent;
    }

    public void setWhereClause(String wc) {
        this.whereClause = wc;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void addChildName(String tableFieldName, String dbFormGeneratedName) {
        this.childFieldNames.put(dbFormGeneratedName, tableFieldName);
    }

    public void addJavascriptFunction(String jsFctName, StringBuffer jsFct) {
        if (!this.existJavascriptFunction(jsFctName)) {
            this.javascriptDistinctFunctions.put(jsFctName, jsFct);
        }
    }

    public void addValidationForm(String formName, Hashtable childFields) {
        if (this.validationForms == null) {
            this.validationForms = new Vector();
        }
        this.validationForms.add(formName);
        if (this.validationFields == null) {
            this.validationFields = new Hashtable();
        }
        this.validationFields.putAll(childFields);
    }

    public void appendToChildElementOutput(String str) {
        if (!Util.isNull(str)) {
            this.childElementOutput.append(str);
        }
    }

    public int doAfterBody() throws JspException {
        if (ResultSetVector.isNull(this.resultSetVector)) {
            this.setFooterReached(true);
            return 0;
        }
        boolean renderPage = !this.isFooterReached();
        ++this.currentCount;
        int pCount = this.getCount();
        logCat.info((Object)("we are talking about=" + this.getTableName() + " pcount=" + pCount + " pcurrent=" + this.currentCount));
        if (this.isSubForm() && !this.isFooterReached()) {
            this.appendToChildElementOutput(this.produceLinkedTags());
        }
        if (pCount != -1 && this.currentCount == pCount || ResultSetVector.isNull(this.getResultSetVector()) || this.getResultSetVector().isLast()) {
            logCat.info((Object)"setting footerreached to true");
            this.setFooterReached(true);
        }
        this.getResultSetVector().moveNext();
        if (renderPage) {
            return 2;
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        logCat.error((Object)("DbFormTag.doCatch called - " + t.toString() + "\n" + sw.toString()));
        throw t;
    }

    public int doEndTag() throws JspException {
        JspWriter jspOut = this.pageContext.getOut();
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
                this.bodyContent.clearBody();
            }
            logCat.debug((Object)("pageContext.getOut()=" + this.pageContext.getOut()));
            logCat.debug((Object)("childElementOutput=" + this.childElementOutput));
            if (this.childElementOutput != null) {
                jspOut.println(this.childElementOutput.toString());
            }
            if (this.parentForm == null) {
                jspOut.println("</form>");
            }
            if (!Util.isNull(this.getFormValidatorName()) && this.hasJavascriptValidationSet()) {
                jspOut.println((Object)this.generateJavascriptValidation());
            }
            if (this.hasJavascriptFieldsArraySet()) {
                jspOut.println((Object)this.generateJavascriptFieldsArray());
            }
            if (this.javascriptDistinctFunctions.size() > 0) {
                jspOut.println("\n<SCRIPT language=\"javascript\">\n");
                Enumeration e = this.javascriptDistinctFunctions.keys();
                while (e.hasMoreElements()) {
                    String aKey = (String)e.nextElement();
                    StringBuffer sbFonction = (StringBuffer)this.javascriptDistinctFunctions.get(aKey);
                    jspOut.println((Object)sbFonction);
                }
                jspOut.println("\n</SCRIPT>\n");
            }
        }
        catch (IOException ioe) {
            logCat.error((Object)"::doEndTag - IOException", (Throwable)ioe);
        }
        logCat.info((Object)("end reached of " + this.tableName));
        return 6;
    }

    public void doFinally() {
        logCat.info((Object)"doFinally called");
        if (this.validationForms != null) {
            this.validationForms.clear();
        }
        if (this.validationFields != null) {
            this.validationFields.clear();
        }
        if (this.fieldNames != null) {
            this.fieldNames.clear();
        }
        if (this.childFieldNames != null) {
            this.childFieldNames.clear();
        }
        this.sqlFilter = null;
        this.orderFields = null;
        this.overrideFieldCheck = null;
    }

    public int doStartTag() {
        try {
            FieldValue[] orderConstraint;
            FieldValue[] overrulingOrder;
            Connection con = this.getConfig().getConnection(this.dbConnectionName);
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            this.locale = MessageResources.getLocale(request);
            logCat.info((Object)("servlet path = " + request.getServletPath()));
            logCat.info((Object)("servlet getPathInfo = " + request.getPathInfo()));
            logCat.info((Object)("servlet getContextPath = " + request.getContextPath()));
            logCat.info((Object)("servlet getRequestURI = " + request.getRequestURI()));
            String strFollowUp = this.getFollowUp();
            if (Util.isNull(strFollowUp)) {
                strFollowUp = request.getRequestURI();
                String contextPath = request.getContextPath();
                if (!Util.isNull(contextPath)) {
                    strFollowUp = strFollowUp.substring(contextPath.length(), strFollowUp.length());
                }
                if (!Util.isNull(request.getQueryString())) {
                    strFollowUp = strFollowUp + "?" + request.getQueryString();
                }
            }
            logCat.debug((Object)"pos1");
            JspWriter out = this.pageContext.getOut();
            logCat.debug((Object)"pos2");
            if (this.getTable() != null && !this.getTable().hasUserPrivileg(request, 0)) {
                logCat.debug((Object)"pos3");
                String str = MessageResourcesInternal.getMessage("dbforms.events.view.nogrant", this.getLocale(), new String[]{this.getTable().getName()});
                logCat.warn((Object)str);
                out.println(str);
                return 0;
            }
            logCat.debug((Object)"pos4");
            DbEventInterceptorData interceptorData = new DbEventInterceptorData(request, this.getConfig(), con, this.getTable());
            interceptorData.setAttribute("connectionName", this.dbConnectionName);
            interceptorData.setAttribute("pageContext", this.pageContext);
            if (this.getTable() != null && this.getTable().hasInterceptors()) {
                try {
                    logCat.debug((Object)"pos5");
                    this.getTable().processInterceptors(6, interceptorData);
                }
                catch (Exception sqle) {
                    logCat.error((Object)"pos6");
                    logCat.error((Object)sqle.getMessage(), (Throwable)sqle);
                    out.println(sqle.getMessage());
                    return 0;
                }
            }
            logCat.debug((Object)"pos7");
            StringBuffer tagBuf = new StringBuffer();
            logCat.info((Object)"resetting values of tag");
            this.currentCount = 0;
            this.footerReached = false;
            this.resultSetVector = null;
            this.childElementOutput = new StringBuffer();
            logCat.debug((Object)"first steps finished");
            if (this.parentForm == null) {
                tagBuf.append("<form ");
                if (!Util.isNull(this.getId())) {
                    tagBuf.append("id=\"");
                    tagBuf.append(this.getId());
                    tagBuf.append("\" ");
                }
                tagBuf.append("name=\"dbform\" action=\"");
                if (this.getAction() != null && this.getAction().trim().length() > 0) {
                    tagBuf.append(this.getAction());
                } else {
                    tagBuf.append(response.encodeURL(request.getContextPath() + "/servlet/control"));
                }
                tagBuf.append("\"");
                if (this.getAutocomplete() != null) {
                    tagBuf.append(" autocomplete=\"" + this.getAutocomplete() + "\"");
                }
                if (this.target != null) {
                    tagBuf.append(" target=\"");
                    tagBuf.append(this.target);
                    tagBuf.append("\"");
                }
                tagBuf.append(" method=\"post\"");
                if (this.hasMultipartSet()) {
                    tagBuf.append(" enctype=\"multipart/form-data\"");
                }
                String validationFct = null;
                if (this.hasJavascriptValidationSet() && !Util.isNull(validationFct = this.getFormValidatorName())) {
                    validationFct = Character.toUpperCase(validationFct.charAt(0)) + validationFct.substring(1, validationFct.length());
                    validationFct = "validate" + validationFct + "(this)";
                }
                if (!Util.isNull(validationFct) && !Util.isNull(this.getOnSubmit())) {
                    int i;
                    boolean found = false;
                    String s = this.getOnSubmit();
                    String[] cmds = StringUtils.split((String)s, (char)';');
                    for (i = 0; i < cmds.length; ++i) {
                        cmds[i] = cmds[i].trim();
                        if (!cmds[i].startsWith("return")) continue;
                        cmds[i] = cmds[i].substring("return".length());
                        cmds[i] = "return " + validationFct + " && " + cmds[i];
                        found = true;
                        break;
                    }
                    s = "";
                    for (i = 0; i < cmds.length; ++i) {
                        s = s + cmds[i] + ";";
                    }
                    if (!found) {
                        s = s + "return " + validationFct + ";";
                    }
                    tagBuf.append(" onSubmit=\"");
                    tagBuf.append(s);
                    tagBuf.append("\" ");
                } else if (!Util.isNull(validationFct)) {
                    tagBuf.append(" onSubmit=\"");
                    tagBuf.append("return " + validationFct);
                    tagBuf.append("\" ");
                } else if (!Util.isNull(this.getOnSubmit())) {
                    tagBuf.append(" onSubmit=\"");
                    tagBuf.append(this.getOnSubmit());
                    tagBuf.append("\" ");
                }
                tagBuf.append(">");
                if (this.tableName == null) {
                    this.appendSource(request, tagBuf);
                    tagBuf.append("<input type=\"hidden\" name=\"fu_" + this.tableId + "\" value=\"" + strFollowUp + "\"/>");
                    out.println(tagBuf.toString());
                    return 2;
                }
                this.positionPathCore = "root";
            } else {
                this.isSubForm = true;
                this.positionPathCore = this.parentForm.getPositionPath();
                if (Util.isNull(this.getWhereClause())) {
                    this.initChildFieldValues();
                    if (this.childFieldValues == null) {
                        return 0;
                    }
                }
            }
            tagBuf.append("<input type=\"hidden\" name=\"invtable\" value=\"" + this.tableId + "\"/>");
            tagBuf.append("<input type='hidden' name='invname_" + this.tableId + "' value='" + (Util.isNull(this.dbConnectionName) ? "" : this.dbConnectionName) + "'/>");
            tagBuf.append("<input type=\"hidden\" name=\"autoupdate_" + this.tableId + "\" value=\"" + this.autoUpdate + "\"/>");
            tagBuf.append("<input type=\"hidden\" name=\"fu_" + this.tableId + "\" value=\"" + strFollowUp + "\"/>");
            tagBuf.append("<input type=\"hidden\" name=\"lang\" value=\"" + this.locale.getLanguage() + "\"/>");
            tagBuf.append("<input type=\"hidden\" name=\"country\" value=\"" + this.locale.getCountry() + "\"/>");
            if (!Util.isNull(this.getFollowUpOnError())) {
                tagBuf.append("<input type=\"hidden\" name=\"fue_" + this.tableId + "\" value=\"" + this.getFollowUpOnError() + "\"/>");
            }
            if (!Util.isNull(this.getOverrideFieldCheck())) {
                tagBuf.append("<input type=\"hidden\" name=\"overridefieldcheck_" + this.tableId + "\" value=\"" + this.getOverrideFieldCheck() + "\"/>");
            }
            if (!Util.isNull(this.getFormValidatorName())) {
                tagBuf.append("<input type=\"hidden\" name=\"formValidatorName_" + this.tableId + "\" value=\"" + this.getFormValidatorName() + "\"/>");
            }
            this.appendSource(request, tagBuf);
            tagBuf.append("<input type=\"hidden\" name=\"customEvent\"/>");
            String sqlFilterString = "";
            String requestSqlFilterString = DbFilterTag.getSqlFilter(request, this.getTable().getId());
            FieldValue[] sqlFilterParams = null;
            if (!Util.isNull(this.getSqlFilter()) && !Util.isNull(requestSqlFilterString)) {
                sqlFilterString = " ( " + requestSqlFilterString + " ) AND ( " + this.getSqlFilter() + " ) ";
            } else if (!Util.isNull(this.getSqlFilter())) {
                sqlFilterString = this.getSqlFilter();
            } else if (!Util.isNull(requestSqlFilterString)) {
                sqlFilterString = requestSqlFilterString;
            }
            logCat.debug((Object)("filter to apply : " + sqlFilterString));
            if (!Util.isNull(requestSqlFilterString)) {
                sqlFilterParams = DbFilterTag.getSqlFilterParams(request, this.getTable().getId());
            }
            if ((overrulingOrder = this.initOverrulingOrder(request)) != null && overrulingOrder.length > 0) {
                orderConstraint = overrulingOrder;
                logCat.info((Object)"using OverrulingOrder (dbform tag attribute)");
            } else {
                FieldValue[] tmpOrderConstraint = this.getTable().getDefaultOrder();
                orderConstraint = new FieldValue[tmpOrderConstraint.length];
                for (int i = 0; i < tmpOrderConstraint.length; ++i) {
                    orderConstraint[i] = (FieldValue)tmpOrderConstraint[i].clone();
                }
                logCat.info((Object)"using DefaultOrder (from config file)");
            }
            if (orderConstraint == null) {
                throw new IllegalArgumentException("OrderBy-Clause must be specified either in table-element in config.xml or in dbform-tag on jsp view");
            }
            FieldValue[] filterFieldValues = null;
            if (!Util.isNull(this.filter)) {
                filterFieldValues = this.getTable().getFilterFieldArray(this.filter, this.locale);
            }
            FieldValue[] mergedFieldValues = null;
            if (this.childFieldValues == null) {
                mergedFieldValues = filterFieldValues;
            } else if (filterFieldValues == null) {
                mergedFieldValues = this.childFieldValues;
            } else {
                mergedFieldValues = new FieldValue[this.childFieldValues.length + filterFieldValues.length];
                System.arraycopy(this.childFieldValues, 0, mergedFieldValues, 0, this.childFieldValues.length);
                System.arraycopy(filterFieldValues, 0, mergedFieldValues, this.childFieldValues.length, filterFieldValues.length);
            }
            FieldValue[] searchFieldValues = this.initSearchFieldValues();
            if (searchFieldValues != null) {
                mergedFieldValues = searchFieldValues;
            }
            String firstPosition = Util.decode(ParseUtil.getParameter(request, "firstpos_" + this.tableId), this.pageContext.getRequest().getCharacterEncoding());
            String lastPosition = Util.decode(ParseUtil.getParameter(request, "lastpos_" + this.tableId), this.pageContext.getRequest().getCharacterEncoding());
            if (firstPosition == null) {
                firstPosition = lastPosition;
            }
            if (lastPosition == null) {
                lastPosition = firstPosition;
            }
            if (this.childFieldValues != null && firstPosition != null && !this.checkLinkage(this.childFieldValues, firstPosition)) {
                firstPosition = null;
                lastPosition = null;
            }
            logCat.info((Object)("firstposition " + firstPosition));
            logCat.info((Object)("lastPosition " + lastPosition));
            this.webEvent = (WebEvent)request.getAttribute("webEvent");
            if (this.webEvent != null) {
                this.webEvent.setRequest(request);
            }
            if ((this.webEvent == null || this.webEvent instanceof NoopEvent) && this.getLocalWebEvent() != null) {
                this.webEvent = navEventFactory.createEvent(this.localWebEvent, request, this.getConfig(), this.getTable());
                if (this.webEvent != null) {
                    request.setAttribute("webEvent", (Object)this.webEvent);
                }
            }
            NavigationEvent navEvent = null;
            if (this.webEvent != null && this.webEvent instanceof NavigationEvent && ((navEvent = (NavigationEvent)this.webEvent).getTable() == null || navEvent.getTable().getId() != this.tableId)) {
                navEvent = null;
            }
            if (navEvent == null) {
                if (!Util.isNull(this.gotoPrefix)) {
                    logCat.info((Object)"\u00a7\u00a7\u00a7\u00a7 NAV GOTO \u00a7\u00a7\u00a7\u00a7");
                    Vector v = ParseUtil.getParametersStartingWith(request, this.gotoPrefix);
                    this.gotoHt = new Hashtable();
                    for (int i = 0; i < v.size(); ++i) {
                        String paramName = (String)v.elementAt(i);
                        String fieldName = paramName.substring(this.gotoPrefix.length());
                        logCat.debug((Object)("fieldName=" + fieldName));
                        String fieldValue = ParseUtil.getParameter(request, paramName);
                        logCat.debug((Object)("fieldValue=" + fieldValue));
                        if (fieldName == null || fieldValue == null) continue;
                        this.gotoHt.put(fieldName, fieldValue);
                    }
                }
                if (this.gotoHt != null && this.gotoHt.size() > 0) {
                    String positionString = this.getTable().getPositionString(this.gotoHt);
                    navEvent = navEventFactory.createGotoEvent(this.getTable(), request, this.getConfig(), positionString);
                }
            }
            if (navEvent == null) {
                Vector errors = (Vector)request.getAttribute("errors");
                if (this.webEvent != null && "insert".equals(this.webEvent.getType()) && errors != null && errors.size() > 0 && this.webEvent.getTable().getId() == this.getTable().getId()) {
                    navEvent = null;
                    this.resultSetVector = null;
                    this.setFooterReached(true);
                } else if (!Util.isNull(this.getWhereClause())) {
                    navEvent = navEventFactory.createGotoEvent(this.getTable(), request, this.getConfig(), this.whereClause, this.getTableList());
                } else {
                    String myPosition;
                    String string = myPosition = this.count == 0 ? null : firstPosition;
                    if (this.webEvent != null && this.webEvent instanceof NoopEvent) {
                        myPosition = null;
                    }
                    navEvent = navEventFactory.createGotoEvent(this.getTable(), request, this.getConfig(), myPosition);
                }
            }
            logCat.info((Object)"\u00a7\u00a7\u00a7 NAV/I \u00a7\u00a7\u00a7");
            if (navEvent != null) {
                logCat.info((Object)("about to process nav event:" + navEvent.getClass().getName()));
                this.resultSetVector = navEvent.processEvent(mergedFieldValues, orderConstraint, sqlFilterString, sqlFilterParams, this.count, firstPosition, lastPosition, interceptorData);
                if (ResultSetVector.isNull(this.resultSetVector)) {
                    this.setFooterReached(true);
                }
                this.orderFields = new FieldValues(orderConstraint);
            }
            if (this.getTable() != null && this.getTable().hasInterceptors()) {
                try {
                    interceptorData.setAttribute("ResultSetVector", this.resultSetVector);
                    this.getTable().processInterceptors(7, interceptorData);
                }
                catch (SQLException sqle) {
                    SqlUtil.logSqlException(sqle);
                    throw sqle;
                }
            }
            if (!ResultSetVector.isNull(this.resultSetVector)) {
                this.resultSetVector.moveFirst();
                firstPosition = this.getTable().getPositionString(this.resultSetVector);
                this.resultSetVector.moveLast();
                lastPosition = this.getTable().getPositionString(this.resultSetVector);
                this.resultSetVector.moveFirst();
            }
            if (!this.footerReached) {
                if (firstPosition != null) {
                    tagBuf.append("<input type=\"hidden\" name=\"firstpos_" + this.tableId + "\" value=\"" + Util.encode(firstPosition, this.pageContext.getRequest().getCharacterEncoding()) + "\"/>");
                }
                if (lastPosition != null) {
                    tagBuf.append("<input type=\"hidden\" name=\"lastpos_" + this.tableId + "\" value=\"" + Util.encode(lastPosition, this.pageContext.getRequest().getCharacterEncoding()) + "\"/>");
                }
            }
            if (!this.isSubForm) {
                this.pageContext.setAttribute("dbforms", new Hashtable());
            }
            Map dbforms = (Map)this.pageContext.getAttribute("dbforms");
            DbFormContext dbContext = new DbFormContext(this.getTable().getNamesHashtable("search_"), this.getTable().getNamesHashtable("searchmode_"), this.getTable().getNamesHashtable("searchalgo_"), this.resultSetVector);
            if (!ResultSetVector.isNull(this.resultSetVector)) {
                dbContext.setCurrentRow(this.resultSetVector.getCurrentRowAsMap());
                dbContext.setPosition(Util.encode(this.getTable().getPositionString(this.resultSetVector), this.pageContext.getRequest().getCharacterEncoding()));
            }
            dbforms.put(this.getName(), dbContext);
            this.pageContext.setAttribute("searchFieldNames_" + this.tableName.replace('.', '_'), (Object)this.getTable().getNamesHashtable("search_"));
            this.pageContext.setAttribute("searchFieldModeNames_" + this.tableName.replace('.', '_'), (Object)this.getTable().getNamesHashtable("searchmode_"));
            this.pageContext.setAttribute("searchFieldAlgorithmNames_" + this.tableName.replace('.', '_'), (Object)this.getTable().getNamesHashtable("searchalgo_"));
            if (!ResultSetVector.isNull(this.resultSetVector)) {
                this.pageContext.setAttribute("rsv_" + this.tableName.replace('.', '_'), (Object)this.resultSetVector);
                this.pageContext.setAttribute("currentRow_" + this.tableName.replace('.', '_'), (Object)this.resultSetVector.getCurrentRowAsMap());
                this.pageContext.setAttribute("position_" + this.tableName.replace('.', '_'), (Object)Util.encode(this.getTable().getPositionString(this.resultSetVector), this.pageContext.getRequest().getCharacterEncoding()));
            }
            out.println(tagBuf.toString());
            SqlUtil.closeConnection(con);
        }
        catch (IOException e) {
            logCat.error((Object)"::doStartTag - IOException", (Throwable)e);
            return 0;
        }
        catch (SQLException ne) {
            SqlUtil.logSqlException(ne);
            return 0;
        }
        return 2;
    }

    public boolean existJavascriptFunction(String jsFctName) {
        return this.javascriptDistinctFunctions.containsKey(jsFctName);
    }

    public boolean hasCaptionResourceSet() {
        return Util.getTrue(this.captionResource);
    }

    public boolean hasJavascriptFieldsArraySet() {
        return Util.getTrue(this.javascriptFieldsArray);
    }

    public boolean hasJavascriptValidationSet() {
        return Util.getTrue(this.javascriptValidation);
    }

    public boolean hasMultipartSet() {
        return Util.getTrue(this.multipart);
    }

    public boolean hasReadOnlySet() {
        return Util.getTrue(this.readOnly);
    }

    public boolean hasRedisplayFieldsOnErrorSet() {
        return Util.getTrue(this.redisplayFieldsOnError);
    }

    public String produceLinkedTags() {
        StringBuffer buf = new StringBuffer();
        if (this.childFieldValues != null) {
            for (int i = 0; i < this.childFieldValues.length; ++i) {
                if (!this.childFieldValues[i].getRenderHiddenHtmlTag()) continue;
                TextFormatterUtil formatter = new TextFormatterUtil(this.childFieldValues[i].getField(), this.getLocale(), null, this.childFieldValues[i].getFieldValueAsObject());
                buf.append("<input type=\"hidden\" name=\"");
                buf.append(formatter.getFormFieldName(this));
                buf.append("\" value=\"");
                buf.append(formatter.getFormattedFieldValue());
                buf.append("\" />");
                buf.append(formatter.renderPatternHtmlInputField());
            }
        }
        return buf.toString();
    }

    public void strikeOut(Field f) {
        if (this.childFieldValues != null) {
            for (int i = 0; i < this.childFieldValues.length; ++i) {
                if (f != this.childFieldValues[i].getField() || !this.childFieldValues[i].getRenderHiddenHtmlTag()) continue;
                this.childFieldValues[i].setRenderHiddenHtmlTag(false);
                logCat.info((Object)("stroke out field:" + f.getName()));
                return;
            }
        }
    }

    public void updatePositionPath() {
        StringBuffer positionPathBuf = new StringBuffer();
        positionPathBuf.append(this.currentCount);
        positionPathBuf.append("@");
        positionPathBuf.append(this.positionPathCore);
        this.positionPath = positionPathBuf.toString();
    }

    private void addFieldNames(Hashtable fields) {
        if (this.fieldNames == null) {
            this.fieldNames = new Hashtable();
        }
        this.fieldNames.putAll(fields);
    }

    private void appendSource(HttpServletRequest request, StringBuffer tagBuf) {
        tagBuf.append("<input type=\"hidden\" name=\"source\" value=\"");
        String reqSource = (String)request.getAttribute("dbforms.source");
        if (reqSource == null) {
            tagBuf.append(request.getRequestURI());
        } else {
            tagBuf.append(reqSource);
        }
        if (request.getQueryString() != null) {
            tagBuf.append("?").append(request.getQueryString());
        }
        tagBuf.append("\"/>");
    }

    private boolean checkLinkage(FieldValue[] achildFieldValues, String aPosition) {
        FieldValues ht = this.getTable().getFieldValues(aPosition);
        for (int i = 0; i < achildFieldValues.length; ++i) {
            String actualValue = achildFieldValues[i].getFieldValue();
            logCat.debug((Object)("actualValue=" + actualValue));
            Field f = achildFieldValues[i].getField();
            logCat.debug((Object)("f.getName=" + f.getName()));
            logCat.debug((Object)("f.getId=" + f.getId()));
            FieldValue aFieldValue = ht.get(f.getName());
            if (aFieldValue == null) {
                throw new IllegalArgumentException("ERROR: Make sure that field " + f.getName() + " is a KEY of the table " + this.getTable().getName() + "! Otherwise you can not use it as PARENT/CHILD LINK argument!");
            }
            String valueInPos = aFieldValue.getFieldValue();
            logCat.info((Object)("comparing " + actualValue + " TO " + valueInPos));
            if (actualValue.trim().equals(valueInPos.trim())) continue;
            return false;
        }
        return true;
    }

    private StringBuffer generateJavascriptFieldsArray() {
        StringBuffer result = new StringBuffer();
        String key = null;
        String val = null;
        String values = "";
        Hashtable<String, String> fields = new Hashtable<String, String>();
        Enumeration e = this.childFieldNames.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            val = (String)this.childFieldNames.get(key);
            values = "";
            if (fields.containsKey(val)) {
                values = (String)fields.get(val);
            }
            fields.put(val, values + ";" + key);
        }
        if (this.isSubForm()) {
            this.parentForm.addFieldNames(fields);
        } else {
            if (this.fieldNames != null) {
                fields.putAll(this.fieldNames);
            }
            result.append("<SCRIPT language=\"javascript\">\n");
            result.append("<!-- \n\n");
            result.append("    var dbFormFields = new Array();\n");
            e = fields.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = (String)fields.get(key);
                result.append("    dbFormFields[\"").append(key).append("\"] = new Array(");
                ArrayList arrValues = this.sortFields(val);
                if (arrValues.size() == 1) {
                    result.append("\"").append((String)arrValues.get(0)).append("\"");
                } else {
                    for (int i = 0; i <= arrValues.size() - 1; ++i) {
                        result.append("\"").append((String)arrValues.get(i)).append("\"");
                        if (i == arrValues.size() - 1) continue;
                        result.append(", ");
                    }
                }
                result.append(");\n");
            }
            result.append("\n    function getDbFormFieldName(name){ \n");
            result.append("      return getDbFormFieldName(name,null); \n");
            result.append("    }\n\n");
            result.append("\n    function getDbFormFieldName(name,pos){ \n");
            result.append("      var result = dbFormFields[name]; \n");
            result.append("      if(pos==null) return result[result.length-1]; \n");
            result.append("      return result[pos]; \n");
            result.append("    }\n");
            result.append("--></SCRIPT> \n");
        }
        return result;
    }

    private StringBuffer generateJavascriptValidation() {
        if (this.isSubForm()) {
            this.parentForm.addValidationForm(this.getFormValidatorName(), this.childFieldNames);
            return new StringBuffer();
        }
        ValidatorResources vr = (ValidatorResources)this.pageContext.getServletContext().getAttribute("Validator");
        DbFormsErrors errors = (DbFormsErrors)this.pageContext.getServletContext().getAttribute("dbformsErrors");
        this.addValidationForm(this.getFormValidatorName(), this.childFieldNames);
        return DbFormsValidatorUtil.getJavascript(this.validationForms, MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest()), this.validationFields, vr, this.getJavascriptValidationSrcFile(), errors);
    }

    private void initChildFieldValues() {
        if (ResultSetVector.isNull(this.parentForm.getResultSetVector())) {
            this.childFieldValues = null;
            return;
        }
        String aPosition = this.parentForm.getTable().getPositionString(this.parentForm.getResultSetVector());
        if (Util.isNull(aPosition)) {
            this.childFieldValues = null;
            return;
        }
        this.childFieldValues = this.getTable().mapChildFieldValues(this.parentForm.getTable(), this.parentField, this.childField, aPosition).toArray();
    }

    private FieldValue[] initOverrulingOrder(HttpServletRequest request) {
        if (request != null) {
            String refSource = request.getRequestURI();
            if (request.getQueryString() != null) {
                refSource = refSource + "?" + request.getQueryString();
            }
            String sourceTag = ParseUtil.getParameter(request, "source");
            logCat.info((Object)("!comparing page " + refSource + " TO " + sourceTag));
        }
        logCat.debug((Object)("orderBy=" + this.orderBy));
        if (this.orderBy == null && request == null) {
            return null;
        }
        FieldValue[] overrulingOrder = this.getTable().createOrderFieldValues(this.orderBy, request, false);
        this.overrulingOrderFields = new Vector();
        if (overrulingOrder != null) {
            for (int i = 0; i < overrulingOrder.length; ++i) {
                this.overrulingOrderFields.addElement(overrulingOrder[i].getField());
            }
        }
        return overrulingOrder;
    }

    private FieldValue[] initSearchFieldValues() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Vector searchFieldNames = ParseUtil.getParametersStartingWith(request, "search_");
        if (searchFieldNames == null || searchFieldNames.size() == 0) {
            return null;
        }
        Vector<FieldValue> mode_and = new Vector<FieldValue>();
        Vector<FieldValue> mode_or = new Vector<FieldValue>();
        for (int i = 0; i < searchFieldNames.size(); ++i) {
            Object obj;
            FieldValue fv;
            String searchFieldName = (String)searchFieldNames.elementAt(i);
            String aSearchFieldPattern = ParseUtil.getParameter(request, "p" + searchFieldName);
            String aSearchFieldValue = ParseUtil.getParameter(request, searchFieldName);
            if (Util.isNull(aSearchFieldValue = aSearchFieldValue.trim())) continue;
            int firstUnderscore = searchFieldName.indexOf(95);
            int secondUnderscore = searchFieldName.indexOf(95, firstUnderscore + 1);
            int ptableId = Integer.parseInt(searchFieldName.substring(firstUnderscore + 1, secondUnderscore));
            int fieldId = Integer.parseInt(searchFieldName.substring(secondUnderscore + 1));
            Table ptable = this.getConfig().getTable(ptableId);
            Field f = ptable.getField(fieldId);
            if (f == null) continue;
            String aSearchMode = ParseUtil.getParameter(request, f.getSearchModeName());
            int mode = "or".equals(aSearchMode) ? 2 : 1;
            String aSearchAlgorithm = ParseUtil.getParameter(request, f.getSearchAlgoName());
            if (ptable.getId() != this.getTable().getId()) {
                Field fTest = f;
                f = this.getTable().getFieldByName(fTest.getName());
                if (f != null) {
                    if (!fTest.getFieldType().equals(f.getFieldType())) {
                        f = null;
                    } else {
                        request.setAttribute(f.getSearchFieldName(), (Object)aSearchFieldValue);
                    }
                }
            }
            if (f == null) continue;
            int algorithm = 0;
            int operator = 0;
            if (!Util.isNull(aSearchAlgorithm)) {
                if (aSearchAlgorithm.startsWith("sharpLT")) {
                    operator = 2;
                } else if (aSearchAlgorithm.startsWith("sharpLE")) {
                    operator = 4;
                } else if (aSearchAlgorithm.startsWith("sharpGT")) {
                    operator = 1;
                } else if (aSearchAlgorithm.startsWith("sharpGE")) {
                    operator = 3;
                } else if (aSearchAlgorithm.startsWith("sharpNE")) {
                    operator = 6;
                } else if (aSearchAlgorithm.startsWith("sharpNULL")) {
                    operator = 7;
                } else if (aSearchAlgorithm.startsWith("sharpNOTNULL")) {
                    operator = 8;
                } else if (aSearchAlgorithm.startsWith("weakStartEnd")) {
                    algorithm = 4;
                    operator = 5;
                } else if (aSearchAlgorithm.startsWith("weakStart")) {
                    algorithm = 2;
                    operator = 5;
                } else if (aSearchAlgorithm.startsWith("weakEnd")) {
                    algorithm = 3;
                    operator = 5;
                } else if (aSearchAlgorithm.startsWith("weak")) {
                    algorithm = 1;
                    operator = 5;
                }
            }
            if (aSearchAlgorithm == null || aSearchAlgorithm.toLowerCase().indexOf("extended") == -1) {
                FieldValue fv2 = FieldValue.createFieldValueForSearching(f, aSearchFieldValue, this.getLocale(), operator, mode, algorithm, false);
                if (!Util.isNull(aSearchFieldPattern)) {
                    fv2.setPattern(aSearchFieldPattern);
                }
                if (mode == 1) {
                    mode_and.addElement(fv2);
                    continue;
                }
                mode_or.addElement(fv2);
                continue;
            }
            if (aSearchFieldValue.indexOf("-") != -1) {
                algorithm = 5;
                StringTokenizer st = new StringTokenizer(" " + aSearchFieldValue + " ", "-");
                int tokenCounter = 0;
                StringBuffer merkeDate = new StringBuffer();
                StringBuffer merkeTime = new StringBuffer();
                while (st.hasMoreTokens()) {
                    aSearchFieldValue = st.nextToken().trim();
                    ++tokenCounter;
                    if (aSearchFieldValue.length() <= 0) continue;
                    switch (tokenCounter) {
                        case 1: {
                            operator = 3;
                            TimeUtil.splitDate(aSearchFieldValue, merkeDate, merkeTime);
                            break;
                        }
                        case 2: {
                            operator = 4;
                            StringBuffer mDate = new StringBuffer();
                            StringBuffer mTime = new StringBuffer();
                            TimeUtil.splitDate(aSearchFieldValue, mDate, mTime);
                            if (mDate.length() == 0) {
                                mDate.append(merkeDate);
                            }
                            mDate.append(" ");
                            mDate.append(mTime);
                            aSearchFieldValue = mDate.toString();
                            break;
                        }
                        default: {
                            operator = -1;
                        }
                    }
                    if (operator == -1) continue;
                    FieldValue fv3 = FieldValue.createFieldValueForSearching(f, aSearchFieldValue, this.getLocale(), operator, mode, algorithm, false);
                    if (!Util.isNull(aSearchFieldPattern)) {
                        fv3.setPattern(aSearchFieldPattern);
                    }
                    if (mode == 1) {
                        mode_and.addElement(fv3);
                        continue;
                    }
                    mode_or.addElement(fv3);
                }
                continue;
            }
            int jump = 0;
            if (aSearchFieldValue.startsWith("<>")) {
                algorithm = 5;
                operator = 6;
                jump = 2;
            } else if (aSearchFieldValue.startsWith("!=")) {
                algorithm = 5;
                operator = 6;
                jump = 2;
            } else if (aSearchFieldValue.startsWith(">=")) {
                algorithm = 5;
                operator = 3;
                jump = 2;
            } else if (aSearchFieldValue.startsWith(">")) {
                algorithm = 5;
                operator = 1;
            } else if (aSearchFieldValue.startsWith("<=")) {
                algorithm = 5;
                operator = 4;
                jump = 2;
            } else if (aSearchFieldValue.startsWith("<")) {
                algorithm = 5;
                operator = 2;
                jump = 1;
            } else if (aSearchFieldValue.startsWith("=")) {
                algorithm = 5;
                operator = 0;
                jump = 1;
            } else if (aSearchFieldValue.startsWith("[NULL]")) {
                algorithm = 5;
                operator = 7;
                jump = 0;
            } else if (aSearchFieldValue.startsWith("[!NULL]")) {
                algorithm = 5;
                operator = 8;
                jump = 0;
            } else if (aSearchFieldValue.startsWith("[EMPTY]")) {
                algorithm = 5;
                operator = 9;
                jump = 0;
            } else if (aSearchFieldValue.startsWith("[!EMPTY]")) {
                algorithm = 5;
                operator = 10;
                jump = 0;
            }
            if (jump > 0) {
                aSearchFieldValue = aSearchFieldValue.substring(jump).trim();
            }
            Vector errors = (Vector)request.getAttribute("errors");
            if (operator == 0 && jump == 0 && f.getType() == 93) {
                Date d;
                operator = 3;
                fv = FieldValue.createFieldValueForSearching(f, aSearchFieldValue, this.getLocale(), operator, mode, algorithm, false);
                if (!Util.isNull(aSearchFieldPattern)) {
                    fv.setPattern(aSearchFieldPattern);
                }
                if ((d = (Date)fv.getFieldValueAsObject()) == null) {
                    errors.add(new Exception(MessageResourcesInternal.getMessage("dbforms.error.filter.invalid.date", this.getLocale())));
                    continue;
                }
                if (mode == 1) {
                    mode_and.addElement(fv);
                } else {
                    mode_or.addElement(fv);
                }
                operator = 4;
                d = TimeUtil.findEndOfDay(d);
                aSearchFieldValue = d.toString();
                fv = FieldValue.createFieldValueForSearching(f, aSearchFieldValue, this.getLocale(), operator, mode, algorithm, false);
                if (!Util.isNull(aSearchFieldPattern)) {
                    fv.setPattern(aSearchFieldPattern);
                }
                if (mode == 1) {
                    mode_and.addElement(fv);
                    continue;
                }
                mode_or.addElement(fv);
                continue;
            }
            fv = FieldValue.createFieldValueForSearching(f, aSearchFieldValue, this.getLocale(), operator, mode, algorithm, false);
            if (!Util.isNull(aSearchFieldPattern)) {
                fv.setPattern(aSearchFieldPattern);
            }
            if ((obj = fv.getFieldValueAsObject()) == null) {
                errors.add(new Exception(MessageResourcesInternal.getMessage("dbforms.error.filter.invalid", this.getLocale())));
                continue;
            }
            if (mode == 1) {
                mode_and.addElement(fv);
                continue;
            }
            mode_or.addElement(fv);
        }
        int andBagSize = mode_and.size();
        int orBagSize = mode_or.size();
        int criteriaFieldCount = andBagSize + orBagSize;
        logCat.info((Object)("criteriaFieldCount=" + criteriaFieldCount));
        if (criteriaFieldCount == 0) {
            return null;
        }
        FieldValue[] fieldValues = new FieldValue[criteriaFieldCount];
        int i = 0;
        for (i = 0; i < andBagSize; ++i) {
            fieldValues[i] = (FieldValue)mode_and.elementAt(i);
        }
        for (int j = 0; j < orBagSize; ++j) {
            fieldValues[j + i] = (FieldValue)mode_or.elementAt(j);
        }
        return fieldValues;
    }

    private ArrayList sortFields(String str) {
        ArrayList<String> arr = new ArrayList<String>();
        String tmp = "";
        String tmp1 = null;
        String tmp2 = null;
        String insroot = null;
        int ident1 = 0;
        int ident2 = 0;
        StringTokenizer token = new StringTokenizer(str, ";");
        while (token.hasMoreTokens()) {
            tmp = token.nextToken();
            if (tmp.indexOf("@root") != -1) {
                arr.add(tmp);
                continue;
            }
            insroot = tmp;
        }
        if (insroot != null) {
            arr.add(insroot);
        }
        if (arr.size() == 1) {
            return arr;
        }
        for (int i = 0; i <= arr.size() - 2; ++i) {
            tmp1 = (String)arr.get(i);
            for (int j = i + 1; j <= arr.size() - 1; ++j) {
                tmp2 = (String)arr.get(j);
                if (tmp1.indexOf("@root") == -1 || tmp2.indexOf("@root") == -1) continue;
                try {
                    ident1 = Integer.parseInt(tmp1.substring(tmp1.indexOf("_", 2) + 1, tmp1.indexOf("@")));
                    ident2 = Integer.parseInt(tmp2.substring(tmp2.indexOf("_", 2) + 1, tmp2.indexOf("@")));
                }
                catch (Exception e) {
                    ident1 = -1;
                    ident2 = -1;
                }
                if (ident2 >= ident1) continue;
                arr.set(i, tmp2);
                arr.set(j, tmp1);
                tmp1 = tmp2;
            }
        }
        return arr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

