/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.taglib.DbFormContext;
import org.dbforms.taglib.DbFormTag;
import org.dbforms.util.Util;

public class DbBodyTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    private String allowNew = "true";

    public void setAllowNew(String allowNew) {
        this.allowNew = allowNew;
    }

    public String getAllowNew() {
        return this.allowNew;
    }

    public int doAfterBody() throws JspException {
        DbFormTag myParent = this.getParentForm();
        try {
            String curKeyString;
            if (myParent.getTable() != null && !Util.isNull(curKeyString = myParent.getTable().getKeyPositionString(myParent.getResultSetVector()))) {
                curKeyString = Util.encode(curKeyString, this.pageContext.getRequest().getCharacterEncoding());
                myParent.appendToChildElementOutput("<input type=\"hidden\" name=\"k_" + myParent.getTable().getId() + "_" + myParent.getPositionPath() + "\" value=\"" + curKeyString + "\"/>");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new JspException(uee.toString());
        }
        if (myParent.isSubForm() && myParent.isFooterReached() && Util.getTrue(this.getAllowNew())) {
            myParent.appendToChildElementOutput(myParent.produceLinkedTags());
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
                this.bodyContent.clearBody();
            }
        }
        catch (IOException e) {
            throw new JspException("IO Error: " + e.getMessage());
        }
        return 6;
    }

    public void doFinally() {
        this.allowNew = "true";
    }

    public int doStartTag() throws JspException {
        DbFormTag myParent = this.getParentForm();
        ResultSetVector rsv = myParent.getResultSetVector();
        if (!ResultSetVector.isNull(rsv) && myParent.isFooterReached() || ResultSetVector.isNull(rsv) && Util.getFalse(this.allowNew)) {
            return 0;
        }
        myParent.updatePositionPath();
        if (!ResultSetVector.isNull(rsv)) {
            DbFormContext dbContext;
            Map dbforms = (Map)this.pageContext.getAttribute("dbforms");
            if (dbforms != null && (dbContext = (DbFormContext)dbforms.get(myParent.getName())) != null) {
                dbContext.setCurrentRow(rsv.getCurrentRowAsMap());
                try {
                    dbContext.setPosition(Util.encode(myParent.getTable().getPositionString(rsv), this.pageContext.getRequest().getCharacterEncoding()));
                }
                catch (Exception e) {
                    throw new JspException(e.getMessage());
                }
            }
            if (!rsv.isLast()) {
                rsv.moveNext();
                this.pageContext.setAttribute("currentRow_" + myParent.getTableName().replace('.', '_'), (Object)rsv.getCurrentRowAsMap());
                try {
                    this.pageContext.setAttribute("position_" + myParent.getTableName().replace('.', '_'), (Object)Util.encode(myParent.getTable().getPositionString(rsv), this.pageContext.getRequest().getCharacterEncoding()));
                }
                catch (Exception e) {
                    throw new JspException(e.getMessage());
                }
                rsv.movePrevious();
            }
        }
        return 2;
    }
}

