/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.dbforms.event.WebEvent;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.Util;

public abstract class DbBaseInputTag
extends DbBaseHandlerTag {
    private String cols = null;
    private String hidden = "false";
    private String maxlength = null;
    private String overrideValue;
    private String rows = null;

    public void setCols(String cols) {
        this.cols = cols;
    }

    public String getCols() {
        return this.cols;
    }

    public void setHidden(String newHidden) {
        this.hidden = newHidden;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public String getMaxlength() {
        return this.maxlength;
    }

    public void setOverrideValue(String newOverrideValue) {
        this.overrideValue = newOverrideValue;
    }

    public String getOverrideValue() {
        return this.overrideValue;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public String getRows() {
        return this.rows;
    }

    public void setSize(String size) {
        this.setCols(size);
    }

    public String getSize() {
        return this.getCols();
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void doFinally() {
        this.cols = null;
        this.maxlength = null;
        this.rows = null;
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        if (this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet()) {
            String onFocus;
            String string = onFocus = this.getOnFocus() != null ? this.getOnFocus() : "";
            if (onFocus.lastIndexOf(";") != onFocus.length() - 1) {
                onFocus = onFocus + ";";
            }
            this.setOnFocus(onFocus + "this.blur();");
        }
        return 2;
    }

    public boolean hasHiddenSet() {
        return Util.getTrue(this.hidden);
    }

    protected String getFormFieldValue() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Vector errors = (Vector)request.getAttribute("errors");
        WebEvent we = this.getParentForm().getWebEvent();
        String res = !(this.getOverrideValue() == null || this.getParentForm().hasRedisplayFieldsOnErrorSet() && errors != null && errors.size() > 0 || we != null && we.getType().equals("navReload")) ? this.getOverrideValue() : super.getFormFieldValue();
        return res;
    }

    protected String prepareKeys() {
        StringBuffer tagBuf = new StringBuffer();
        if (this.getAccessKey() != null) {
            tagBuf.append(" accesskey=\"");
            tagBuf.append(this.getAccessKey());
            tagBuf.append("\"");
        }
        if (this.getTabIndex() != null) {
            tagBuf.append(" tabindex=\"");
            tagBuf.append(this.getTabIndex());
            tagBuf.append("\"");
        }
        return tagBuf.toString();
    }

    protected String prepareName() {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("name=\"");
        tagBuf.append(this.getFormFieldName());
        tagBuf.append("\"");
        return tagBuf.toString();
    }

    protected String prepareSize() {
        StringBuffer tagBuf = new StringBuffer();
        if (this.getMaxlength() != null) {
            tagBuf.append(" maxlength=\"");
            tagBuf.append(this.getMaxlength());
            tagBuf.append("\"");
        }
        if (this.getCols() != null) {
            tagBuf.append(" size=\"");
            tagBuf.append(this.getCols());
            tagBuf.append("\"");
        }
        return tagBuf.toString();
    }

    protected String prepareType() {
        return this.hasHiddenSet() ? "type=\"hidden\" " : "type=\"text\" ";
    }

    protected String prepareValue() {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append(" value=\"");
        tagBuf.append(this.escapeHTML(this.getFormFieldValue()));
        tagBuf.append("\" ");
        return tagBuf.toString();
    }

    protected void writeOutSpecialValues() throws JspException {
        super.writeOutSpecialValues();
        try {
            this.pageContext.getOut().write(this.renderPatternHtmlInputField());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
    }
}

