/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.dbforms.devgui.PropertyNames;

public class ProjectData
implements Serializable,
PropertyNames {
    private static Properties defaultProps = new Properties();
    private File file;
    private Properties props;
    private boolean unsavedChanges = false;

    public ProjectData() {
        this.props = new Properties(defaultProps);
        String dbFormsHomeStr = System.getProperty("DBFORMS_HOME");
        if (dbFormsHomeStr != null) {
            this.setProperty("stylesheetDir", dbFormsHomeStr + System.getProperties().getProperty("file.separator") + "xsl-stylesheets");
        }
        this.unsavedChanges = false;
    }

    public ProjectData(Properties props) {
        this.props = props;
        this.unsavedChanges = false;
        String dbFormsHomeStr = props.getProperty("stylesheetDir");
        if ("".equals(dbFormsHomeStr) && (dbFormsHomeStr = System.getProperty("DBFORMS_HOME")) != null) {
            this.setProperty("stylesheetDir", dbFormsHomeStr + System.getProperties().getProperty("file.separator") + "xsl-stylesheets");
            this.unsavedChanges = true;
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (!oldValue.equals(value)) {
            this.props.setProperty(key, value);
            this.unsavedChanges = true;
            System.out.println("unsaved state look like this:" + this.toString());
        }
    }

    public String getProperty(String prop) {
        return this.props.getProperty(prop, "");
    }

    public boolean isUnsaved() {
        return this.unsavedChanges;
    }

    public static ProjectData loadFromDisc(File f) throws IOException {
        Properties l_props = new Properties(defaultProps);
        l_props.load(new FileInputStream(f));
        ProjectData pd = new ProjectData(l_props);
        pd.setFile(f);
        return pd;
    }

    public void storeToDisc(File f) throws IOException {
        this.props.store(new FileOutputStream(f), "DbForms DevGUI Property File");
        this.file = f;
        this.unsavedChanges = false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> e = this.props.propertyNames();
        boolean first = true;
        while (e.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String aPropsName = (String)e.nextElement();
            buf.append(aPropsName);
            buf.append("=");
            buf.append(this.getProperty(aPropsName));
        }
        return buf.toString();
    }

    static {
        defaultProps.setProperty("includeSchemaName", "false");
        defaultProps.setProperty("includeCatalogName", "false");
        defaultProps.setProperty("autoCommitMode", "true");
        defaultProps.setProperty("catalogSelection", "all");
        defaultProps.setProperty("schemaSelection", "all");
        defaultProps.setProperty("tableSelection", "all");
        defaultProps.setProperty("examineTables", "true");
        defaultProps.setProperty("examineViews", "true");
        defaultProps.setProperty("examineSysTabs", "false");
        defaultProps.setProperty("writeStdTypeNames", "false");
        defaultProps.setProperty("foreignKeyDetection", "useGetImportedKeys");
    }
}

