/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.util.FileHolder;
import org.dbforms.util.IEscaper;

public class JDBCDataHelper {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$config$JDBCDataHelper == null ? (class$org$dbforms$config$JDBCDataHelper = JDBCDataHelper.class$("org.dbforms.config.JDBCDataHelper")) : class$org$dbforms$config$JDBCDataHelper).getName());
    static /* synthetic */ Class class$org$dbforms$config$JDBCDataHelper;

    public static Object getData(ResultSet rs, IEscaper escaper, int col) throws SQLException {
        Object res = null;
        switch (rs.getMetaData().getColumnType(col)) {
            case 2005: {
                Clob tmpObj = (Clob)rs.getObject(col);
                String s = tmpObj != null ? tmpObj.getSubString(1L, (int)tmpObj.length()) : null;
                res = escaper == null ? s : escaper.unescapeJDBC(s);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String s = rs.getString(col);
                res = escaper == null ? s : escaper.unescapeJDBC(s);
                break;
            }
            default: {
                Object tmpObj;
                res = tmpObj = rs.getObject(col);
                break;
            }
        }
        return res;
    }

    public static void fillWithData(PreparedStatement ps, IEscaper escaper, int col, Object value, int fieldType, int blobStrategy) throws SQLException {
        logCat.debug((Object)("fillPreparedStatement( ps, " + col + ", " + value + ", " + fieldType + ")..."));
        switch (fieldType) {
            case 0: {
                throw new SQLException("illegal type!");
            }
            case 2004: {
                if (value == null) {
                    ps.setNull(col, 2004);
                    break;
                }
                if (blobStrategy == 1) {
                    FileHolder fileHolder = (FileHolder)value;
                    try {
                        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(byteOut);
                        out.writeObject(fileHolder);
                        out.flush();
                        byte[] buf = byteOut.toByteArray();
                        byteOut.close();
                        out.close();
                        ByteArrayInputStream bytein = new ByteArrayInputStream(buf);
                        int byteLength = buf.length;
                        ps.setBinaryStream(col, (InputStream)bytein, byteLength);
                        break;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        logCat.info((Object)ioe.toString());
                        throw new SQLException("error storing BLOB in database (BLOB_CLASSIC MODE) - " + ioe.toString(), null, 2);
                    }
                }
                if (value instanceof FileHolder) {
                    try {
                        FileHolder fileHolder = (FileHolder)value;
                        ps.setBinaryStream(col, fileHolder.getInputStreamFromBuffer(), fileHolder.getFileLength());
                        break;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        logCat.info((Object)ioe.toString());
                        throw new SQLException("error storing BLOB in database (BLOB_CLASSIC MODE) - " + ioe.toString(), null, 2);
                    }
                }
                byte[] data = ((String)value).getBytes();
                ps.setBinaryStream(col, (InputStream)new ByteArrayInputStream(data), data.length);
                break;
            }
            case 4200: {
                ps.setObject(col, escaper == null ? value : escaper.escapeJDBC((String)value), 1);
                break;
            }
            case 1: {
                ps.setObject(col, escaper == null ? value : escaper.escapeJDBC((String)value), 1);
                break;
            }
            default: {
                ps.setObject(col, value, fieldType);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

