/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.editor.MappingEditor;
import de.destatis.core.map.editor.util.HtmlPreviewCreator;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MappingHtmlPreviewCreator
extends HtmlPreviewCreator {
    private Mapping mapping;

    public MappingHtmlPreviewCreator(Writer writer, Mapping mapping) {
        super(writer);
        this.mapping = mapping;
    }

    @Override
    public void run() {
        try {
            this.createHtml();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createHtml() throws IOException {
        this.writer.write("<html><body style=\"font-family:Arial; font-size:11pt; padding: 5px;\">");
        ArrayList<Binding> helpFeatures = new ArrayList<Binding>();
        int maxHelpFeaturesPos = -1;
        ArrayList<Binding> selectors = new ArrayList<Binding>();
        int maxSelectorsPos = -1;
        Iterator it = this.mapping.getBindings();
        while (it.hasNext()) {
            Integer position;
            Binding binding = (Binding)it.next();
            if (binding instanceof HelpFeatureBinding) {
                position = ((HelpFeatureBinding)binding).getPosition();
                if (position == null || position <= 0) continue;
                helpFeatures.add(binding);
                if (position <= maxHelpFeaturesPos) continue;
                maxHelpFeaturesPos = position;
                continue;
            }
            if (!(binding instanceof SelectorBinding) || (position = ((SelectorBinding)binding).getPosition()) == null || position <= 0) continue;
            selectors.add(binding);
            if (position <= maxSelectorsPos) continue;
            maxSelectorsPos = position;
        }
        HelpFeatureConfigValue helpFeatureConfig = this.mapping.getHelpFeatureConfig();
        if (helpFeatureConfig.isSeparateRow()) {
            this.writeHelpFeatures(helpFeatures, maxHelpFeaturesPos);
        }
        it = this.mapping.getBindings();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            if (!(binding instanceof FieldSetBinding)) continue;
            FieldSetBinding fieldSetBinding = (FieldSetBinding)binding;
            this.writer.write("<p style=\"padding: 5px;\">");
            this.writer.write("Satz <b>" + MappingEditor.cvrtHtml(fieldSetBinding.getId()) + "</b>");
            this.writer.write("</p>");
            this.writer.write("<table cellpadding=\"5px\" cellspacing=\"0\" border=\"0\"><tr>");
            Object[] record = this.createSatzRecord(fieldSetBinding, helpFeatures, maxHelpFeaturesPos, selectors, maxSelectorsPos);
            if (record != null) {
                this.writeHtmlTableColumns(this.writer, record, "#f0f0f0", "#e0e0e0");
            }
            this.writer.write("</tr>");
            this.writer.write("</table>");
        }
        this.writer.write("</body></html>");
    }

    private void writeHelpFeatures(List helpFeatures, int maxHelpFeaturesPos) throws IOException {
        this.writer.write("<p style=\"padding: 5px;\">");
        this.writer.write("Hilfsmerkmale");
        this.writer.write("</p>");
        this.writer.write("<table cellpadding=\"5px\" cellspacing=\"0\" border=\"0\"><tr>");
        if (helpFeatures.size() > 0) {
            Object[] record = new Object[maxHelpFeaturesPos];
            this.fillForFieldBindings(record, helpFeatures);
            this.writeHtmlTableColumns(this.writer, record, "#f0f0f0", "#e0e0e0");
        }
        this.writer.write("</tr>");
        this.writer.write("</table>");
    }

    protected Object[] createSatzRecord(FieldSetBinding fieldSetBinding, List helpFeatures, int maxHelpFeaturesPos, List selectors, int maxSelectorsPos) {
        HelpFeatureConfigValue helpFeatureConfig;
        int maxPos = -1;
        Integer lastSatzPos = BindingHelper.getLastCalculatedCsvPosition(fieldSetBinding);
        if (lastSatzPos != null) {
            maxPos = lastSatzPos;
        }
        if ((helpFeatureConfig = this.mapping.getHelpFeatureConfig()).isEachRecord() && helpFeatures.size() > 0 && maxHelpFeaturesPos > maxPos) {
            maxPos = maxHelpFeaturesPos;
        }
        if (selectors.size() > 0 && maxSelectorsPos > maxPos) {
            maxPos = maxHelpFeaturesPos;
        }
        Object[] record = null;
        if (maxPos > 0) {
            record = new Object[maxPos];
            if (helpFeatureConfig.isEachRecord() && helpFeatures.size() > 0) {
                this.fillForFieldBindings(record, helpFeatures);
            }
            if (selectors.size() > 0) {
                this.fillForFieldBindings(record, selectors);
            }
            if (lastSatzPos != null) {
                this.fillForFieldSet(record, fieldSetBinding);
            }
        }
        return record;
    }
}

