/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html.source.java;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.reporters.html.source.PlaintextHtmlSourceRenderer;
import com.atlassian.clover.reporters.html.source.java.JavaSourceListener;
import com.atlassian.clover.spi.reporters.html.source.HtmlRenderingSupport;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHtmlSourceRenderer
extends PlaintextHtmlSourceRenderer
implements JavaSourceListener {
    protected static final String CLOSE_SPAN = "</span>";
    protected static final String OPEN_KEYWORD = "<span class=\"keyword\">";
    protected static final String CLOSE_KEYWORD = "</span>";
    protected static final String OPEN_STRING = "<span class=\"string\">";
    protected static final String CLOSE_STRING = "</span>";
    protected static final String OPEN_JDOCTAG = "<span class=\"javadoc\">";
    protected static final String CLOSE_JDOCTAG = "</span>";
    protected static final String OPEN_COMMENT = "<span class=\"comment\">";
    protected static final String CLOSE_COMMENT = "</span>";
    private final FullProjectInfo projectInfo;
    private final FullPackageInfo packageInfo;
    private final Set<FullPackageInfo> pkgsInScope = new HashSet<FullPackageInfo>();
    private final Map<String, ClassInfo> classesInScope = new HashMap<String, ClassInfo>();

    public JavaHtmlSourceRenderer(FullFileInfo fileInfo, List<LineRenderInfo> lineInfo, HtmlRenderingSupport renderingHelper, String emptyCoverageMsg, String tab, String space) {
        super(lineInfo, renderingHelper, emptyCoverageMsg, tab, space);
        this.packageInfo = (FullPackageInfo)fileInfo.getContainingPackage();
        this.projectInfo = (FullProjectInfo)this.packageInfo.getContainingProject();
    }

    @Override
    public void onImport(String imp) {
        if (imp.endsWith("*")) {
            String pkg = imp.substring(0, imp.lastIndexOf(46));
            FullPackageInfo pkgInfo = (FullPackageInfo)this.projectInfo.getNamedPackage(pkg);
            if (pkgInfo != null) {
                this.pkgsInScope.add(pkgInfo);
            }
        } else {
            ClassInfo cInfo = this.projectInfo.findClass(imp);
            if (cInfo != null) {
                this.classesInScope.put(cInfo.getName(), cInfo);
            }
        }
    }

    private ClassInfo searchInScope(String ident) {
        ClassInfo cInfo = this.classesInScope.get(ident);
        if (cInfo == null && (cInfo = this.projectInfo.findClass(this.packageInfo.getName() + "." + ident)) == null) {
            for (FullPackageInfo pkgInfo : this.pkgsInScope) {
                cInfo = this.projectInfo.findClass(pkgInfo.getName() + "." + ident);
                if (cInfo == null) continue;
                this.classesInScope.put(ident, cInfo);
            }
        }
        return cInfo;
    }

    @Override
    public void onStringLiteral(String s) {
        this.out.append(OPEN_STRING);
        this.out.append(this.renderingHelper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    @Override
    public void onKeyword(String s) {
        this.out.append(OPEN_KEYWORD);
        this.out.append(s);
        this.out.append("</span>");
    }

    @Override
    public void onCommentChunk(String s) {
        this.out.append(OPEN_COMMENT);
        this.out.append(this.renderingHelper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    @Override
    public void onJavadocTag(String s) {
        this.out.append(OPEN_JDOCTAG);
        this.out.append(s);
        this.out.append("</span>");
    }

    @Override
    public void onPackageSegment(String packageName, String seg) {
        if (this.projectInfo.getNamedPackage(packageName) != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getPackageRelPath(packageName, this.packageInfo.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            this.out.append(seg);
        }
    }

    @Override
    public void onImportSegment(String accum, String seg) {
        if (this.projectInfo.getNamedPackage(accum) != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getPackageRelPath(accum, this.packageInfo.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            ClassInfo clazz = this.projectInfo.findClass(accum);
            if (clazz != null) {
                this.out.append("<a href=\"").append(this.renderingHelper.getRootRelPath(this.packageInfo.getName())).append(this.renderingHelper.getSrcFileLink(true, clazz)).append("\">");
                this.out.append(seg);
                this.out.append("</a>");
            } else {
                this.out.append(seg);
            }
        }
    }

    @Override
    public void onIdentifier(String id) {
        ClassInfo cInfo = this.searchInScope(id);
        if (cInfo != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getRootRelPath(this.packageInfo.getName())).append(this.renderingHelper.getSrcFileLink(true, cInfo)).append("\">");
            this.out.append(id);
            this.out.append("</a>");
        } else {
            this.out.append(id);
        }
    }
}

