/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.CoverageData;
import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.InMemPerTestCoverage;
import com.atlassian.clover.recorder.PerTestCoverage;
import com.atlassian.clover.registry.CorruptedRegistryException;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.BufferUtils;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;

public class CoverageSegment {
    public static final long NONE_IDX = -1L;
    private final LazyProxy<int[]> hitCounts;
    private final LazyProxy<InMemPerTestCoverage> perTestCoverage;

    public CoverageSegment(CoverageData coverageData) {
        this.hitCounts = new LazyProxy.Preloaded<int[]>(coverageData.getHitCounts());
        this.perTestCoverage = new LazyProxy.Preloaded<InMemPerTestCoverage>((InMemPerTestCoverage)coverageData.getPerTestCoverage());
    }

    public CoverageSegment(FileChannel channel) throws IOException {
        long endOfSegment = channel.position();
        final Footer footer = Footer.load(channel, endOfSegment);
        this.hitCounts = new LazyLoader<int[]>(channel, endOfSegment - 20L - footer.perTestCovByteLen - footer.covByteLen + 1L){

            @Override
            protected int[] getImpl(FileChannel channel) throws IOException, RegistryFormatException, RegistryFormatException {
                return CoverageSegment.this.loadHitCounts(channel, footer.covByteLen);
            }
        };
        this.perTestCoverage = new LazyLoader<InMemPerTestCoverage>(channel, endOfSegment - 20L - footer.perTestCovByteLen + 1L){

            @Override
            protected InMemPerTestCoverage getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return CoverageSegment.this.loadPerTestCoverage(channel);
            }
        };
    }

    public int[] getHitCounts() {
        return this.hitCounts.get();
    }

    public PerTestCoverage getPerTestCoverage() {
        return this.perTestCoverage.get();
    }

    private InMemPerTestCoverage loadPerTestCoverage(FileChannel channel) throws IOException {
        ObjectInputStream miis = new ObjectInputStream(new BufferedInputStream(Channels.newInputStream(channel)));
        try {
            return (InMemPerTestCoverage)miis.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException exception = new IOException("Failed to read PerTestCoverage from stream");
            exception.initCause(e);
            throw exception;
        }
    }

    private int[] loadHitCounts(FileChannel channel, long covByteLen) throws IOException, RegistryFormatException {
        if (covByteLen % 4L != 0L) {
            throw new CorruptedRegistryException("Cannot load coverage segment: hit byte count should be a multiple of four: " + covByteLen);
        }
        if (covByteLen / 4L > Integer.MAX_VALUE) {
            throw new CorruptedRegistryException("Cannot load coverage segment: the data will not fit in an int[]. Length in bytes: " + covByteLen);
        }
        int[] hitCounts = new int[(int)(covByteLen / 4L)];
        int hitCountBufferSize = (int)Math.min(Integer.MAX_VALUE, covByteLen);
        ByteBuffer hitCountsBuffer = ByteBuffer.allocate(hitCountBufferSize);
        for (long curByteCount = 0L; curByteCount < covByteLen; curByteCount += Integer.MAX_VALUE) {
            int bytesToRead = Math.min(hitCountBufferSize, (int)(covByteLen - curByteCount));
            hitCountsBuffer.limit(bytesToRead);
            BufferUtils.readFully(channel, hitCountsBuffer);
            hitCountsBuffer.asIntBuffer().get(hitCounts, (int)(curByteCount / 4L), bytesToRead / 4);
            hitCountsBuffer.clear();
        }
        return hitCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileChannel channel) throws IOException {
        long startPos = channel.position();
        int[] hitCountsVal = this.hitCounts.get();
        int hitCountByteBufferSize = (int)Math.min(Integer.MAX_VALUE, (long)hitCountsVal.length * 4L);
        ByteBuffer hitCountByteBuffer = ByteBuffer.allocate(hitCountByteBufferSize);
        IntBuffer hitCountIntBuffer = hitCountByteBuffer.asIntBuffer();
        for (int curHitCountIdx = 0; curHitCountIdx < hitCountsVal.length; curHitCountIdx += 0x1FFFFFFF) {
            int intsToWrite = Math.min(0x1FFFFFFF, hitCountsVal.length - curHitCountIdx);
            hitCountIntBuffer.limit(intsToWrite);
            hitCountIntBuffer.put(hitCountsVal, curHitCountIdx, intsToWrite);
            BufferUtils.writeFully(channel, hitCountByteBuffer);
            hitCountIntBuffer.clear();
        }
        long afterCovPos = channel.position();
        ObjectOutputStream oos = new ObjectOutputStream(Channels.newOutputStream(channel));
        try {
            oos.writeObject(this.perTestCoverage.get());
        }
        finally {
            oos.flush();
        }
        long afterPerTestCovPos = channel.position();
        new Footer(afterCovPos - startPos, afterPerTestCovPos - afterCovPos).write(channel);
    }

    private static class Footer {
        public static final int SIZE = 20;
        public static final int MARKER = 740096;
        public final long covByteLen;
        public final long perTestCovByteLen;

        public Footer(long covByteLen, long perTestCovByteLen) {
            this.covByteLen = covByteLen;
            this.perTestCovByteLen = perTestCovByteLen;
        }

        public void write(FileChannel channel) throws IOException {
            ByteBuffer headerBuffer = ByteBuffer.allocate(20);
            headerBuffer.putLong(this.covByteLen);
            headerBuffer.putLong(this.perTestCovByteLen);
            headerBuffer.putInt(740096);
            headerBuffer.flip();
            BufferUtils.writeFully(channel, headerBuffer);
            Logger.getInstance().debug("Wrote coverage segment: " + this.toString());
        }

        public static Footer load(FileChannel channel, long endOfSegment) throws IOException {
            channel.position(endOfSegment - 20L + 1L);
            ByteBuffer footerBuffer = BufferUtils.readFully(channel, ByteBuffer.allocate(20));
            Footer footer = new Footer(footerBuffer.getLong(), footerBuffer.getLong());
            if (footerBuffer.getInt() != 740096) {
                throw new IOException("CoverageSegment did not start with marker 0x" + Integer.toHexString(740096));
            }
            return footer;
        }
    }
}

