/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.antlr.RecognitionException;
import clover.antlr.TokenStreamException;
import clover.antlr.TokenStreamRecognitionException;
import com.atlassian.clover.CloverLicenseInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.instr.java.CharSequenceInstrumentationSource;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.CloverTokenStreamFilter;
import com.atlassian.clover.instr.java.ContextTreeNode;
import com.atlassian.clover.instr.java.FileInstrumentationSource;
import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.instr.java.InstrumentationSource;
import com.atlassian.clover.instr.java.JavaLexer;
import com.atlassian.clover.instr.java.JavaRecognizer;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.util.ChecksummingReader;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.Formatting;
import com.atlassian.clover.util.UnicodeDecodingReader;
import com.atlassian.clover.util.UnicodeEncodingWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Instrumenter {
    private final JavaInstrumentationConfig config;
    private final Set<String> disallowedPackages = new HashSet<String>();
    private final Logger log;
    private Clover2Registry registry;
    private InstrumentationSession session;
    private ContextTreeNode contextTreeRoot;
    private int numFiles;
    private int numClasses;
    private Set packages;
    private int numMethods;
    private int numTestMethods;
    private int loc;
    private int ncloc;

    public Instrumenter(JavaInstrumentationConfig config) {
        this(Logger.getInstance(), config);
    }

    public Instrumenter(Logger log, JavaInstrumentationConfig config) {
        this.log = log;
        this.config = config;
    }

    public JavaInstrumentationConfig getConfig() {
        return this.config;
    }

    public void startInstrumentation() throws CloverException {
        try {
            Clover2Registry clover2Registry = Clover2Registry.createOrLoad(this.config.getRegistryFile(), this.config.getProjectName());
            if (clover2Registry == null) {
                throw new CloverException("Unable to create or load clover registry located at: " + this.config.getRegistryFile());
            }
            this.startInstrumentation(clover2Registry);
        }
        catch (IOException e) {
            throw new CloverException(e);
        }
    }

    public void startInstrumentation(Clover2Registry reg) throws CloverException {
        this.resetStatistics();
        this.registry = reg;
        this.session = this.registry.startInstr(this.config.getEncoding());
        this.contextTreeRoot = new ContextTreeNode(reg.getContextStore().size(), new ContextSet());
        this.log.info("Processing files at " + this.config.getSourceLevel() + " source level.");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File instrument(@NotNull File srcFile, @NotNull File destRoot, @Nullable String fileEncoding) throws CloverException {
        File file;
        if (this.registry == null) {
            throw new IllegalStateException("Instrumenter not initialized.");
        }
        File instrTmp = null;
        OutputStreamWriter out = null;
        try {
            instrTmp = File.createTempFile("clover", ".java");
            String currentFileEncoding = fileEncoding != null ? fileEncoding : this.config.getEncoding();
            out = currentFileEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(instrTmp), currentFileEncoding) : new FileWriter(instrTmp);
            FileInstrumentationSource fileSource = new FileInstrumentationSource(srcFile, currentFileEncoding);
            FileStructureInfo structInfo = this.instrument(fileSource, out, currentFileEncoding);
            File destDir = destRoot;
            String pkgName = structInfo.getPackageName();
            if (!FullPackageInfo.isDefaultName(pkgName)) {
                destDir = new File(destRoot, CloverUtils.packageNameToPath(pkgName, false));
            }
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                throw new CloverException("Failed to create destination path " + destDir);
            }
            String srcFileName = srcFile.getName();
            if (srcFileName.indexOf(46) > -1) {
                srcFileName = srcFileName.substring(0, srcFile.getName().lastIndexOf(46)) + '.' + this.config.getInstrFileExtension();
            }
            File instr = new File(destDir, srcFileName);
            FileUtils.fileCopy(instrTmp, instr);
            this.log.verbose("Processed '" + srcFile + "' to '" + instr + "'");
            file = instr;
            if (instrTmp != null) {
                instrTmp.delete();
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.log.error(e.getMessage());
                throw new CloverException(e);
                catch (RecognitionException e2) {
                    String msg = srcFile + ":" + e2.getLine() + ":" + e2.getColumn() + ":" + e2.getMessage();
                    this.log.error(msg);
                    throw new CloverException(msg, e2);
                }
                catch (TokenStreamRecognitionException e3) {
                    String msg = srcFile + ":" + e3.recog.getLine() + ":" + e3.recog.getColumn() + ":" + e3.getMessage();
                    this.log.error(msg);
                    throw new CloverException(msg, e3);
                }
                catch (TokenStreamException e4) {
                    this.log.error("Error processing " + srcFile);
                    this.log.error(e4.getMessage());
                    throw new CloverException(e4);
                }
                catch (IOException e5) {
                    this.log.error("Error processing " + srcFile);
                    this.log.error(e5.getMessage());
                    throw new CloverException(e5);
                }
            }
            catch (Throwable throwable) {
                if (instrTmp != null) {
                    instrTmp.delete();
                }
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close(out);
        return file;
    }

    public FileStructureInfo instrument(@NotNull InstrumentationSource in, @NotNull Writer out, @Nullable String fileEncoding) throws TokenStreamException, IOException, RecognitionException, CloverException {
        BufferedReader bin = new BufferedReader(in.createReader());
        CloverTokenStreamFilter.guardAgainstDoubleInstrumentation(in.getSourceFileLocation(), bin);
        ChecksummingReader checksummingReader = new ChecksummingReader(bin);
        UnicodeDecodingReader unicodeReader = new UnicodeDecodingReader(checksummingReader);
        JavaLexer lexer = new JavaLexer(unicodeReader, this.config);
        CloverTokenStreamFilter filter = new CloverTokenStreamFilter(in.getSourceFileLocation().getAbsolutePath(), lexer);
        FileStructureInfo fileStructureInfo = new FileStructureInfo(in.getSourceFileLocation());
        JavaRecognizer parser = new JavaRecognizer(filter, this.config, fileStructureInfo, this.contextTreeRoot);
        parser.compilationUnit();
        if (!CloverLicenseInfo.isPkgAllowed(fileStructureInfo.getPackageName())) {
            if (!this.disallowedPackages.contains(fileStructureInfo.getPackageName())) {
                this.disallowedPackages.add(fileStructureInfo.getPackageName());
                this.warnAboutIllegalPkg(fileStructureInfo);
            }
            FileUtils.readerCopy(in.createReader(), out);
            return fileStructureInfo;
        }
        int linecount = lexer.getLineCount();
        if (filter.isEOLTerminated()) {
            --linecount;
        }
        int nclinecount = lexer.getNCLineCount();
        checksummingReader.close();
        unicodeReader.close();
        this.session.setSourceEncoding(fileEncoding);
        FullFileInfo fileInfo = (FullFileInfo)this.session.enterFile(fileStructureInfo.getPackageName(), in.getSourceFileLocation(), linecount, nclinecount, in.getSourceFileLocation().lastModified(), in.getSourceFileLocation().length(), checksummingReader.getChecksum());
        filter.instrument(fileStructureInfo, fileInfo, this.session, this.config);
        this.matchContexts(fileStructureInfo, this.registry.getContextStore());
        UnicodeEncodingWriter unicodeWriter = new UnicodeEncodingWriter(new BufferedWriter(out));
        filter.write(unicodeWriter);
        ((Writer)unicodeWriter).close();
        this.session.exitFile();
        this.updateStatistics(fileInfo);
        return fileStructureInfo;
    }

    public CharSequence instrument(@NotNull File orig, @NotNull CharSequence charSequence, @Nullable String fileEncoding) throws TokenStreamException, IOException, RecognitionException, CloverException {
        StringWriter stringWriter = new StringWriter();
        CharSequenceInstrumentationSource charSequenceSource = new CharSequenceInstrumentationSource(orig, charSequence);
        this.instrument(charSequenceSource, stringWriter, fileEncoding);
        return stringWriter.toString();
    }

    private void warnAboutIllegalPkg(FileStructureInfo fileStructureInfo) {
        Set allowedPkgs = CloverLicenseInfo.ALLOWED_PKG_PREFIXES;
        String msg = allowedPkgs == null ? "" : "This license may only be used for the following " + Formatting.pluralizedWord(allowedPkgs.size(), "package") + ": " + allowedPkgs;
        Logger.getInstance().warn("Sorry, you are not licensed to instrument files in the package '" + fileStructureInfo.getPackageName() + "'. To continue, please exclude all files in this package from instrumentation. " + msg);
    }

    public Clover2Registry endInstrumentation() throws CloverException {
        return this.endInstrumentation(false);
    }

    public Clover2Registry endInstrumentation(boolean append) throws CloverException {
        try {
            this.finishAndApply(this.session);
            if (append) {
                this.registry.saveAndAppendToFile();
            } else {
                this.registry.saveAndOverwriteFile();
            }
            float secs = (float)(this.session.getEndTS() - this.session.getStartTs()) / 1000.0f;
            int pkgs = this.packages.size();
            this.log.info("Clover all over. Instrumented " + this.numFiles + " file" + (this.numFiles != 1 ? "s" : "") + " (" + pkgs + " package" + (pkgs != 1 ? "s" : "") + ").");
            if (this.numTestMethods > 0) {
                this.log.info(this.numTestMethods + " test method" + (this.numTestMethods != 1 ? "s" : "") + " detected.");
            }
            this.log.info("Elapsed time = " + Formatting.format3d(secs) + " secs." + (secs > 0.0f ? " (" + Formatting.format3d((float)this.numFiles / secs) + " files/sec, " + Formatting.format3d((float)this.loc / secs) + " srclines/sec)" : ""));
            return this.registry;
        }
        catch (IOException e) {
            this.log.error("Error finalising instrumentation: ", e);
            throw new CloverException(e);
        }
    }

    protected void finishAndApply(InstrumentationSession session) throws ConcurrentInstrumentationException {
        session.close();
    }

    private void resetStatistics() {
        this.numFiles = 0;
        this.numClasses = 0;
        this.packages = new HashSet();
        this.numMethods = 0;
        this.numTestMethods = 0;
        this.loc = 0;
        this.ncloc = 0;
    }

    private void updateStatistics(FullFileInfo finfo) {
        ++this.numFiles;
        FileMetrics metrics = (FileMetrics)finfo.getMetrics();
        this.numClasses += metrics.getNumClasses();
        this.packages.add(finfo.getContainingPackage().getName());
        this.numMethods += metrics.getNumMethods();
        this.numTestMethods += metrics.getNumTestMethods();
        this.loc += metrics.getLineCount();
        this.ncloc += metrics.getNcLineCount();
    }

    private void matchContexts(FileStructureInfo fileInfo, ContextStore contexts) {
        FileStructureInfo.Marker marker;
        int i;
        int numMarkers = fileInfo.getNumMethodMarkers();
        for (i = 0; i < numMarkers; ++i) {
            marker = fileInfo.getMethodMarker(i);
            for (MethodRegexpContext methodRegexpContext : contexts.getMethodContexts()) {
                if (!methodRegexpContext.matches((FileStructureInfo.MethodMarker)marker)) continue;
                this.addContextToMarker(methodRegexpContext, marker);
                this.log.debug("Method context match, line " + marker.getStart().getLine() + ", id=" + methodRegexpContext.getName());
            }
        }
        numMarkers = fileInfo.getNumStatementMarkers();
        for (i = 0; i < numMarkers; ++i) {
            marker = fileInfo.getStatementMarker(i);
            for (StatementRegexpContext statementRegexpContext : contexts.getStatementContexts()) {
                if (!statementRegexpContext.matches(marker)) continue;
                this.addContextToMarker(statementRegexpContext, marker);
                this.log.debug("Statement context match, line " + marker.getStart().getLine() + ", id=" + statementRegexpContext.getName());
            }
        }
    }

    private void addContextToMarker(NamedContext context, FileStructureInfo.Marker marker) {
        CloverToken curr;
        CloverToken end = marker.getEnd();
        for (curr = marker.getStart(); curr != null && curr != end; curr = curr.getNext()) {
            curr.addContext(context);
        }
        if (curr != null) {
            curr.addContext(context);
        }
    }

    public InstrumentationSession getSession() {
        return this.session;
    }
}

