/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.Logger;
import com.atlassian.clover.PrematureLibraryLoader;
import com.atlassian.clover.ant.AntLogger;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractCloverTask
extends Task {
    protected AntInstrumentationConfig config;
    protected boolean debug;

    public void init() throws BuildException {
        super.init();
        Logger.setInstance(new AntLogger(this.getProject(), this));
        this.config = new AntInstrumentationConfig(this.getProject());
        PrematureLibraryLoader.doOnce();
    }

    public String getInitString() {
        return this.config.getInitString();
    }

    public void setInitString(String initString) {
        this.config.setInitstring(initString);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        Logger.setDebug(debug);
    }

    protected String resolveInitString() throws BuildException {
        return this.config.resolveInitString();
    }

    public final void execute() {
        if (this.config == null) {
            throw new BuildException("Configuration is null. This Task not initialiased correctly. Please ensure init() is called before execute().");
        }
        String antLicensePath = this.getProject().getProperty("clover.license.path");
        if (antLicensePath != null && antLicensePath.length() > 0) {
            System.setProperty("clover.license.path", antLicensePath);
        }
        CloverStartup.loadLicense(Logger.getInstance());
        if (this.validate()) {
            this.cloverExecute();
        }
    }

    public boolean validate() {
        return true;
    }

    public abstract void cloverExecute();

    public void setTmpDir(File tmpDir) {
        this.config.setTmpDir(tmpDir);
    }
}

