/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.Sets;
import clover.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.ints.IntComparator;
import clover.it.unimi.dsi.fastutil.ints.IntIterators;
import clover.it.unimi.dsi.fastutil.ints.IntSets;
import clover.it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class IntSortedSets {
    private IntSortedSets() {
    }

    public static IntSortedSet singleton(int element) {
        return new Singleton(element);
    }

    public static IntSortedSet singleton(int element, IntComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static IntSortedSet singleton(Object element) {
        return new Singleton((int)((Integer)element));
    }

    public static IntSortedSet singleton(Object element, IntComparator comparator) {
        return new Singleton((Integer)element, comparator);
    }

    public static IntSortedSet synchronize(IntSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static IntSortedSet synchronize(IntSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static IntSortedSet unmodifiable(IntSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends IntSets.UnmodifiableSet
    implements IntSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected UnmodifiableSortedSet(IntSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public IntSortedSet subSet(int from, int to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public IntSortedSet headSet(int to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public IntSortedSet tailSet(int from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public IntBidirectionalIterator iterator(int from) {
            return IntIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public int firstInt() {
            return this.sortedSet.firstInt();
        }

        public int lastInt() {
            return this.sortedSet.lastInt();
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }

        public Iterator iterator(Object from) {
            return IntIterators.unmodifiable(this.sortedSet.iterator((Integer)from));
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((IntSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((IntSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((IntSortedSet)this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends IntSets.SynchronizedSet
    implements IntSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected SynchronizedSortedSet(IntSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(IntSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public IntSortedSet subSet(int from, int to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public IntSortedSet headSet(int to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public IntSortedSet tailSet(int from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public IntBidirectionalIterator iterator(int from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int firstInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        public Iterator iterator(Object from) {
            return this.sortedSet.iterator((Integer)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((IntSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((IntSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((IntSortedSet)this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends IntSets.Singleton
    implements IntSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final IntComparator comparator;

        private Singleton(int element, IntComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(int element) {
            this(element, (IntComparator)null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public IntBidirectionalIterator iterator(int from) {
            IntBidirectionalIterator i = (IntBidirectionalIterator)this.intIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public IntSortedSet subSet(int from, int to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public IntSortedSet headSet(int to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public IntSortedSet tailSet(int from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public int firstInt() {
            return this.element;
        }

        public int lastInt() {
            return this.element;
        }

        public Object first() {
            return new Integer(this.element);
        }

        public Object last() {
            return new Integer(this.element);
        }

        public Iterator iterator(Object from) {
            return this.iterator((Integer)from);
        }

        public SortedSet subSet(Object from, Object to) {
            return this.subSet((Integer)from, (Integer)to);
        }

        public SortedSet headSet(Object to) {
            return this.headSet((Integer)to);
        }

        public SortedSet tailSet(Object from) {
            return this.tailSet((Integer)from);
        }
    }
}

