/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByte2CharMap;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import clover.it.unimi.dsi.fastutil.bytes.Byte2CharMap;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteSet;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Byte2CharOpenHashMap
extends AbstractByte2CharMap
implements Serializable,
Cloneable,
Hash,
Byte2CharMap {
    protected transient byte[] key;
    protected transient char[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ByteSet keys;
    protected volatile transient CharCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Byte2CharOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new byte[this.free];
        this.value = new char[this.free];
        this.state = new byte[this.free];
    }

    public Byte2CharOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Byte2CharOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2CharOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2CharOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Byte2CharOpenHashMap(Byte2CharMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Byte2CharOpenHashMap(Byte2CharMap m) {
        this(m, 0.75f);
    }

    public Byte2CharOpenHashMap(byte[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2CharOpenHashMap(byte[] k, char[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public char put(byte k, char v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        char v = ((Character)ov).charValue();
        byte k = (Byte)ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Character(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(char v) {
        char[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    public boolean containsKey(byte k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public char get(byte k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public char remove(byte k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey((Byte)ok);
        return i < 0 ? null : new Character(this.value[i]);
    }

    public Object remove(Object ok) {
        byte k = (Byte)ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return new Character(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Byte2CharOpenHashMap.this.findKey((Byte)e.getKey());
                    return i >= 0 && Byte2CharOpenHashMap.this.value[i] == ((Character)e.getValue()).charValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Byte2CharOpenHashMap.this.findKey((Byte)e.getKey());
                    if (i >= 0) {
                        Byte2CharOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Byte2CharOpenHashMap.this.count;
                }

                public void clear() {
                    Byte2CharOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                public CharIterator charIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Byte2CharOpenHashMap.this.count;
                }

                public boolean contains(char v) {
                    return Byte2CharOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Byte2CharOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        byte[] key = this.key;
        byte[] newKey = new byte[newN];
        char[] value = this.value;
        char[] newValue = new char[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            byte k = key[i];
            char v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Byte2CharOpenHashMap c;
        try {
            c = (Byte2CharOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        char[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new byte[n];
        byte[] key = this.key;
        this.value = new char[n];
        char[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            byte k = s.readByte();
            char v = s.readChar();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements CharIterator {
        public char nextChar() {
            return Byte2CharOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Character(Byte2CharOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        public void add(char v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractByteSet {
        private KeySet() {
        }

        public ByteIterator byteIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Byte2CharOpenHashMap.this.count;
        }

        public boolean contains(byte k) {
            return Byte2CharOpenHashMap.this.containsKey(k);
        }

        public boolean remove(byte k) {
            int oldCount = Byte2CharOpenHashMap.this.count;
            Byte2CharOpenHashMap.this.remove(k);
            return Byte2CharOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Byte2CharOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteIterator {
        public byte nextByte() {
            return Byte2CharOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Byte(Byte2CharOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(byte k) {
            throw new UnsupportedOperationException();
        }

        public void add(byte k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Byte2CharOpenHashMap.this.count;
            byte[] state = Byte2CharOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Byte2CharOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Byte2CharOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Byte2CharOpenHashMap.this.state[this.last] = 1;
            --Byte2CharOpenHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Byte2CharMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Byte(Byte2CharOpenHashMap.this.key[this.index]);
        }

        public byte getByteKey() {
            return Byte2CharOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Character(Byte2CharOpenHashMap.this.value[this.index]);
        }

        public char getCharValue() {
            return Byte2CharOpenHashMap.this.value[this.index];
        }

        public char setValue(char v) {
            char oldValue = Byte2CharOpenHashMap.this.value[this.index];
            Byte2CharOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Character(this.setValue(((Character)v).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2CharOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2CharOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return Byte2CharOpenHashMap.this.key[this.index] ^ Byte2CharOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Byte2CharOpenHashMap.this.key[this.index] + "->" + Byte2CharOpenHashMap.this.value[this.index];
        }
    }
}

