/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.tools;

import de.superx.job.ContainerNode;
import de.superx.job.Timestamp;
import de.superx.job.UnloadParams;
import de.superx.servlet.SuperXManager;
import de.superx.spring.service.DbJobDescriptionAdapter;
import de.superx.spring.service.JobDescriptionSource;
import java.io.File;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class LoadEtlRoutines {
    public static void main(String[] args) {
        System.out.println("Load ETL Routines");
        if (args.length == 0 || args.length > 2) {
            System.err.println("Es werden ein (Komponentenk\u00fcrzel) oder zwei Parameter (Komponentenk\u00fcrzel, Pfad zu superx) erwartet!");
            return;
        }
        Object superxDir = "superx";
        if (args.length == 2) {
            superxDir = "file:" + args[1];
            System.out.println("SUPERX_DIR: " + (String)superxDir);
            SuperXManager.setWEB_INFPfad(args[1] + File.separator + "WEB-INF");
        }
        FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext(String.join((CharSequence)File.separator, new String[]{superxDir, "WEB-INF", "standaloneApplicationContext.xml"}));
        LoadEtlRoutines.loadEtlRoutinesIntoDb(args[0], (ApplicationContext)appContext);
    }

    public static void loadEtlRoutinesIntoDb(String componentAbbreviation, ApplicationContext appContext) {
        DataSource dsEduetl = (DataSource)appContext.getBean("dataSource");
        JdbcTemplate jt = new JdbcTemplate(dsEduetl);
        jt.execute("drop index if exists ix_etl_step1");
        JobDescriptionSource entityJobDescriptionSource = (JobDescriptionSource)appContext.getBean("entityJobDescriptionSource");
        DbJobDescriptionAdapter dbJobDescriptionAdapter = (DbJobDescriptionAdapter)appContext.getBean("dbJobDescriptionAdapter");
        ContainerNode root = entityJobDescriptionSource.getLoadAndTransformJob(componentAbbreviation);
        root.add(new Timestamp(root.systemInfoId));
        dbJobDescriptionAdapter.writeToDb(root);
        List<ContainerNode> ulrs = entityJobDescriptionSource.getSpecialJobs(componentAbbreviation);
        for (ContainerNode ulr : ulrs) {
            ulr.getActions().add(0, new UnloadParams(ulr.systemInfoId));
            dbJobDescriptionAdapter.writeToDb(ulr);
        }
        ContainerNode rootUnl = entityJobDescriptionSource.getUnloadJob(componentAbbreviation);
        if (rootUnl != null) {
            rootUnl.getActions().add(0, new UnloadParams(rootUnl.systemInfoId));
            dbJobDescriptionAdapter.writeToDb(rootUnl);
            ContainerNode rootComplete = new ContainerNode(componentAbbreviation.toUpperCase() + " Unload, Load And Transform", componentAbbreviation + "_unload_load_transform", root.systemInfoId);
            rootComplete.add(rootUnl);
            rootComplete.add(root);
            dbJobDescriptionAdapter.writeToDb(rootComplete);
        }
    }
}

