/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.writer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class TypeinferringJdbcBatchItemWriter
extends JdbcBatchItemWriter<String[]>
implements StepExecutionListener {
    List<Integer> columnTypes;
    private DataSource dataSource;
    private String tableName;
    private boolean truncate;
    public static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "dd.MM.yyyy", "dd.MM.yy", "yyyy-MM-dd HH:mm:ss"};
    public static final String[] TIMESTAMP_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss", "dd.MM.yyyy HH:mm:ss"};

    public TypeinferringJdbcBatchItemWriter(DataSource dataSource, String tableName, boolean truncate) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.truncate = truncate;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.setDataSource(this.dataSource);
        this.setSqlAndColumnTypes();
        ArrayList namedParameters = new ArrayList();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders((String)this.sql, namedParameters);
        this.setItemPreparedStatementSetter((ItemPreparedStatementSetter)new ItemPreparedStatementSetter<String[]>(){

            public void setValues(String[] item, PreparedStatement ps) throws SQLException {
                if (item.length != TypeinferringJdbcBatchItemWriter.this.columnTypes.size() || item.length != TypeinferringJdbcBatchItemWriter.this.parameterCount) {
                    String error = String.format("Prepared statment count wrong!\nParameters: %d\nColumn types: %d\nItem length: %d\nItem: %s", TypeinferringJdbcBatchItemWriter.this.parameterCount, TypeinferringJdbcBatchItemWriter.this.columnTypes.size(), item.length, String.join((CharSequence)"| ", Arrays.asList(item)));
                    logger.error((Object)error);
                    throw new RuntimeException(error);
                }
                for (int i = 0; i < item.length; ++i) {
                    try {
                        Date d;
                        int type = TypeinferringJdbcBatchItemWriter.this.columnTypes.get(i);
                        if (item[i].isEmpty()) {
                            ps.setNull(i + 1, type);
                            continue;
                        }
                        if (type == 91) {
                            d = new Date(DateUtils.parseDate((String)item[i], (String[])DATE_FORMATS).getTime());
                            ps.setDate(i + 1, d);
                            continue;
                        }
                        if (type == 93 || type == 2014 || type == 92 || type == 2013) {
                            d = new Date(DateUtils.parseDate((String)item[i], (String[])TIMESTAMP_FORMATS).getTime());
                            ps.setDate(i + 1, d);
                            continue;
                        }
                        if (type == 1 || type == 12 || type == -15 || type == -9) {
                            ps.setString(i + 1, StringEscapeUtils.unescapeJava((String)item[i]));
                            continue;
                        }
                        if (item[i].trim().isEmpty()) {
                            ps.setNull(i + 1, type);
                            continue;
                        }
                        ps.setObject(i + 1, (Object)item[i].trim(), type);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw new RuntimeException("Couldn't load unl file into table " + TypeinferringJdbcBatchItemWriter.this.tableName + " item nr. " + (i + 1) + ": '" + item[i] + "' in line: [" + String.join((CharSequence)",", item) + "]", e);
                    }
                }
            }
        });
        if (this.truncate) {
            JdbcTemplate jt = new JdbcTemplate(this.dataSource);
            jt.execute("truncate table " + this.tableName);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void afterPropertiesSet() {
    }

    private void setSqlAndColumnTypes() {
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        try (Connection con = this.dataSource.getConnection();){
            DatabaseMetaData dbm = con.getMetaData();
            try (ResultSet rs = dbm.getColumns(null, null, this.tableName, null);){
                while (rs.next()) {
                    dataTypes.add(rs.getInt("DATA_TYPE"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error getting connection", (Throwable)e);
        }
        this.columnTypes = dataTypes;
        Object[] placeHolders = new String[dataTypes.size()];
        Arrays.fill(placeHolders, "?");
        String sqlPreparedStatement = "INSERT INTO " + this.tableName + " VALUES (" + StringUtils.join((Object[])placeHolders, (char)',') + ")";
        this.setSql(sqlPreparedStatement);
    }
}

