/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet.filter;

import de.superx.conf.ApplicationConfig;
import de.superx.conf.InitStatus;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class HealthCheckFilter
implements Filter {
    FilterConfig config;
    private static String path = "/health";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Boolean useHealthCheck = (Boolean)ApplicationConfig.getWithType(ApplicationConfig.Key.init_health_check);
        if (httpRequest.getRequestURL().toString().endsWith(path) && useHealthCheck.booleanValue()) {
            response.setContentType("application/json");
            Map<InitStatus.SubSystem, Boolean> subsystemStatus = InitStatus.getSubSystemStatus();
            boolean ok = !subsystemStatus.values().stream().anyMatch(it -> it == Boolean.FALSE);
            httpResponse.getOutputStream().print(HealthCheckFilter.getStatusString(ok, subsystemStatus));
            if (ok) {
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(500);
            }
        } else if (httpRequest.getRequestURL().toString().endsWith(path)) {
            httpResponse.setStatus(404);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig configIn) throws ServletException {
        this.config = configIn;
    }

    private static String getStatusString(boolean ok, Map<InitStatus.SubSystem, Boolean> subSystemStatus) {
        String status = ok ? "Ok" : "Problem";
        Object subSystems = "";
        for (Map.Entry<InitStatus.SubSystem, Boolean> subSystem : subSystemStatus.entrySet()) {
            subSystems = (String)subSystems + "\n    { \"" + subSystem.getKey().toString() + "\" : \"" + (subSystem.getValue() != false ? "Ok" : "Problem") + "\" },";
        }
        return "{\n  \"status\": \"" + status + "\",\n  \"subSystems\": [" + ((String)subSystems).substring(0, ((String)subSystems).length() - 1) + "\n  ]\n}";
    }
}

