/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.base.Joiner;
import de.memtext.db.NichtAngemeldetException;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXmlAnmeldung;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.web.util.UriUtils;

public class TokenChecker {
    private String token = null;
    private List<String> tokenParts = null;
    Logger logger = Logger.getLogger(SuperXmlAnmeldung.class);

    public static void main(String[] a) {
        String token = "1.0/1319735296/superx/admin/bi_admin/1/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN/1/3/45ae5984bf81f73f7d320d8fc4190689";
        SuperXManager.sharedSecret = "rdfS3Y4Cx5Pb9gVxTOoZUT2TvnaOEKRNu";
        while (token.indexOf("//") > -1) {
            token = token.replace("//", "/ /");
        }
        System.out.println(token);
        StringTokenizer st = new StringTokenizer(token, "/");
        int i = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            System.out.println(++i + ":" + t);
        }
        TokenChecker tc = new TokenChecker(token);
        try {
            tc.testAll();
        }
        catch (NichtAngemeldetException e) {
            e.printStackTrace();
        }
    }

    public TokenChecker(String token) {
        this.token = token;
        this.tokenParts = this.initTokenParts(token);
    }

    String getTokenString() {
        return this.token;
    }

    private List<String> initTokenParts(String token) {
        ArrayList<String> toksList = new ArrayList<String>(15);
        if (token != null) {
            int len = token.length();
            StringBuffer part = new StringBuffer();
            boolean insideBrackets = false;
            for (int i = 0; i < len; ++i) {
                char lookingAt = token.charAt(i);
                if (lookingAt == '[') {
                    insideBrackets = true;
                    part.append(lookingAt);
                    continue;
                }
                if (lookingAt == ']') {
                    insideBrackets = false;
                    part.append(lookingAt);
                    continue;
                }
                if (lookingAt == '/' && !insideBrackets) {
                    toksList.add(part.toString());
                    part = new StringBuffer();
                    continue;
                }
                part.append(lookingAt);
            }
            toksList.add(part.toString());
        }
        return toksList;
    }

    private boolean isNumberTokenPartsOK() {
        return this.tokenParts.size() >= 10;
    }

    private boolean isTokenVersionOK() {
        return this.token.startsWith("1.0") || this.token.startsWith("2.0");
    }

    public void testAll() throws NichtAngemeldetException {
        this.logger.debug((Object)"Running TokenChecker.testAll()");
        if (this.tokenParts == null) {
            this.logger.error((Object)"Kein Token gefunden");
            throw new NichtAngemeldetException("Kein Token gefunden");
        }
        if (!this.isTokenVersionOK()) {
            this.logger.error((Object)"Falsche Tokenversion");
            throw new NichtAngemeldetException("Falsche Tokenversion");
        }
        if (!this.isNumberTokenPartsOK()) {
            this.logger.error((Object)"Fehlerhaftes Token  DETAILS:- moeglicherweise ein Wert leer , im Token //");
            throw new IllegalArgumentException("Fehlerhaftes Token  DETAILS:- moeglicherweise ein Wert leer , im Token //");
        }
        this.testTime();
        this.testApp();
        this.testHash();
    }

    void testTime() throws NichtAngemeldetException {
        if (!this.isTokentimestampParseable()) {
            this.logger.error((Object)"Unpassender Tokentimestamp");
            throw new NichtAngemeldetException("Unpassender Tokentimestamp");
        }
        if (!this.isTimeOK()) {
            this.logger.error((Object)"Tokentimestamp ung\u00fcltig: Zeit auf den tomcats/apache abgleichen!");
            throw new NichtAngemeldetException("Tokentimestamp ung\u00fcltig: Zeit auf den tomcats/apache abgleichen!");
        }
    }

    boolean isTimeOK() {
        boolean result = false;
        long time = 0L;
        try {
            time = Long.parseLong(this.tokenParts.get(1).toString()) * 1000L;
            long aminago = new Date().getTime() - 60000L;
            long aminahead = new Date().getTime() + 60000L;
            if (time >= aminago && time <= aminahead) {
                result = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Couldn't check token time", (Throwable)e);
        }
        return result;
    }

    private boolean isTokentimestampParseable() {
        boolean result = false;
        try {
            long testtime = Long.parseLong(this.tokenParts.get(1).toString()) * 1000L;
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    void testApp() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 3 || this.tokenParts.get(2) == null || !this.tokenParts.get(2).toString().equalsIgnoreCase("superx")) {
            this.logger.error((Object)"falsche Webapp im Token");
            throw new NichtAngemeldetException("falsche Webapp im Token");
        }
        this.logger.debug((Object)("Webapp im Token: " + this.tokenParts.get(2).toString()));
    }

    String getKennung() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 4) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        String kennung = this.tokenParts.get(3).toString();
        kennung = UriUtils.decode((String)kennung, (String)"utf8");
        return kennung;
    }

    String getKennungRoleInst() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 4) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.tokenParts.get(3).toString();
    }

    String getRole() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 5) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return "ROLE_" + this.tokenParts.get(4).toString().trim().toUpperCase();
    }

    Integer getOrgunitLid() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 6) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return Integer.valueOf(this.tokenParts.get(5).trim());
    }

    String getRights() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 7) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.tokenParts.get(6).toString().trim();
    }

    String getExternAccountID() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 8) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.tokenParts.get(7).toString().trim();
    }

    String getExternPersonID() throws NichtAngemeldetException {
        if (this.tokenParts.size() < 9) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.tokenParts.get(8).toString().trim();
    }

    Integer getExternRoleID() {
        if (this.tokenParts.size() < 11) {
            return null;
        }
        String roleId = this.tokenParts.get(9).toString().trim();
        return Integer.valueOf(roleId);
    }

    private String getHash() throws NichtAngemeldetException {
        if (!this.isNumberTokenPartsOK()) {
            this.logger.error((Object)"Token < 10 Zeichen.");
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        this.logger.debug((Object)("Toks: " + this.tokenParts.toString()));
        String hash = this.tokenParts.get(this.tokenParts.size() - 1).toString().trim();
        return hash;
    }

    void testHash() throws NichtAngemeldetException {
        if (SuperXManager.sharedSecret == null || SuperXManager.sharedSecret.trim().equals("")) {
            this.logger.error((Object)"Kein Shared secret hinterlegt");
            throw new NichtAngemeldetException("Kein Shared secret hinterlegt");
        }
        Joiner joiner = Joiner.on((char)'/');
        String tokprefix = joiner.join(this.tokenParts.subList(0, this.tokenParts.size() - 1));
        boolean isHashCorrect = this.checkHash(this.tokenParts.get(0), this.getHash(), tokprefix, SuperXManager.sharedSecret);
        if (!isHashCorrect) {
            this.logger.error((Object)"Token ungueltig");
            throw new NichtAngemeldetException("Token ungueltig");
        }
    }

    boolean checkHash(String version, String hash, String toHash, String confSharedSecret) {
        String sharedSecret = confSharedSecret;
        if (sharedSecret == null || sharedSecret.trim().equals("")) {
            this.logger.error((Object)"shared-secret ist nicht definiert");
            return false;
        }
        String myHash = null;
        String in = toHash + "/" + sharedSecret;
        try {
            if (version.startsWith("1.0")) {
                md = MessageDigest.getInstance("MD5");
                myHash = TokenChecker.getHex(md.digest(in.getBytes("UTF-8")));
            } else {
                md = MessageDigest.getInstance("SHA-512");
                md.update(in.getBytes("UTF-8"));
                byte[] mb = md.digest();
                myHash = TokenChecker.getHex(mb);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)e, (Throwable)e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)e, (Throwable)e);
            return false;
        }
        boolean retVal = myHash.equals(hash);
        if (!retVal) {
            this.logger.warn((Object)("Ungueltiges Auth-Token: Angegebener Hashwert und berechneter Hashwert stimmen nicht ueberein: " + hash + " (berechnet: " + myHash + ")"));
            this.logger.warn((Object)("Token was: " + toHash));
            this.logger.warn((Object)("Shared secret was: " + sharedSecret));
        }
        return retVal;
    }

    public static String getHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }
}

