/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.FileUtils;
import de.memtext.util.NumberUtils;
import de.memtext.util.StringUtils;
import de.superx.common.Maske;
import de.superx.common.SxUser;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.SxJRXlsExporter;
import de.superx.servlet.SxJasperDataSource;
import de.superx.util.JasperUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class JasperCreator
extends ServletBasics {
    private final String exportname;
    private final String jrxml_file;
    private final String contenttype;
    private final String reports_dir;
    private String outfile_jasper;
    private final SxUser user;
    private final String STYLESHEET_DEVMODE_KEY = "JasperStylesheetDevmode";

    public JasperCreator(HttpServletRequest request, HttpServletResponse response, SxUser user, Maske maske, String jrxml_file, String contenttype, String reports_dirParam) throws IOException, JRException {
        super(request, response, "superx");
        this.user = user;
        this.jrxml_file = jrxml_file;
        this.contenttype = contenttype;
        this.exportname = maske.getExportName();
        this.reports_dir = reports_dirParam;
        this.compileReport(maske);
        String stylesheetDevmode = System.getProperty("JasperStylesheetDevmode");
        if (stylesheetDevmode != null && stylesheetDevmode.equals("true")) {
            JasperUtils.compileAllJRXMLFiles(reports_dirParam);
        }
    }

    private void compileReport(Maske maske) throws IOException, JRException {
        File myjrxml = new File(this.reports_dir + this.jrxml_file);
        if (!myjrxml.exists()) {
            throw new IOException("jrxml-Datei " + this.reports_dir + this.jrxml_file + " nicht gefunden");
        }
        if (this.jrxml_file.indexOf("_freem") > -1) {
            this.fmparse(maske, myjrxml);
        } else {
            this.outfile_jasper = this.reports_dir + this.jrxml_file.substring(0, this.jrxml_file.lastIndexOf(".")) + ".jasper";
        }
        File myjasper = new File(this.outfile_jasper);
        if (!myjasper.exists() || myjasper.lastModified() <= myjrxml.lastModified()) {
            JasperCompileManager.compileReportToFile((String)(this.reports_dir + this.jrxml_file), (String)this.outfile_jasper);
        }
    }

    private void fmparse(Maske maske, File myjrxml) throws IOException, JRException {
        String tmp_jrxml = "tmp_" + NumberUtils.getRandomInt(1000000) + "_" + this.jrxml_file;
        this.outfile_jasper = this.reports_dir + tmp_jrxml.substring(0, tmp_jrxml.lastIndexOf(".")) + ".jasper";
        this.deleteTmp(tmp_jrxml);
        String vorlage = StringUtils.readFile(myjrxml);
        try {
            vorlage = maske.fmProcess(this.user, vorlage);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JRException("Fehler beim Freemarker-Parsen von " + String.valueOf(myjrxml) + "\n" + String.valueOf(e));
        }
        org.apache.commons.io.FileUtils.writeStringToFile((File)new File(this.reports_dir + tmp_jrxml), (String)vorlage);
        JasperCompileManager.compileReportToFile((String)(this.reports_dir + tmp_jrxml), (String)this.outfile_jasper);
    }

    private void deleteTmp(String tmp_jrxml) {
        if (this.outfile_jasper.indexOf("tmp_") > -1) {
            File f = new File(this.reports_dir + tmp_jrxml);
            if (f.exists()) {
                f.delete();
            }
            if ((f = new File(this.outfile_jasper)).exists()) {
                f.delete();
            }
        }
    }

    public void perform(String mandantenID, String dataxml, String outfile) throws JRException, IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        InputSource is = new InputSource(new StringReader(dataxml));
        Document document = JRXmlUtils.parse((InputSource)is);
        parameters.put("XML_DATA_DOCUMENT", document);
        parameters.put("XML_DATE_PATTERN", "dd.MM.yyyy");
        parameters.put("XML_NUMBER_PATTERN", "###0.##");
        parameters.put("XML_LOCALE", Locale.ENGLISH);
        parameters.put("REPORT_LOCALE", Locale.GERMAN);
        this.runExport(mandantenID, parameters, null, outfile);
    }

    public void perform(String mandantenID, Maske maske, String outfile) throws JRException, IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", Locale.GERMAN);
        SxJasperDataSource ds = new SxJasperDataSource(mandantenID, this.getDesiredLocale(), this.user, maske);
        parameters.put("DataFile", "SxJasperDataSource.java");
        this.runExport(mandantenID, parameters, ds, outfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExport(String mandantenID, Map parameters, SxJasperDataSource ds, String outfile) throws JRException, IOException {
        JRSwapFileVirtualizer jrVirtualizer = new JRSwapFileVirtualizer(10, new JRSwapFile(System.getProperty("java.io.tmpdir"), 4096, 200), true);
        parameters.put("REPORT_VIRTUALIZER", jrVirtualizer);
        if (this.contenttype == null) {
            throw new IllegalArgumentException("Can't create jasper report, no contenttype found");
        }
        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.DEBUG, (Object)(" erzeuge JasperReport " + this.jrxml_file + " Datenquelle " + (ds == null ? "XML" : "JavaObjects") + " mit contenttype " + this.contenttype));
        JasperPrint jasperprint = null;
        jasperprint = ds == null ? JasperFillManager.fillReport((String)this.outfile_jasper, (Map)parameters) : JasperFillManager.fillReport((String)this.outfile_jasper, (Map)parameters, (JRDataSource)ds);
        try (ServletOutputStream sos = this.response.getOutputStream();){
            String attach = "attachment; filename=" + FileUtils.removeProblemChars(this.exportname);
            this.response.setContentType(this.contenttype);
            if (this.contenttype.startsWith("application/pdf")) {
                if (outfile == null) {
                    this.response.setHeader("Content-disposition", attach + ".pdf");
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperprint, (OutputStream)sos);
                } else {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperprint, (String)outfile);
                }
            } else if (this.contenttype.startsWith("application/rtf") || this.contenttype.startsWith("application/msword")) {
                JRRtfExporter exporter = new JRRtfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    this.response.setContentType("application/rtf");
                    this.response.setHeader("Content-disposition", attach + ".rtf");
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.ms-excel")) {
                this.response.setHeader("Content-disposition", attach + ".xls");
                SxJRXlsExporter exporter = new SxJRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperprint);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, Boolean.TRUE);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, outfile);
                }
                String[] sheetNames = new String[]{"Tabelle1", "Tabelle2", "Tabelle3", "Tabelle4", "Tabelle5", "Tabelle6", "Tabelle7", "Tabelle8", "Tabelle9", "Tabelle10", "Tabelle11", "Tabelle12", "Tabelle13"};
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.SHEET_NAMES, sheetNames);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.oasis.opendocument.text")) {
                this.response.setHeader("Content-disposition", attach + ".odt");
                JROdtExporter exporter = new JROdtExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.oasis.opendocument.spreadsheet")) {
                this.response.setHeader("Content-disposition", attach + ".ods");
                JROdtExporter exporter = new JROdtExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("text/html")) {
                this.response.setContentType("text/html");
                HtmlExporter exporter = new HtmlExporter();
                String printSessionName = this.jrxml_file + "_" + new Date().getTime();
                this.request.getSession().setAttribute(printSessionName, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("image?jrprint=" + printSessionName + "&image="));
                exporter.exportReport();
            } else if (this.contenttype.equals("text/xhtml")) {
                this.response.setContentType("text/xhtml");
                HtmlExporter exporter = new HtmlExporter();
                this.request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"image?image=");
                exporter.exportReport();
            } else if (this.contenttype.startsWith("image/")) {
                this.response.setContentType("image/gif");
                JRGraphics2DExporter exporter = new JRGraphics2DExporter();
                this.request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                BufferedImage bi = new BufferedImage(jasperprint.getPageWidth(), jasperprint.getPageHeight(), 1);
                Graphics2D reportImage = bi.createGraphics();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)reportImage);
                exporter.exportReport();
                ImageIO.write((RenderedImage)bi, "gif", (OutputStream)sos);
            } else if (this.contenttype.equals("text/csv")) {
                this.response.setContentType("text/plain");
                this.response.setHeader("Content-disposition", attach + ".csv");
                JRCsvExporter exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("text/plain")) {
                this.response.setHeader("Content-disposition", attach + ".txt");
                JRTextExporter exporter = new JRTextExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("text/xml")) {
                this.response.setHeader("Content-disposition", attach + ".xml");
                JRXmlExporter exporter = new JRXmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                this.exportXLSX(outfile, jasperprint, (OutputStream)sos, attach);
            } else if (this.contenttype.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                JRDocxExporter exporter = new JRDocxExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                if (outfile == null) {
                    this.response.setHeader("Content-disposition", attach + ".docx");
                    exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                } else {
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
                }
                exporter.exportReport();
            } else {
                this.response.setContentType("text/html");
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)" Kann JasperReport nicht erzeugen, contentype unbekannt ");
                throw new JRException("Kein bekanntes Ausgabeformat:" + this.contenttype);
            }
            Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.DEBUG, (Object)" schicken des JasperReport an Client ");
        }
        finally {
            jrVirtualizer.cleanup();
        }
    }

    protected void exportXLSX(String outfile, JasperPrint jasperprint, OutputStream sos, String attach) throws IOException, FileNotFoundException, JRException {
        String cellmerge;
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        String repeatingRowsRange = exporter.getPropertiesUtil().getProperty((JRPropertiesHolder)jasperprint, "net.sf.jasperreports.export.xls.sx_repeating.rows.range");
        if (repeatingRowsRange != null && repeatingRowsRange.equals("")) {
            repeatingRowsRange = null;
        }
        if ((cellmerge = exporter.getPropertiesUtil().getProperty((JRPropertiesHolder)jasperprint, "net.sf.jasperreports.export.xls.sx_cell_merge")) != null && cellmerge.equals("")) {
            cellmerge = null;
        }
        if (repeatingRowsRange != null || cellmerge != null) {
            this.exportXLSX_mitPOINachbearbeitung(outfile, sos, attach, exporter, repeatingRowsRange, cellmerge);
        } else {
            if (outfile == null) {
                this.response.setHeader("Content-disposition", attach + ".xlsx");
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
            } else {
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outfile);
            }
            exporter.exportReport();
        }
    }

    protected void exportXLSX_mitPOINachbearbeitung(String outfile, OutputStream sos, String attach, JRXlsxExporter exporter, String repeatingRowsRange, String cellmerge) throws IOException, FileNotFoundException, JRException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporter.exportReport();
        os.close();
        ByteArrayInputStream bi = new ByteArrayInputStream(os.toByteArray());
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)bi);
        bi.close();
        SxJRXlsExporter sxJRXLSExporter = new SxJRXlsExporter();
        XSSFSheet sheet = workbook.getSheetAt(0);
        if (repeatingRowsRange != null) {
            sxJRXLSExporter.setReatingRowsRange((Sheet)sheet, repeatingRowsRange);
        }
        if (cellmerge != null) {
            sxJRXLSExporter.addMergeRegion((Sheet)sheet, cellmerge);
        }
        if (outfile == null) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            this.response.reset();
            this.response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.response.setHeader("Content-disposition", attach + ".xlsx");
            this.response.setHeader("Cache-Control", "expires=0");
            outStream.writeTo(sos);
            outStream.close();
        } else {
            FileOutputStream fileOut = new FileOutputStream(outfile);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
    }
}

