/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.TreeUtils;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.NotYetImplementedException;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.jdbc.entity.Konstante;
import de.superx.jdbc.repository.KonstanteRepository;
import de.superx.rest.Report;
import de.superx.rest.ReportApiBase;
import de.superx.rest.config.HisDynamicFieldConfigurator;
import de.superx.rest.config.HisDynamicMultiSelectConfigurator;
import de.superx.rest.config.HisDynamicSelectConfigurator;
import de.superx.rest.config.HisDynamicTreeSelectConfigurator;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Form;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import de.superx.rest.util.RequestWrapper;
import de.superx.spring.service.UserService;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import javax.swing.tree.TreeModel;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/form"})
public class FormApi
extends ReportApiBase {
    @Autowired
    DataSource dataSource;
    @Autowired
    UserService userService;
    @Autowired
    KonstanteRepository konstanteRepository;
    public static final String TABLESTYLESHEET = "tablestylesheet";
    public static final String PREASSIGNMENT = "preassignment";
    static Logger logger = Logger.getLogger(Form.class);
    private static String LABEL_TEXT_ALLE = "Alle";
    private static String TRIGGERING_FIELD = "triggeringField";

    public FormApi(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, path={"/{tid}"})
    public Form getSelektionsparameterConfig(@PathVariable(value="tid") int tid, HttpServletRequest request) throws ParseException, KeyParentEqualException, NoMainEntryException, SQLException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, TemplateException, CloneNotSupportedException, IOException, DBServletException, TransformerException {
        logger.debug((Object)("*** GET SELEKTIONSPARAMETERCONFIG FOR " + tid + " ***"));
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Form result = new Form();
            HisDynamicFieldConfig dynamicFieldConfig = new HisDynamicFieldConfig("form", FieldType.Form);
            Maske maske = FormApi.initMaske(tid, request, user);
            dynamicFieldConfig.children = FormApi.getHisDynamicFieldsOfMask(maske, user);
            result.stylesheets.stylesheets = maske.getTableStylesheetsForNg();
            result.stylesheets.selectedStylesheet = maske.getDefaultStylesheetForNg();
            result.dynamicFieldConfig = dynamicFieldConfig;
            result.tid = tid;
            Map preAssignment = (Map)request.getSession().getAttribute(this.getPreAssignmentSachgebietId(tid) + PREASSIGNMENT);
            result.preAssignmentParams = this.getMaskenPreAssignmentFields(preAssignment, maske, user);
            return result;
        }
    }

    public static List<HisDynamicFieldConfig> getHisDynamicFieldsOfMask(Maske maske, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        ArrayList<HisDynamicFieldConfig> hisDynamicFieldsOfMask = new ArrayList<HisDynamicFieldConfig>();
        FieldContainer fields = maske.getIndividualFields();
        logger.debug((Object)"*** RE-SETTING DEFAULT VALUES");
        for (Field field : fields) {
            if (FormApi.evaluateSkipCondition(field)) continue;
            field.updateDefaultValue(maske.getFormularCopy(), null, maske.getIndividualFields(), null, false, user);
            FieldType fieldType = FieldType.getCorrectedFieldType(field);
            if (fieldType == FieldType.HLine) continue;
            HisDynamicFieldConfig formField = new HisDynamicFieldConfig(field, fieldType);
            if (fieldType == FieldType.TreeSelect) {
                items = FormApi.createTreeNodeSelectableItems(field);
                if (items != null) {
                    formField.setItems(items);
                }
            } else if (fieldType == FieldType.Select || fieldType == FieldType.MultiSelect || fieldType == FieldType.RadioButton) {
                items = FormApi.createSelectableItems(field);
                formField.setItems(items);
            }
            hisDynamicFieldsOfMask.add(formField);
        }
        return hisDynamicFieldsOfMask;
    }

    public Map<String, String> getMaskenPreAssignmentFields(Map<Integer, String> preAssignement, final Maske targetMaske, final SxUser user) {
        if (preAssignement == null) {
            return null;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        final HashMap<String, String> validPreAssignmentParams = new HashMap<String, String>();
        for (final Map.Entry<Integer, String> entry : preAssignement.entrySet()) {
            Integer fieldTid = entry.getKey();
            if (fieldTid == null) continue;
            jdbcTemplate.query(Maske.QUERY_FELD, new Object[]{fieldTid}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException, DataAccessException {
                    Field preAssignmentField = new Field();
                    preAssignmentField.setId(rs.getInt("tid"));
                    preAssignmentField.setName(rs.getString("name"));
                    preAssignmentField.setTyp(rs.getString("typ"));
                    preAssignmentField.setArt(Field.Art.valueOf(rs.getInt("art")));
                    preAssignmentField.setZeilenanzahl(rs.getInt("zeilenanzahl"));
                    preAssignmentField.setFieldType();
                    String preAssignmentValue = (String)entry.getValue();
                    if (FormApi.validatePreAssignmentParams(preAssignmentField, preAssignmentValue, targetMaske, user)) {
                        validPreAssignmentParams.put(preAssignmentField.getName(), preAssignmentValue);
                    }
                }
            });
        }
        return validPreAssignmentParams;
    }

    public static boolean validatePreAssignmentParams(Field preAssignmentField, String preAssignmentValue, Maske targetMaske, SxUser user) {
        Field targetField = FormApi.getTargetField(preAssignmentField, targetMaske, user);
        if (targetField != null && targetField.getFieldType() == preAssignmentField.getFieldType() && !targetField.isHidden() && !targetField.getName().equals(TABLESTYLESHEET)) {
            List<String> values;
            FieldType targetFieldType = targetField.getFieldType();
            if (targetFieldType != FieldType.Select && targetFieldType != FieldType.MultiSelect && targetFieldType != FieldType.TreeSelect && targetFieldType != FieldType.RadioButton) {
                return true;
            }
            List<Object> targetItemList = null;
            if (targetFieldType == FieldType.TreeSelect) {
                String[] viewParams = HisDynamicTreeSelectConfigurator.getSplittedViewParams(preAssignmentValue);
                preAssignmentValue = viewParams[2];
                targetItemList = FormApi.createItemsOfView(targetField, targetMaske, viewParams);
                if (preAssignmentValue.equals("") && !targetItemList.isEmpty()) {
                    return true;
                }
            } else {
                List<Item> targetItems = FormApi.createSelectableItems(targetField);
                targetItemList = targetItems.stream().map(e -> e.value).collect(Collectors.toList());
            }
            if (targetItemList.containsAll(values = FormApi.getSeperatedValues(targetFieldType, preAssignmentValue))) {
                return true;
            }
            logger.debug((Object)("Wert(e) " + String.valueOf(values) + " nicht in der Auswahl des Zielfeldes \"" + targetField.getName() + "\" enthalten, oder Auswahlliste ist leer."));
        }
        return false;
    }

    private static Field getTargetField(Field preAssignmentField, Maske targetMaske, SxUser user) {
        Field targetField = null;
        try {
            targetField = (Field)targetMaske.getIndividualFields().getByName(preAssignmentField.getName());
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)("Feld \"" + preAssignmentField.getName() + "\" aus der Vorbelegung nicht in Zielmaske enthalten."));
        }
        try {
            if (targetField != null) {
                targetField.initIfNeeded(targetMaske.getFormularCopy(), null, targetMaske.getIndividualFields(), user);
            }
        }
        catch (KeyParentEqualException | NoMainEntryException | DBServletException | SichtException | TemplateException | IOException | CloneNotSupportedException | SQLException e) {
            e.printStackTrace();
        }
        return targetField;
    }

    private static List<String> getSeperatedValues(FieldType targetFieldType, String preAssignmentValue) {
        if (targetFieldType == FieldType.MultiSelect || targetFieldType == FieldType.TreeSelect) {
            return Arrays.asList(preAssignmentValue.split(","));
        }
        return Arrays.asList(preAssignmentValue);
    }

    private static List<String> createItemsOfView(Field field, Maske maske, String[] viewParams) {
        List<String> targetItems = new ArrayList<String>();
        try {
            SelectableItemTree targetItemTree = Report.getSelectableItemTree(Integer.parseInt(viewParams[0]), viewParams[1], maske, field);
            String keysWithAppendices = TreeUtils.getSubordinateKeyList(targetItemTree.getRoot(), true, true);
            keysWithAppendices = keysWithAppendices.replace("'", "");
            String[] keyList = keysWithAppendices.split(",");
            targetItems = Arrays.asList(keyList);
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)("Sicht aus \"" + field.getName() + "\" konnte nicht in Sichtgruppe gefunden werden."));
        }
        catch (KeyParentEqualException | NoMainEntryException | DBServletException | TemplateException | IOException | CloneNotSupportedException | SQLException e) {
            e.printStackTrace();
        }
        return targetItems;
    }

    private static boolean evaluateSkipCondition(Field field) {
        boolean result;
        boolean bl = result = field.getName().equals("Ausgabeformat") || field.getName().equals(TABLESTYLESHEET) || field.isHidden() || field.getArt() == Field.Art.id_18_Link_auf_weitere_Einstellungen;
        if (result) {
            logger.debug((Object)("Skip field " + field.getName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, path={"/{tid}/inputupdate"})
    public Form updateSelektionsparameterConfig(@PathVariable(value="tid") int tid, @RequestBody Map<String, String> params, HttpServletRequest request) throws SQLException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, KeyParentEqualException, NoMainEntryException, ParseException, TemplateException, CloneNotSupportedException, IOException, DBServletException, TransformerException, InvalidKeyException, NotYetImplementedException {
        logger.debug((Object)"*** INPUTUPDATE ***");
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Maske maske = FormApi.initMaske(tid, request, user);
            Form result = new Form();
            HttpServletRequest wrappedRequest = RequestWrapper.wrapHttpServletRequest(params, request, maske.getIndividualFields());
            HisDynamicFieldConfig updatedConfiguration = FormApi.createUpdatedMaskConfig(maske, wrappedRequest, user);
            result.stylesheets.stylesheets = maske.getTableStylesheetsForNg();
            result.stylesheets.selectedStylesheet = maske.getDefaultStylesheetForNg();
            result.tid = tid;
            result.dynamicFieldConfig = updatedConfiguration;
            return result;
        }
    }

    private static HisDynamicFieldConfig createUpdatedMaskConfig(Maske maske, HttpServletRequest request, SxUser user) throws TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException, UngueltigeEingabeException, InvalidDataTypeException, NotYetImplementedException {
        HisDynamicFieldConfig updatedConfiguration = new HisDynamicFieldConfig("form", FieldType.Form);
        String triggeringField = request.getParameter(TRIGGERING_FIELD);
        if (FormApi.shouldCreateUpdate(maske, triggeringField)) {
            FieldContainer fields = maske.getIndividualFields();
            logger.debug((Object)"*** CREATE UPDATED MASK CONFIG");
            for (Field field : fields) {
                logger.debug((Object)("**** Field: " + field.getName()));
                String currentSelection = FormApi.retrieveSelectionFromRequest(field, request);
                logger.debug((Object)("**** Current Selection: " + currentSelection));
                HisDynamicFieldConfig config = FormApi.processFieldConfigUpdate(currentSelection, user, maske, field);
                if (config == null || field.getName().equals(triggeringField) || FormApi.evaluateSkipCondition(field)) continue;
                logger.debug((Object)("**** Default: " + (config.defaultValue != null ? config.defaultValue.toString() : "null")));
                logger.debug((Object)"**** Adding to configuration");
                updatedConfiguration.children.add(config);
            }
        }
        return updatedConfiguration;
    }

    private static boolean shouldCreateUpdate(Maske maske, String triggeringField) {
        boolean result = false;
        if (triggeringField.equalsIgnoreCase(TABLESTYLESHEET)) {
            if (FormApi.hasTableStylesheet(maske)) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static boolean hasTableStylesheet(Maske maske) {
        FieldContainer fields = maske.getIndividualFields();
        boolean result = false;
        for (Field field : fields) {
            if (!field.getName().equalsIgnoreCase(TABLESTYLESHEET)) continue;
            result = true;
        }
        return result;
    }

    private static String retrieveSelectionFromRequest(Field field, HttpServletRequest request) {
        String name = field.getName();
        String currentSelection = request.getParameter(name);
        return currentSelection;
    }

    private static HisDynamicFieldConfig processFieldConfigUpdate(String currentSelection, SxUser user, Maske maske, Field field) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException, NotYetImplementedException {
        String name = field.getName();
        HisDynamicFieldConfigurator configurator = FormApi.createConfigurator(maske, field, user);
        if (configurator == null) {
            logger.debug((Object)"NO CONFIGURATOR!");
            return null;
        }
        FieldContainer maskenFelder = maske.getIndividualFields();
        maskenFelder.getFormular().put(name, configurator.escapeForFormular(currentSelection));
        HisDynamicFieldConfig config = configurator.createConfig(currentSelection);
        maskenFelder.getFormular().put(name, configurator.getUpdatedFormularValue());
        return config;
    }

    private static HisDynamicFieldConfigurator createConfigurator(Maske maske, Field field, SxUser user) throws NotYetImplementedException {
        FieldType fieldType = FieldType.getCorrectedFieldType(field);
        switch (fieldType) {
            case MultiSelect: {
                return new HisDynamicMultiSelectConfigurator(maske, field, user);
            }
            case Select: {
                return new HisDynamicSelectConfigurator(maske, field, user);
            }
            case TreeSelect: {
                return new HisDynamicTreeSelectConfigurator(maske, field, user);
            }
        }
        return null;
    }

    private static List<Item> createSelectableItems(Field field) {
        ArrayList<Item> items = new ArrayList<Item>();
        TreeModel model = field.getSelectableItemsTree().getModel();
        SelectableItemNode root = (SelectableItemNode)model.getRoot();
        for (int i = 0; i < model.getChildCount(root); ++i) {
            SelectableItemNode node = (SelectableItemNode)model.getChild(root, i);
            SelectableItem item = (SelectableItem)node.getUserObject();
            String value = (String)item.getId();
            String label = item.getName();
            if (label.toLowerCase().contentEquals("alle")) {
                label = LABEL_TEXT_ALLE;
            }
            if (!label.isEmpty()) {
                items.add(new Item(label, value));
                continue;
            }
            if (FieldType.getCorrectedFieldType(field) == FieldType.MultiSelect || field.isObligatorisch()) continue;
            items.add(new Item(label, value));
        }
        return items;
    }

    private static List<Item> createTreeNodeSelectableItems(Field field) {
        Collection<SelectableItemNode> col = field.getSelectableItemsTree().getElements(1, false);
        SelectableItemNode root = field.getSelectableItemsTree().getRoot();
        ArrayList<Item> items = new ArrayList<Item>();
        if (root != null && root.getChildCount() > 0) {
            for (SelectableItemNode node : col) {
                SelectableItem item = (SelectableItem)node.getUserObject();
                if (item.getName().isEmpty()) continue;
                items.add(new Item(item.getName(), (String)item.getId()));
            }
            return items;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, path={"/{tid}/preassignement"})
    public boolean setPreAssignment(@PathVariable(value="tid") int tid, @RequestBody Map<String, String> params, HttpServletRequest request) {
        logger.debug((Object)"*** Set preassignment ***");
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Map<Integer, String> felder = this.getFelderOfPreAssignment(tid, params);
            request.getSession().setAttribute(this.getPreAssignmentSachgebietId(tid) + PREASSIGNMENT, felder);
            return true;
        }
    }

    public Map<Integer, String> getFelderOfPreAssignment(int maskentid, final Map<String, String> params) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Map felder = (Map)jdbcTemplate.query(Maske.QUERY_FELDER_OF_MASKE, new Object[]{maskentid}, (ResultSetExtractor)new ResultSetExtractor<Map<Integer, String>>(){

            public Map<Integer, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
                while (rs.next()) {
                    int key = rs.getInt("felderinfo_id");
                    String name = rs.getString("name");
                    if (!params.containsKey(name)) continue;
                    resultMap.put(key, (String)params.get(name));
                }
                return resultMap;
            }
        });
        return felder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.DELETE}, path={"/{tid}/preassignement"})
    public boolean removePreAssignment(@PathVariable(value="tid") int tid, HttpServletRequest request) {
        logger.debug((Object)"*** Remove preassignment ***");
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            request.getSession().removeAttribute(this.getPreAssignmentSachgebietId(tid) + PREASSIGNMENT);
            return true;
        }
    }

    public String getPreAssignmentSachgebietId(int tid) {
        String sachgebietId = "";
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Optional<Konstante> preAssignmentConfig = this.konstanteRepository.findByBeschreibung("VORBELEGUNG_BERICHTE");
        if (preAssignmentConfig.isPresent() && preAssignmentConfig.get().apnr == 1) {
            sachgebietId = Integer.toString((Integer)jdbcTemplate.queryForObject(Maske.QUERY_SACHGEBIET_TID, new Object[]{tid}, Integer.class));
        }
        return sachgebietId;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

