/*
 * Decompiled with CFR 0.152.
 */
package de.superx.job;

import de.superx.etl.biad.SourceTable;
import de.superx.job.ActionNode;
import java.io.File;
import java.util.List;

public class ExtractAction
extends ActionNode {
    public String unlFile;
    public String stagingSchema;
    public String sourceTable;
    public String stagingTable;
    public String extractionScript;
    public List<String> extractionInclude;
    public String dataSource;

    public ExtractAction(String id, String table, String extractionScript, List<String> extractionInclude, String stagingSchema, String unlFile, String dataSource, Integer systemInfoId, String mod) {
        super(ExtractAction.makeName(id, unlFile, dataSource), null, systemInfoId, true, ActionNode.ActionType.EXTRACT);
        this.sourceTable = table;
        this.extractionScript = extractionScript == null || extractionScript.isBlank() ? "1=1" : extractionScript;
        this.extractionInclude = extractionInclude;
        this.stagingSchema = stagingSchema.isBlank() ? "public" : stagingSchema;
        this.stagingTable = String.format("%s", table);
        this.unlFile = unlFile;
        this.dataSource = dataSource;
    }

    public ExtractAction(String table, List<String> extractionInclude) {
        this.sourceTable = table;
        this.extractionInclude = extractionInclude;
    }

    public ExtractAction() {
    }

    public static ExtractAction createFromSourceTable(SourceTable table, String unlFile, String schema) {
        return new ExtractAction(table.getName(), table.getName(), table.getExtractionScript(), table.getExtractionInclude(), schema, unlFile, "hisinone", 440, null);
    }

    private static String makeName(String id, String unlFile, String dataSource) {
        String name = "Extract " + id + " " + unlFile.substring(unlFile.lastIndexOf(File.separatorChar) + 1);
        if (dataSource != null && !dataSource.isEmpty()) {
            name = name + " (" + dataSource + ")";
        }
        return name;
    }
}

