/*
 * Decompiled with CFR 0.152.
 */
package de.superx.jdbc.entity;

import com.google.common.base.CaseFormat;
import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.model.ColumnMetaData;
import de.superx.jdbc.model.EntityDescriptor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.relational.core.mapping.Table;

public abstract class EntityBase
implements Entity {
    @Transient
    private Map<String, ColumnMetaData> columnMetadata = new HashMap<String, ColumnMetaData>();

    private void setColumnMetadata(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try (ResultSet columns = databaseMetaData.getColumns(null, null, this.getTableName(), null);){
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                String datatype = columns.getString("DATA_TYPE");
                String isNullable = columns.getString("IS_NULLABLE");
                ColumnMetaData metaDataElement = new ColumnMetaData(datatype, isNullable);
                this.columnMetadata.put(columnName, metaDataElement);
            }
        }
    }

    @Override
    public boolean isFieldRequired(Field field, DataSource datasource) throws SQLException {
        String fieldNameSnake;
        ColumnMetaData metaData;
        if (field.isAnnotationPresent(Id.class)) {
            return false;
        }
        if (this.columnMetadata.isEmpty()) {
            try (Connection connection = datasource.getConnection();){
                this.setColumnMetadata(connection);
            }
        }
        if ((metaData = this.columnMetadata.get(fieldNameSnake = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName()))) != null) {
            return !metaData.isNullable();
        }
        return false;
    }

    private String getTableName() {
        Table annotation = this.getClass().getAnnotation(Table.class);
        if (annotation != null) {
            return annotation.value();
        }
        return "";
    }

    @Override
    public String getIdColumnName() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            return field.getName();
        }
        return "";
    }

    @Override
    public String getDescriptorColumnName() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(EntityDescriptor.class)) continue;
            return field.getName();
        }
        return this.getIdColumnName();
    }
}

