/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.db.RestrictionCollector;
import de.memtext.time.Period;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SxResultRow;
import de.superx.common.SxUser;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SxFinRechte
extends LinkedList
implements TemplateHashModel,
TemplateMethodModel {
    public static final int NO_RIGHTS = 0;
    public static final int SIMPLE_RIGHTS = 1;
    public static final int EXTENDED_RIGHTS = 2;
    public static final int INS3_RIGHTS = 3;
    private static final long serialVersionUID = 1L;
    private boolean hasAllRights = false;
    private boolean is0FINJoker;
    private LinkedList allowedProjToInst = new LinkedList();
    private int rightvariant = 1;
    private HashMap repository;

    public void setVariant(int rightvariant) {
        this.rightvariant = rightvariant;
    }

    public void setHasAllRights(boolean hasAllRights) {
        this.hasAllRights = hasAllRights;
    }

    public boolean hasKostenstellenStandardEntry(Date date) {
        boolean result = false;
        for (FinRecht k : this) {
            if (!k.isKostenstellenStandardRechte() || !k.isInPeriod(date)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasKostenstellenNonStandardEntry(Date date) {
        boolean result = false;
        for (FinRecht k : this) {
            if (k.isKostenstellenStandardRechte() || !k.isInPeriod(date)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Iterator kostenstellenStandardIterator(Date date) {
        LinkedList<FinRecht> l = new LinkedList<FinRecht>();
        for (FinRecht k : this) {
            if (!k.isKostenstellenStandardRechte() || !k.isInPeriod(date)) continue;
            l.add(k);
        }
        return l.iterator();
    }

    public Iterator kostenstellenNonStandardIterator(Date date) {
        LinkedList<FinRecht> l = new LinkedList<FinRecht>();
        for (FinRecht k : this) {
            if (k.isKostenstellenStandardRechte() || !k.isInPeriod(date)) continue;
            l.add(k);
        }
        return l.iterator();
    }

    public Object exec(List l) throws TemplateModelException {
        String param3;
        if (!this.hasAllRights && this.size() == 0) {
            throw new TemplateModelException("Keine kameralen Rechte definiert f\u00fcr diesen Benutzer");
        }
        if (l == null || l.size() == 0 || !(l.get(0) instanceof String)) {
            throw new TemplateModelException("Keine Kostenstellen-SQL \u00fcbergeben");
        }
        String request = (String)l.get(0);
        Date d = null;
        try {
            d = DateUtils.parse((String)l.get(1));
        }
        catch (Exception e) {
            d = new Date();
        }
        boolean isRestrictBuchungen = false;
        if (l.size() == 3 && (param3 = l.get(2).toString()) != null && param3.indexOf("restrict_buchungen") > -1) {
            isRestrictBuchungen = true;
        }
        StringBuffer result = new StringBuffer("");
        if (request.equalsIgnoreCase("kapitel")) {
            this.addKapitelRecht(d, result);
        } else if (request.equalsIgnoreCase("dr")) {
            this.addDrRecht(d, l, result);
        } else if (request.equalsIgnoreCase("titel")) {
            this.addTitelRecht(d, l, result);
        } else if (request.equalsIgnoreCase("untertitel")) {
            this.addUntertitelRecht(d, l, result);
        } else if (request.equalsIgnoreCase("k1")) {
            this.addK1Recht(d, l, result);
        } else if (request.equalsIgnoreCase("k2")) {
            this.addK2Recht(d, l, result);
        } else if (request.equalsIgnoreCase("k3")) {
            this.addK3Recht(d, l, result);
        } else if (request.equalsIgnoreCase("k4")) {
            this.addK4Recht(d, l, result);
        } else {
            this.addMaskenRecht(request, d, isRestrictBuchungen, result);
        }
        return result.toString();
    }

    private void adapt(List l, int i, String varname) {
        if (l.size() > i) {
            String x = (String)l.get(i);
            if (x != null && x.equals(varname)) {
                x = "";
                l.set(i, "");
            }
            if (x != null && x.indexOf("<<") > -1) {
                throw new IllegalArgumentException("Es sollte kein Tag mehr vorhanden sein (" + x + ")");
            }
        }
    }

    private void addK2Recht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() != 7) {
            throw new TemplateModelException("7 Parameter f\u00fcr K2-Rechte ben\u00f6tigt");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights() && fr.isDrAllRights() && fr.isTitelAllRights() && fr.isUtAllRights() && fr.isK1AllRights() && fr.isK2AllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getK2SQL() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle K2\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addK3Recht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() != 7) {
            throw new TemplateModelException("7 Parameter f\u00fcr K3-Rechte ben\u00f6tigt");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights() && fr.isDrAllRights() && fr.isTitelAllRights() && fr.isUtAllRights() && fr.isK1AllRights() && fr.isK2AllRights() && fr.isK3AllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getK3SQL() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle K3\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addK4Recht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() != 7) {
            throw new TemplateModelException("7 Parameter f\u00fcr K4-Rechte ben\u00f6tigt");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights() && fr.isDrAllRights() && fr.isTitelAllRights() && fr.isUtAllRights() && fr.isK1AllRights() && fr.isK2AllRights() && fr.isK3AllRights() && fr.isK4AllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getK4SQL() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle K4\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addK1Recht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() < 6) {
            throw new TemplateModelException("6 Parameter f\u00fcr K1-Rechte erwartet");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights() && fr.isDrAllRights() && fr.isTitelAllRights() && fr.isUtAllRights() && fr.isK1AllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getK1SQL() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle BA/FB\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addUntertitelRecht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() < 5) {
            throw new TemplateModelException("zu wenig Parameter f\u00fcr Untertitel-Rechte");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights() && fr.isDrAllRights() && fr.isTitelAllRights() && fr.isUtAllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getUntertitelSQL() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle Untertitel\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addTitelRecht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() < 4) {
            throw new TemplateModelException("zu wenig Parameter f\u00fcr Titel-Rechte");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isK1AllRights() && fr.isDrAllRights() && fr.isTitelAllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getTitelSql() + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle Titel\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addKapitelRecht(Date d, StringBuffer result) {
        TreeSet<String> kaps = new TreeSet<String>();
        boolean seeAll = false;
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isKapitelAllRights()) {
                seeAll = true;
                break;
            }
            kaps.add(fr.getKapitel());
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle Kapitel\n");
        } else if (kaps.size() == 0) {
            result.append("1=0 --keine Kapitelrechte\n");
        } else {
            result.append(" kapitel in (");
            Iterator it = kaps.iterator();
            while (it.hasNext()) {
                String kap = (String)it.next();
                result.append("'" + kap + "'");
                if (it.hasNext()) {
                    result.append(",");
                    continue;
                }
                result.append(") ");
            }
        }
    }

    static String adaptNegTitelString(String t, Collection titels) {
        if (t.startsWith("-")) {
            t = t.substring(1);
        }
        if (titels == null) {
            titels = new LinkedList();
        }
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(t, ",");
        boolean isFirst = true;
        while (st.hasMoreTokens()) {
            boolean posOverride = false;
            String negtit = st.nextToken();
            if (negtit.startsWith("-")) {
                negtit = negtit.substring(1);
            }
            for (String tit : titels) {
                if (tit.startsWith("-") || tit.indexOf(negtit) <= -1) continue;
                posOverride = true;
            }
            if (posOverride) continue;
            if (!isFirst) {
                result.append(",");
            }
            result.append("'" + negtit + "'");
            isFirst = false;
        }
        return result.toString();
    }

    private void addDrRecht(Date d, List l, StringBuffer result) throws TemplateModelException {
        if (l.size() < 3) {
            throw new TemplateModelException("zu wenig Parameter f\u00fcr Dr-Rechte");
        }
        boolean seeAll = false;
        RestrictionCollector rest = new RestrictionCollector();
        for (FinRecht fr : this) {
            if (!fr.isInPeriod(d)) continue;
            if (fr.isK1AllRights() && fr.isDrAllRights()) {
                seeAll = true;
                continue;
            }
            rest.addOrRestriction("(" + fr.getDrSql(false) + ")");
        }
        if (this.hasAllRights || seeAll) {
            result.append("1=1 --alle Dr\n");
        } else {
            result.append(" (" + rest.toString() + ")\n");
        }
    }

    private void addMaskenRecht(String kostenstellenSQL, Date d, boolean isRestrictBuchungen, StringBuffer result) {
        if (this.hasAllRights) {
            result.append("1=1 --keine FIN-Usereinschr\u00e4nkung\n");
        } else {
            if (this.size() == 0) {
                result.append("1=0 -- keine FIN-Userrechte definiert\n");
            }
            if (this.hasKostenstellenStandardEntry(d) && this.hasKostenstellenNonStandardEntry(d)) {
                result.append("(");
            }
            if (this.hasKostenstellenStandardEntry(d)) {
                this.addKostenstellenStandardEntries(d, kostenstellenSQL, isRestrictBuchungen, result);
            }
            if (this.hasKostenstellenStandardEntry(d) && this.hasKostenstellenNonStandardEntry(d)) {
                result.append(" or ");
            }
            if (this.hasKostenstellenNonStandardEntry(d)) {
                this.addKostenstellenNonStandardEntries(d, isRestrictBuchungen, result);
            }
            if (this.hasKostenstellenStandardEntry(d) && this.hasKostenstellenNonStandardEntry(d)) {
                result.append("\n)");
            }
        }
    }

    private void addKostenstellenNonStandardEntries(Date date, boolean isRestrictBuchungen, StringBuffer result) {
        result.append(" ( ");
        Iterator it = this.kostenstellenNonStandardIterator(date);
        while (it.hasNext()) {
            FinRecht kr = (FinRecht)it.next();
            result.append(kr.toSQL(isRestrictBuchungen));
            if (!it.hasNext()) continue;
            result.append(" or ");
        }
        result.append(" ) ");
    }

    private void addKostenstellenStandardEntries(Date date, String kostenstellenSQL, boolean isRestrictBuchungen, StringBuffer result) {
        result.append("\n -- mit Standardkostenstellen-Einschr\u00e4nkung");
        result.append("\n((");
        Iterator it = this.kostenstellenStandardIterator(date);
        while (it.hasNext()) {
            FinRecht kr = (FinRecht)it.next();
            result.append(kr.toSQL(isRestrictBuchungen));
            if (!it.hasNext()) continue;
            result.append(" or ");
        }
        result.append(")\n and " + kostenstellenSQL + " )\n");
    }

    public static String getReadingSqlUserKam(SxUser user) {
        return "select distinct kapitel,dr,titel,untertitel,nvl(buchungsab_fb,'-1'::char),nvl(projnr_ins,'-1'::char),'-1','-1',kostenstellen,null::date as gueltig_von,null::date as gueltig_bis from fin_user_kam where userid=" + String.valueOf(user.getId()) + " and (gueltig_von is null or gueltig_von<=today()) and (gueltig_bis is null or gueltig_bis>=today())";
    }

    public static String getReadingSqlUserKamIns3(SxUser user, boolean hasFinUserKamRestrictionFields) {
        String restriction_fields = ",null::varchar(1) as restrict_konten,null::varchar(1) as restrict_buchungen";
        if (hasFinUserKamRestrictionFields) {
            restriction_fields = ",restrict_konten,restrict_buchungen";
        }
        return "select distinct kapitel,dr,titel,untertitel,nvl(buchungsab_fb,'-1'::char),nvl(projnr_ins,'-1'::char),nvl(ins2,'-1'::char),nvl(ins3,'-1'::char),kostenstellen,null::date as gueltig_von,null::date as gueltig_bis" + restriction_fields + " from fin_user_kam where userid=" + String.valueOf(user.getId()) + " and (gueltig_von is null or gueltig_von<=today()) and (gueltig_bis is null or gueltig_bis>=today())";
    }

    public static String getReadingSqlProjToInst(String databaseAbbr, SxUser user) {
        Object result = "";
        result = databaseAbbr.equals("PG") ? (String)result + "select sp_user_orga(" + String.valueOf(user.getId()) + ",today(),0);" : (String)result + "execute procedure sp_user_orga(" + String.valueOf(user.getId()) + ",today(),0);";
        result = (String)result + "select distinct projnr from fin_proj_to_inst where inst_nr in (select key_apnr from tmp_organigramm where erlaubt=1) and haupt_kst_kz='1';";
        result = (String)result + " \tdrop table tmp_organigramm;";
        return result;
    }

    public void createAndAddEntry(SxResultRow row) {
        Date d = null;
        Date d2 = null;
        if (row.get(7) instanceof Date) {
            d = (Date)row.get(7);
        }
        if (row.get(8) instanceof Date) {
            d2 = (Date)row.get(8);
        }
        FinRecht kr = new FinRecht(d, d2, this.rightvariant);
        kr.setKapitel((String)row.get(0));
        kr.setDr((String)row.get(1));
        kr.setTitel((String)row.get(2));
        kr.setUntertitel((String)row.get(3));
        kr.setK1((String)row.get(4));
        kr.setK2((String)row.get(5));
        String k = (String)row.get(6);
        kr.setK3(k);
        k = (String)row.get(7);
        kr.setK4(k);
        kr.setKostenstellen((String)row.get(8));
        if (row.size() > 10) {
            kr.setRestrictKonten((String)row.get(11));
            kr.setRestrictBuchungen((String)row.get(12));
        }
        this.add(kr);
    }

    public void initFak33() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00033");
        k1.setKostenstellen("-2");
        this.add(k1);
    }

    public void initFak32Test() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("32");
        this.add(k1);
        FinRecht k2 = new FinRecht(null, null, 2);
        k2.setKapitel("13");
        k2.setKostenstellen("-2");
        this.add(k2);
        FinRecht k3 = new FinRecht(DateUtils.create("1.1.2007"), null, 2);
        k3.setKapitel("60");
        k3.setKostenstellen("-2");
        this.add(k3);
    }

    public void initMegaTester() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("13");
        k1.setDr("92");
        this.add(k1);
        FinRecht k2 = new FinRecht(null, null, 2);
        k2.setKapitel("60");
        this.add(k2);
        k2 = new FinRecht(null, null, 2);
        k2.setKapitel("00010");
        k2.setDr("10");
        k2.setTitel("10000");
        this.add(k2);
    }

    void initUntertitelTester() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setTitel("10000");
        k1.setUntertitel("1");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setTitel("10000");
        k1.setUntertitel("2");
        this.add(k1);
    }

    void initDrittTest() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setDr("92");
        this.add(k1);
    }

    public void x1testGenerate() throws TemplateModelException {
        SxFinRechte l = new SxFinRechte();
        l.setVariant(2);
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("32");
        l.add(k1);
        LinkedList<String> list = new LinkedList<String>();
        list.add(" ch110_institut in (1,11,12)");
        System.out.println(l.exec(list));
    }

    public void initFbTest() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setK1("1001");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setK1("1002");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00090");
        k1.setDr("92");
        k1.setK1("1003");
        this.add(k1);
    }

    public void initK2Test() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setK1("1001");
        k1.setK2("1a");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setK1("1001");
        k1.setK2("1b");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setDr("92");
        k1.setK1("1002");
        k1.setK2("2");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00090");
        k1.setDr("92");
        k1.setK1("1003");
        k1.setK2("3");
        this.add(k1);
        k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00010");
        k1.setK1("1004");
        k1.setK2("4");
        this.add(k1);
    }

    public void initTitelverwTest() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setTitel("50900");
        this.add(k1);
    }

    public void initNegTitelTest() {
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00060");
        k1.setTitel("-42001,-42501");
        this.add(k1);
    }

    public void testGenerate() throws TemplateModelException {
        SxFinRechte l = new SxFinRechte();
        l.setVariant(2);
        FinRecht k1 = new FinRecht(null, null, 2);
        k1.setKapitel("00001");
        k1.setTitel("51900");
        l.add(k1);
        LinkedList<String> list = new LinkedList<String>();
        list.add(" ch110_institut in (1,11,12)");
        System.out.println(l.exec(list));
    }

    public static void main(String[] args) {
        SxFinRechte t = new SxFinRechte();
        t.setVariant(2);
    }

    public void set0FINJoker(boolean is0FINJoker) {
        this.is0FINJoker = is0FINJoker;
    }

    public void addProj(String proj) {
        if (proj != null) {
            this.allowedProjToInst.add(proj);
        }
    }

    public TemplateModel get(String key) throws TemplateModelException {
        StringBuffer b;
        if (key == null) {
            return null;
        }
        SimpleScalar result = null;
        if (key.equalsIgnoreCase("getProjektRights")) {
            if (this.hasAllRights) {
                result = new SimpleScalar("1=1 --keine Einschraenkung Projekte (proj_to_inst)\n");
            } else {
                b = new StringBuffer("buchungsab_fb in (");
                for (String proj : this.allowedProjToInst) {
                    b.append("'" + proj + "',");
                }
                StringUtils.removeLastChar(b);
                b.append(")");
                if (this.allowedProjToInst.size() == 0) {
                    b = new StringBuffer("KEINE RECHTE FUER PROJEKTE VIA PROJ_TO_INST");
                }
                result = new SimpleScalar(b.toString());
            }
        }
        if (key.equalsIgnoreCase("getProjektKeys")) {
            b = new StringBuffer("");
            for (String proj : this.allowedProjToInst) {
                b.append("'" + proj + "',");
            }
            if (this.allowedProjToInst.size() > 0) {
                StringUtils.removeLastChar(b);
            }
            if (!this.hasAllRights && this.allowedProjToInst.size() == 0) {
                b = new StringBuffer("KEINE RECHTE FUER PROJEKTE VIA PROJ_TO_INST");
            }
            result = new SimpleScalar(b.toString());
        }
        if (key.equalsIgnoreCase("hasAllRights")) {
            result = this.hasAllRights ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        return result;
    }

    public static String getReadingSqlUserKamSimple(SxUser user) {
        return "select distinct '-1','-1','-1','-1',nvl(buchungsab_fb,'-1'::char),nvl(projnr_ins,'-1'::char),'-1','-1','-1',null::date,null::date from fin_user_kam where userid=" + String.valueOf(user.getId());
    }

    public void setRepository(HashMap repository) {
        this.repository = repository;
    }

    private class FinRecht
    extends Period
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String kapitel;
        private String dr;
        private String titel;
        private String untertitel;
        private String k1;
        private String k2;
        private String k3;
        private String k4;
        private String kostenstellen;
        private int rightvariant;
        private String restrict_konten;
        private String restrict_buchungen;

        public FinRecht(Date from, Date till, int rightvariant) {
            super(from, till);
            this.kapitel = "-1";
            this.dr = "-1";
            this.titel = "-1";
            this.untertitel = "-1";
            this.k1 = "-1";
            this.k2 = "-1";
            this.k3 = "-1";
            this.k4 = "-1";
            this.kostenstellen = "-1";
            this.rightvariant = 1;
            this.restrict_konten = "";
            this.restrict_buchungen = "";
            try {
                if (from == null) {
                    this.setFrom(DateUtils.parse("1.1.1900"));
                }
                if (till == null) {
                    this.setTill(DateUtils.parse("1.1.3000"));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.rightvariant = rightvariant;
        }

        public void setRestrictKonten(String restrict_konten) {
            this.restrict_konten = restrict_konten;
        }

        public void setRestrictBuchungen(String restrict_buchungen) {
            this.restrict_buchungen = restrict_buchungen;
        }

        public boolean isK1Wanted(String kapstr, String drstr, String titelstr, String utstr, String k1str) {
            boolean result = false;
            result = k1str.trim().length() < 2 || this.isK1AllRights() ? true : this.getAdaptedStr(k1str).indexOf("'" + this.k1 + "'") > -1;
            return this.isKapitelWanted(kapstr) && this.isDrWanted(kapstr, drstr) && this.isTitelWanted(kapstr, drstr, titelstr) && this.isUntertitelWanted(kapstr, drstr, titelstr, utstr) && result;
        }

        public boolean isUntertitelWanted(String kapstr, String drstr, String titelstr, String utstr) {
            boolean result = false;
            result = utstr.trim().length() < 2 || this.isUtAllRights() ? true : this.getAdaptedStr(utstr).indexOf("'" + this.untertitel + "'") > -1;
            return this.isKapitelWanted(kapstr) && this.isDrWanted(kapstr, drstr) && this.isTitelWanted(kapstr, drstr, titelstr) && result;
        }

        public boolean isDrWanted(String kapstr, String drstr) {
            boolean result = false;
            result = drstr.trim().length() < 2 || this.isDrAllRights() ? true : this.getAdaptedStr(drstr).indexOf("'" + this.dr + "'") > -1;
            return this.isKapitelWanted(kapstr) && result;
        }

        public boolean isTitelWanted(String kapstr, String drstr, String titstr) {
            boolean result = false;
            result = titstr.trim().length() < 2 || this.isTitelAllRights() ? true : this.getAdaptedStr(titstr).indexOf("'" + this.titel + "'") > -1;
            return this.isKapitelWanted(kapstr) && this.isDrWanted(kapstr, drstr) && result;
        }

        public boolean isKapitelWanted(String kapstr) {
            boolean result = false;
            result = kapstr.trim().length() < 2 || this.isKapitelAllRights() ? true : this.getAdaptedStr(kapstr).indexOf("'" + this.kapitel + "'") > -1;
            return result;
        }

        private String getAdaptedStr(String str) {
            str = StringUtils.replace(str, "'", "");
            str = StringUtils.replace(str, ",", "|");
            StringTokenizer st = new StringTokenizer(str, "|");
            StringBuffer buf = new StringBuffer();
            while (st.hasMoreTokens()) {
                buf.append("'" + st.nextToken() + "',");
            }
            return buf.toString();
        }

        public String getKapitel() {
            return this.kapitel;
        }

        public boolean isKapitelAllRights() {
            return this.kapitel.equals("-1") || SxFinRechte.this.is0FINJoker && this.kapitel.equals("0");
        }

        public String getKapitelSql() {
            Object result = "";
            result = this.isKapitelAllRights() ? "kapitel!='-1'" : "kapitel='" + this.getKapitel() + "'";
            return result;
        }

        public void setKapitel(String kapitel) {
            if (kapitel == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (kapitel.trim().equals("")) {
                kapitel = "-1";
            }
            this.kapitel = kapitel.trim();
        }

        public String getDr() {
            return this.dr;
        }

        public boolean isDrAllRights() {
            return this.dr.equals("-1") || SxFinRechte.this.is0FINJoker && this.dr.equals("0");
        }

        public String getDrSql(boolean isDr2Wanted) {
            Object result = this.getKapitelSql();
            result = this.isDrAllRights() ? (String)result + " and dr!='-1'" : (isDr2Wanted ? (String)result + " and (dr='" + this.getDr() + "' or dr2='" + this.getDr() + "')" : (String)result + " and dr='" + this.getDr() + "'");
            return result;
        }

        public void setDr(String dr) {
            if (dr == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (dr.trim().equals("")) {
                dr = "-1";
            }
            this.dr = dr.trim();
        }

        public String getTitel() {
            return this.titel;
        }

        public boolean isTitelAllRights() {
            return this.titel.equals("-1") || SxFinRechte.this.is0FINJoker && this.titel.equals("0");
        }

        public void setTitel(String titel) {
            if (titel == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (titel.trim().equals("")) {
                titel = "-1";
            }
            this.titel = titel.trim();
            if (titel.indexOf(",") > -1 && !titel.startsWith("-")) {
                throw new IllegalArgumentException("Kommatrennung von Titeln nur bei Negativauswahl erlaubt (nicht :" + titel + ")");
            }
        }

        public String getTitelSql() {
            StringBuffer result = new StringBuffer(this.getDrSql(true));
            if (this.isTitelAllRights()) {
                result.append(" and titel!='-1'");
            } else if (!this.getTitel().startsWith("-")) {
                if (this.getTitel().indexOf("*") > -1 || this.getTitel().indexOf("%") > -1) {
                    result.append(" and titel like '" + StringUtils.replace(this.getTitel(), "*", "%") + "' ");
                } else {
                    result.append(" and titel='" + this.getTitel() + "'");
                }
            } else if (this.getTitel().indexOf("*") > -1) {
                String h = StringUtils.replace(this.getTitel().substring(1), "*", "%");
                result.append(" and titel not like '" + h + "' ");
            } else {
                StringTokenizer st = new StringTokenizer(this.getTitel(), ",");
                result.append(" and titel not in (");
                while (st.hasMoreTokens()) {
                    String negtit = st.nextToken();
                    if (negtit.startsWith("-")) {
                        negtit = negtit.substring(1);
                    }
                    result.append("'" + negtit + "',");
                }
                StringUtils.deleteLastChar(result);
                result.append(")");
            }
            return result.toString();
        }

        public String getUntertitel() {
            return this.untertitel;
        }

        public String getUntertitelSQL() {
            Object result = this.getTitelSql();
            result = this.isUtAllRights() ? (String)result + " and zweckbestimmung_ut!='-1'" : (this.getUntertitel().indexOf("*") > -1 ? (String)result + " and zweckbestimmung_ut like '" + StringUtils.replace(this.getUntertitel(), "*", "%") + "'" : (String)result + " and zweckbestimmung_ut='" + this.getUntertitel() + "'");
            return result;
        }

        public void setUntertitel(String untertitel) {
            if (untertitel == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (untertitel.trim().equals("")) {
                untertitel = "-1";
            }
            this.untertitel = untertitel.trim();
        }

        public String getK1() {
            return this.k1;
        }

        public boolean isK1AllRights() {
            return this.getK1().equals("-1") || SxFinRechte.this.is0FINJoker && this.getK1().equals("0");
        }

        public boolean isUtAllRights() {
            return this.getUntertitel().equals("-1") || SxFinRechte.this.is0FINJoker && this.getUntertitel().equals("0");
        }

        public String getK1SQL() {
            Object result = this.getUntertitelSQL();
            result = this.isK1AllRights() ? (String)result + " and buchungsab_fb!='-1'" : (this.k1.indexOf("*") > -1 ? (String)result + " and buchungsab_fb like '" + StringUtils.replace(this.getK1(), "*", "%") + "'" : (String)result + " and buchungsab_fb='" + this.getK1() + "'");
            return result;
        }

        public void setK1(String k1) {
            if (k1 == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (k1.trim().equals("")) {
                k1 = "-1";
            }
            this.k1 = k1.trim();
        }

        public String getK2() {
            return this.k2;
        }

        public String getK3() {
            return this.k3;
        }

        public String getK4() {
            return this.k4;
        }

        public boolean isK2AllRights() {
            return this.getK2().equals("-1") || SxFinRechte.this.is0FINJoker && this.getK2().equals("0");
        }

        public boolean isK3AllRights() {
            return this.getK3().equals("-1") || SxFinRechte.this.is0FINJoker && this.getK3().equals("0");
        }

        public boolean isK4AllRights() {
            return this.getK4().equals("-1") || SxFinRechte.this.is0FINJoker && this.getK4().equals("0");
        }

        public String getK2SQL() {
            StringBuffer result = new StringBuffer(this.getK1SQL());
            if (this.isK2AllRights()) {
                result.append(" and projnr_ins!='-1'");
            } else {
                StringTokenizer st = new StringTokenizer(this.getK2(), ",");
                result.append(" and (");
                while (st.hasMoreTokens()) {
                    String k2 = st.nextToken();
                    if (k2.indexOf("*") > -1) {
                        result.append("projnr_ins like '" + StringUtils.replace(k2, "*", "%") + "'");
                    } else {
                        result.append("projnr_ins='" + k2 + "'");
                    }
                    result.append(" or");
                }
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                result.append(")");
            }
            return result.toString();
        }

        public String getK3SQL() {
            StringBuffer result = new StringBuffer(this.getK2SQL());
            if (this.isK3AllRights()) {
                result.append(" and ins2!='-1'");
            } else {
                StringTokenizer st = new StringTokenizer(this.getK3(), ",");
                result.append(" and (");
                while (st.hasMoreTokens()) {
                    String k3 = st.nextToken();
                    if (k3.indexOf("*") > -1) {
                        result.append("ins2 like '" + StringUtils.replace(k3, "*", "%") + "'");
                    } else {
                        result.append("ins2='" + k3 + "'");
                    }
                    result.append(" or");
                }
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                result.append(")");
            }
            return result.toString();
        }

        public String getK4SQL() {
            StringBuffer result = new StringBuffer(this.getK3SQL());
            if (this.isK4AllRights()) {
                result.append(" and ins3!='-1'");
            } else {
                StringTokenizer st = new StringTokenizer(this.getK4(), ",");
                result.append(" and (");
                while (st.hasMoreTokens()) {
                    String k4 = st.nextToken();
                    if (k4.indexOf("*") > -1) {
                        result.append("ins3 like '" + StringUtils.replace(k4, "*", "%") + "'");
                    } else {
                        result.append("ins3='" + k4 + "'");
                    }
                    result.append(" or");
                }
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                StringUtils.deleteLastChar(result);
                result.append(")");
            }
            return result.toString();
        }

        public void setK2(String k2) {
            if (k2 == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (k2.trim().equals("")) {
                k2 = "-1";
            }
            this.k2 = k2.trim();
        }

        public void setK3(String k3) {
            if (k3 == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (k3.trim().equals("")) {
                k3 = "-1";
            }
            this.k3 = k3.trim();
        }

        public void setK4(String k4) {
            if (k4 == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            if (k4.trim().equals("")) {
                k4 = "-1";
            }
            this.k4 = k4.trim();
        }

        public String getKostenstellen() {
            return this.kostenstellen;
        }

        public void setKostenstellen(String kostenstellen) {
            if (kostenstellen == null) {
                throw new IllegalArgumentException("null nicht erlaubt");
            }
            this.kostenstellen = kostenstellen.trim();
            if (!this.kostenstellen.equals("-1") && !this.kostenstellen.equals("-2")) {
                throw new IllegalArgumentException("bisher nur -1 und -2 implementiert");
            }
        }

        public boolean isKostenstellenStandardRechte() {
            return EqualsUtil.areEqual(this.kostenstellen, "-2");
        }

        @Override
        public String toString() {
            return "k" + this.kapitel + "dr" + this.dr + "t" + this.titel + "ut" + this.untertitel + "k1:" + this.k1 + "k2:" + this.k2 + "k3:" + this.k3 + "k4:" + this.k4;
        }

        public boolean hasNegativeTitel() {
            return this.getTitel().startsWith("-") && !this.getTitel().equals("-1");
        }

        String toSQL(boolean isRestrictBuchungen) {
            RepositoryItemCollection ric;
            String add;
            StringBuffer r = new StringBuffer("");
            r.append("(");
            if (this.dr.equals("-1") || this.dr.equals("0")) {
                r.append("kaminfo like '%");
                this.addKapitel(r);
                r.append("dr%dr2:%");
                this.addTitelUtK1K2K3K4(r);
            } else {
                r.append("(");
                r.append("kaminfo like '%");
                this.addKapitel(r);
                r.append("dr" + this.dr + "dr2:%");
                this.addTitelUtK1K2K3K4(r);
                r.append("or kaminfo like '%");
                this.addKapitel(r);
                r.append("dr%dr2:" + this.dr);
                this.addTitelUtK1K2K3K4(r);
                r.append(")");
            }
            if (this.hasNegativeTitel()) {
                if (this.getTitel().indexOf("*") > -1) {
                    String h = StringUtils.replace(this.getTitel(), "-", "");
                    h = StringUtils.replace(h, "*", "%");
                    r.append(" and titel not like '" + h + "' ");
                } else {
                    r.append(" and titel not in (" + SxFinRechte.adaptNegTitelString(this.getTitel(), null) + ") ");
                }
            }
            if (!this.restrict_konten.equals("")) {
                add = "";
                if (!SxFinRechte.this.repository.containsKey(this.restrict_konten)) {
                    throw new IllegalArgumentException("Einschr\u00e4nkung mit ID " + this.restrict_konten + " nicht in Sx_repository definiert!");
                }
                ric = (RepositoryItemCollection)SxFinRechte.this.repository.get(this.restrict_konten);
                add = ric.getContent();
                r.append(" " + add + " ");
            }
            if (isRestrictBuchungen && !this.restrict_buchungen.equals("")) {
                add = "";
                if (!SxFinRechte.this.repository.containsKey(this.restrict_buchungen)) {
                    throw new IllegalArgumentException("Einschr\u00e4nkung mit ID " + this.restrict_buchungen + " nicht in Sx_repository definiert!");
                }
                ric = (RepositoryItemCollection)SxFinRechte.this.repository.get(this.restrict_buchungen);
                add = ric.getContent();
                r.append(" " + add + " ");
            }
            r.append(") ");
            return r.toString();
        }

        private void addKapitel(StringBuffer r) {
            if (this.isKapitelAllRights()) {
                r.append("k%");
            } else {
                r.append("k" + StringUtils.replace(this.kapitel, "*", "%"));
            }
        }

        private void addTitelUtK1K2K3K4(StringBuffer r) {
            if ((this.titel.startsWith("-") || SxFinRechte.this.is0FINJoker && this.titel.equals("0")) && this.isUtAllRights() && this.isK1AllRights() && this.isK2AllRights() && this.isK3AllRights() && this.isK4AllRights()) {
                r.append("%");
            } else {
                if (this.titel.startsWith("-")) {
                    r.append("t%");
                } else {
                    r.append("t" + StringUtils.replace(this.titel, "*", "%"));
                }
                this.addUtK1K2K3K4(r);
            }
            r.append("' ");
        }

        private void addUtK1K2K3K4(StringBuffer r) {
            if (this.isUtAllRights()) {
                r.append("ut%");
            } else {
                r.append("ut" + StringUtils.replace(this.untertitel, "*", "%"));
            }
            this.addK1K2K3K4(r);
        }

        private void addK1K2K3K4(StringBuffer r) {
            if (this.isK1AllRights()) {
                r.append("k1:%");
            } else {
                r.append("k1:" + StringUtils.replace(this.k1, "*", "%"));
            }
            if (this.isK2AllRights()) {
                r.append("k2:%");
            } else {
                r.append("k2:" + StringUtils.replace(this.k2, "*", "%"));
            }
            if (this.isK3AllRights()) {
                r.append("k3:%");
            } else {
                r.append("k3:" + StringUtils.replace(this.k3, "*", "%"));
            }
            if (this.isK4AllRights()) {
                r.append("k4:%");
            } else {
                r.append("k4:" + StringUtils.replace(this.k4, "*", "%"));
            }
        }
    }
}

